/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLResources;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportAPI;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;

public class XSQuick
extends ExportService {
    ExportParms _eParms;

    @Override
    public ExitCode start(ExportParms eParms, IToolRunMode tRunMode) {
        super.start(eParms, tRunMode);
        try {
            ExtractListModel listModel = new ExtractListModel(eParms.getSourceDBObjectList());
            DDLFormat ddlFormat = new DDLFormat();
            ddlFormat.isExtractEnabled(true);
            listModel.setDDLFormat(ddlFormat);
            DDLTypes _ddlTypes = listModel.getDDLTypes();
            List<ExtractObject> preSelectedEOList = listModel.getList(0, new int[]{107});
            _ddlTypes.setTypes(preSelectedEOList);
            listModel.setDDLTypes(_ddlTypes);
            listModel.clearSelectExtractData();
            this.setExtractListModel(listModel);
            TargetFormat targetFormat = new TargetFormat(1, 1);
            targetFormat.isCompressed(false);
            int saveAsType = eParms.getSaveAsType();
            targetFormat.setSaveAsType(saveAsType);
            if (saveAsType == 4) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_WORKSHEET"));
            } else if (saveAsType == 5) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_CLIPBOARD"));
            } else {
                targetFormat.setSaveAs(eParms.getSaveAs());
            }
            this.setTargetFormat(targetFormat);
        }
        catch (Exception e) {
            Logger.warn(ExportAPI.class, (Throwable)e);
            this.eLogException(e);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(e.getLocalizedMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    @Override
    public ExitCode validate() {
        return ExitCode.EXIT_SUCCESS;
    }

    @Override
    public void export() throws Exception {
        SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
        this.getGenOutput().startPreamble(ExportResources.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
        this.getGenOutput().endPreamble();
        this.writeExportDBObjects();
    }
}

