/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

import java.io.IOException;
import java.util.Vector;
import oracle.dss.util.xdo.common.io.ByteArray;
import oracle.dss.util.xdo.common.io.LE;
import oracle.dss.util.xdo.common.log.Logger;
import oracle.dss.util.xdo.common.pdf.filter.DeflateFilter;
import oracle.dss.util.xdo.common.pdf.filter.InflateFilter;
import oracle.dss.util.xdo.common.util.Bin;
import oracle.dss.util.xdo.common.util.Hex;
import oracle.dss.util.xdo.template.flash.AS3Int;
import oracle.dss.util.xdo.template.flash.BMSearch;
import oracle.dss.util.xdo.template.flash.RECT;
import oracle.dss.util.xdo.template.flash.SWFReader;
import oracle.dss.util.xdo.template.flash.Tag;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

public class FlashProcessorEngine {
    private String mRootTagName = "data";
    private Vector mTags = null;
    private float mWidth;
    private float mHeight;

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public byte[] merge(byte[] template, byte[] data) throws IOException {
        byte[] uncompressed;
        byte[] compressed;
        try {
            data = this.convertDataToUTF8(data);
        }
        catch (Exception e) {
            Logger.log(e);
            return template;
        }
        int s0 = template[0] & 0xFF;
        int s1 = template[1] & 0xFF;
        int s2 = template[2] & 0xFF;
        if (s0 == 67 && s1 == 87 && s2 == 83) {
            len = template.length;
            compressed = new byte[len - 8];
            System.arraycopy(template, 8, compressed, 0, len - 8);
            uncompressed = InflateFilter.inflate(compressed);
        } else if (s0 == 70 && s1 == 87 && s2 == 83) {
            len = template.length;
            uncompressed = new byte[len - 8];
            System.arraycopy(template, 8, uncompressed, 0, len - 8);
        } else {
            Logger.log("This is not a swf file.", 5);
            return template;
        }
        this.parseTags(uncompressed);
        ByteArray in = new ByteArray(uncompressed);
        String rootStartTag = "<" + this.mRootTagName + ">";
        boolean found = BMSearch.search(in, rootStartTag);
        if (!found) {
            in.seek(0L);
            rootStartTag = "<" + this.mRootTagName + " ";
            found = BMSearch.search(in, rootStartTag);
            if (!found) {
                Logger.log("Seed data in template is not found.", 5);
                return template;
            }
        }
        int orgDataPos = (int)in.getFilePointer() - rootStartTag.length();
        Logger.log("Data position=" + Hex.hex(orgDataPos + 8), 1);
        String rootEndTag = "</" + this.mRootTagName + ">";
        found = BMSearch.search(in, rootEndTag);
        if (!found) {
            Logger.log("Seed data might be corrupted. Seed data must end with" + rootEndTag, 5);
            return template;
        }
        int orgDataEndPos = (int)in.getFilePointer();
        int dataSizeLen = this.getDataSizeLen(uncompressed, orgDataPos, orgDataEndPos);
        int orgDataLen = AS3Int.toInt(uncompressed, orgDataPos -= dataSizeLen) + dataSizeLen;
        byte[] dataLenBytes = AS3Int.toByteArray(data.length);
        byte[] newData = Bin.concat(dataLenBytes, data);
        byte[] newUncompressed = Bin.replace(uncompressed, orgDataPos, orgDataLen, newData);
        int tagStart = 0;
        for (int i = 0; i < this.mTags.size(); ++i) {
            int pos = (Integer)this.mTags.elementAt(i);
            if (pos <= orgDataPos) continue;
            tagStart = (Integer)this.mTags.elementAt(i - 1);
            break;
        }
        Tag tag = new Tag(newUncompressed, tagStart);
        int tagType = tag.getType();
        int tagLen = tag.getLength();
        int tagHeaderSize = tag.getHeaderSize();
        Logger.log("Tag start=" + Hex.hex(tagStart) + ": " + Hex.dump(uncompressed, tagStart, tagHeaderSize), 1);
        Logger.log("Tag type=" + Hex.hex(tagType) + " Tag len =" + tagLen, 1);
        int newTagLen = tagLen + newData.length - orgDataLen;
        byte[] newTagHeader = Tag.generateHeaderBytes(tagType, newTagLen);
        Logger.log("New tag len =" + newTagLen, 1);
        Logger.log("New Tag  =" + Hex.hex(tagStart) + ": " + Hex.dump(newTagHeader), 1);
        newUncompressed = Bin.replace(newUncompressed, tagStart, tagHeaderSize, newTagHeader);
        compressed = DeflateFilter.deflate(newUncompressed);
        byte[] swf = new byte[8 + compressed.length];
        LE.writeInt32(8 + newUncompressed.length, template, 4);
        System.arraycopy(template, 0, swf, 0, 8);
        swf[0] = 67;
        System.arraycopy(compressed, 0, swf, 8, compressed.length);
        return swf;
    }

    private int getDataSizeLen(byte[] data, int pos, int endPos) {
        int i;
        Logger.log("Data size=" + (endPos - pos) + "(guess)", 1);
        int[] len = new int[6];
        for (i = 1; i <= 5; ++i) {
            len[i] = AS3Int.size(data, pos - i) == i ? AS3Int.toInt(data, pos - i) : -1;
            Logger.log("len[" + i + "]=" + len[i], 1);
        }
        int aSize = endPos - pos;
        int nearest = 1;
        int nearestDiff = 1000;
        for (i = 1; i <= 5; ++i) {
            int diff;
            if (len[i] == -1 || (diff = Math.abs(len[i] - aSize)) >= nearestDiff) continue;
            nearest = i;
        }
        Logger.log("nearest=" + len[nearest] + " data-size-len=" + nearest + "bytes", 1);
        return nearest;
    }

    private byte[] convertDataToUTF8(byte[] data) throws XMLParseException, SAXException, IOException {
        return null;
    }

    private void parseTags(byte[] data) {
        SWFReader sr = new SWFReader(data, 0);
        RECT rect = sr.readRECT();
        int r1 = sr.readUI8();
        int r2 = sr.readUI8();
        int fc = sr.readUI16();
        this.mWidth = rect.mXmax / 20;
        this.mHeight = rect.mYmax / 20;
        this.mTags = new Vector();
        while (!sr.isEOF()) {
            int tagPos = sr.getBytePosition();
            int tagHeader = sr.readUI16();
            int tag = SWFReader.readBits(tagHeader << 16, 0, 9);
            int len = SWFReader.readBits(tagHeader << 16, 10, 15);
            if (len == 63) {
                len = sr.readSI32();
            }
            this.mTags.addElement(tagPos);
            Logger.log("[TAG(" + Hex.hex(tag) + ")] pos=" + Hex.hex(tagPos) + " len=" + len, 1);
            sr.skipBytes(len);
        }
    }
}

