/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import oracle.dss.util.xdo.common.io.RandomAccessFileOrMemory;

public class BMSearch {
    public static boolean search(RandomAccessFileOrMemory in, String keyword) throws IOException {
        int size;
        byte[] key = keyword.getBytes("ISO-8859-1");
        byte[] buf = new byte[key.length];
        int keyLen = key.length;
        Hashtable<Byte, Integer> skipTable = new Hashtable<Byte, Integer>();
        for (int i = 0; i < keyLen; ++i) {
            Byte b = key[i];
            int skip = keyLen - i - 1;
            skipTable.put(b, skip);
        }
        int shift = keyLen;
        while ((size = BMSearch.shiftAndRead(buf, shift, in)) == shift) {
            Integer s = (Integer)skipTable.get(buf[keyLen - 1]);
            if (s == null) {
                shift = keyLen;
                continue;
            }
            shift = s;
            if (shift != 0) continue;
            if (BMSearch.match(key, buf, keyLen)) {
                return true;
            }
            shift = 1;
        }
        return false;
    }

    private static int shiftAndRead(byte[] data, int shift, RandomAccessFileOrMemory in) throws IOException {
        int len = data.length;
        for (int i = shift; i < len; ++i) {
            data[i - shift] = data[i];
        }
        int size = in.read(data, len - shift, shift);
        return size;
    }

    public static boolean search(InputStream in, String keyword) throws IOException {
        int size;
        byte[] key = keyword.getBytes("ISO-8859-1");
        byte[] buf = new byte[key.length];
        int keyLen = key.length;
        Hashtable<Byte, Integer> skipTable = new Hashtable<Byte, Integer>();
        for (int i = 0; i < keyLen; ++i) {
            Byte b = key[i];
            int skip = keyLen - i - 1;
            skipTable.put(b, skip);
        }
        int shift = keyLen;
        while ((size = BMSearch.shiftAndRead(buf, shift, in)) == shift) {
            Integer s = (Integer)skipTable.get(buf[keyLen - 1]);
            if (s == null) {
                shift = keyLen;
                continue;
            }
            shift = s;
            if (shift != 0) continue;
            if (BMSearch.match(key, buf, keyLen)) {
                return true;
            }
            shift = 1;
        }
        return false;
    }

    private static int shiftAndRead(byte[] data, int shift, InputStream in) throws IOException {
        int len = data.length;
        for (int i = shift; i < len; ++i) {
            data[i - shift] = data[i];
        }
        int size = in.read(data, len - shift, shift);
        return size;
    }

    private static boolean match(byte[] d1, byte[] d2, int len) {
        for (int i = 0; i < len; ++i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return true;
    }
}

