/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ColumnValue;
import oracle.adfinternal.model.dvt.util.transform.CommonComparator;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.javatools.annotations.Concealed;
import oracle.sql.NUMBER;

@Concealed
public class ColumnValues
implements Cloneable {
    private final ColumnValue[] m_values;
    private boolean m_sorted = false;

    public ColumnValues(ColumnValue[] values) {
        this.m_values = values;
    }

    public int getLength() {
        return this.m_values != null ? this.m_values.length : 0;
    }

    public boolean hasColumn(String col) {
        if (this.m_values != null) {
            for (ColumnValue value : this.m_values) {
                if (value == null || !value.getColumn().equals(col)) continue;
                return true;
            }
        }
        return false;
    }

    public String getColumn(int i) {
        if (this.m_values != null && this.m_values.length > i) {
            return this.m_values[i].getColumn();
        }
        return null;
    }

    public Object getValue(int i) throws TransformException {
        if (this.m_values != null && this.m_values.length > i) {
            return this.m_values[i].getValue();
        }
        return null;
    }

    public boolean isIgnoredColumn(int i) {
        if (this.m_values != null && this.m_values.length > i) {
            return this.m_values[i].isIgnoredColumn();
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnValue[] newColVal = null;
        if (this.m_values != null) {
            newColVal = new ColumnValue[this.m_values.length];
            for (int i = 0; i < this.m_values.length; ++i) {
                newColVal[i] = this.m_values[i];
            }
            return newColVal;
        }
        return new ColumnValues(newColVal);
    }

    public int hashCode() {
        int code = 0;
        if (this.m_values != null) {
            try {
                String col = null;
                Object value = null;
                for (ColumnValue cv : this.m_values) {
                    if (cv == null) continue;
                    col = cv.getColumn();
                    value = cv.getValue();
                    code += (value != null ? value.hashCode() : 0) + (col != null ? col.hashCode() : 0);
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return code;
    }

    public boolean equals(Object colMembers) {
        if (!(colMembers instanceof ColumnValues)) {
            return false;
        }
        ColumnValues colVal2 = (ColumnValues)colMembers;
        if (this.m_values == null && colVal2.m_values == null) {
            return true;
        }
        if (this.m_values == null) {
            return false;
        }
        if (colMembers != null) {
            Object dataval1 = null;
            Object dataval2 = null;
            for (int i = 0; i < this.m_values.length; ++i) {
                if (this.m_values[i] == null) continue;
                try {
                    dataval2 = colVal2.getColumnValue(this.m_values[i].getColumn());
                    dataval1 = this.m_values[i].getValue();
                }
                catch (TransformException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
                if (!(dataval1 == null ? dataval2 != null : !dataval1.equals(dataval2))) continue;
                return false;
            }
        }
        return true;
    }

    public Object getColumnValue(String column) throws TransformException {
        if (this.m_values == null) {
            return null;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            if (!column.equals(this.m_values[i].getColumn())) continue;
            return this.m_values[i].getValue();
        }
        return null;
    }

    public Object getMedian() {
        this.sort();
        int valCount = this.m_values.length;
        if (valCount == 0) {
            return null;
        }
        if ((double)(valCount / 2) == (double)valCount / 2.0) {
            Object val1 = null;
            Object val2 = null;
            try {
                val1 = this.m_values[valCount / 2 - 1].getValue();
                val2 = this.m_values[valCount / 2].getValue();
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            try {
                if (val1 instanceof BigInteger && val2 instanceof BigInteger) {
                    return ((BigInteger)val1).add((BigInteger)val2).divide(BigInteger.valueOf(2L));
                }
                if (val1 instanceof BigDecimal && val2 instanceof BigDecimal) {
                    return ((BigDecimal)val1).add((BigDecimal)val2).divide(BigDecimal.valueOf(2L));
                }
                if (val1 instanceof Number && val2 instanceof Number) {
                    return (((Number)val1).doubleValue() + ((Number)val2).doubleValue()) / 2.0;
                }
                if (val1 instanceof NUMBER && val2 instanceof NUMBER) {
                    return ((NUMBER)val1).add((NUMBER)val2).div(new NUMBER(2));
                }
                return null;
            }
            catch (SQLException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        try {
            Object obj = this.m_values[this.m_values.length / 2].getValue();
            if (!(obj instanceof String) && !(obj instanceof Date)) {
                return obj;
            }
            return null;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    public void sort() {
        if (this.m_sorted) {
            return;
        }
        Arrays.sort(this.m_values, new CommonComparator(0, false));
        for (int i = 0; i < this.m_values.length; ++i) {
            this.m_values[i].setIndex(i);
        }
        this.m_sorted = true;
    }
}

