/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationException;

public class IndexColumnExpressionsPanel
extends ChildTableEditorPanel<IndexObject, DBObject> {
    public IndexColumnExpressionsPanel() {
        super("IndexColumnExpressionsPanel");
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"expressionSource", "orderType"};
    }

    @Override
    protected Class<IndexObject> getChildClass() {
        return IndexObject.class;
    }

    @Override
    protected IndexObject newChild() {
        IndexObject[] indexObjectArray;
        IndexObject indexObject = (IndexObject)this.getProvider().getObjectFactory().newObject(IndexObject.class);
        TemporaryObjectID.setID((DBObject)indexObject, (boolean)true);
        Object t = this.getUpdatedObject();
        PropertyHelper propertyHelper = this.getPropertyHelper();
        String string = this.getChildProperty();
        IndexObject[] indexObjectArray2 = (IndexObject[])propertyHelper.getPropertyValue(t, string);
        if (indexObjectArray2 == null) {
            indexObjectArray = new IndexObject[]{indexObject};
        } else {
            indexObjectArray = new IndexObject[indexObjectArray2.length + 1];
            System.arraycopy(indexObjectArray2, 0, indexObjectArray, 0, indexObjectArray2.length);
            indexObjectArray[indexObjectArray2.length] = indexObject;
        }
        propertyHelper.setPropertyValue(t, string, (Object)indexObjectArray);
        Relation relation = (Relation)DBUtil.findParentOfType(t, Relation.class);
        if (relation != null) {
            boolean bl = false;
            DBObjectProvider dBObjectProvider = this.getProvider();
            for (Column column : relation.getColumns()) {
                indexObject.setExpression((SQLFragment)new ColumnUsage(column.getID()));
                try {
                    dBObjectProvider.validateObjectProperty(t, this.getChildProperty());
                    bl = true;
                    break;
                }
                catch (MissingValidatorException missingValidatorException) {
                    bl = true;
                    break;
                }
                catch (ValidationException validationException) {
                }
            }
            if (!bl) {
                indexObject.setExpressionSource(null);
            }
        }
        return indexObject;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.enableButtons();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
    }

    @Override
    public boolean canAddRow() {
        Object t = this.getUpdatedObject();
        if (t instanceof Index && t.getParent() == null) {
            return false;
        }
        return super.canAddRow();
    }

    @Override
    protected boolean shouldValidateOnExit() {
        return !(this.getUpdatedObject() instanceof Index);
    }
}

