/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.LocalIndexPartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class LocalIndexPartitionTreeEditorPanel
extends AbstractPartitionTreeEditorPanel<IndexPartition, Index> {
    private static final String[] PROPERTIES = new String[]{PartitionProperty.INDEX_PARTITIONS, PartitionProperty.SUBPARTITIONS_FOR_INDEX_PARTITION};
    private ActionListener m_defPartitionsListener;
    private Collection<IndexPartition> m_partitions;
    private JCheckBox m_checkbox;

    LocalIndexPartitionTreeEditorPanel() {
        super("LocalIndexPartitionTreeEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("INDEX_PARTITIONS_LIST_LABEL");
    }

    @Override
    protected ChildObjectEditorPanel<IndexPartition, Index> createChildPanel() {
        return new LocalIndexPartitionDetailsPanel();
    }

    @Override
    public void setDefinePartitionsCheckbox(JCheckBox jCheckBox) {
        boolean bl;
        Index index;
        Index index2 = (Index)this.getUpdatedObject();
        if (this.getProvider() instanceof Database) {
            index = (Index)TemporaryObjectID.findOriginalObject((DBObject)index2);
            OracleIndexPartitions oracleIndexPartitions = index == null ? null : (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
            bl = oracleIndexPartitions == null;
        } else {
            bl = true;
        }
        index = (OracleIndexPartitions)index2.getProperty("OracleIndexPartitions");
        boolean bl2 = index.getPartitions().length > 0;
        Table table = (Table)DBUtil.findParentOfType((DBObject)index2, Table.class);
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        boolean bl3 = oracleTablePartitions != null && (oracleTablePartitions.getPartitions() != null && oracleTablePartitions.getPartitions().length > 0 || oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH);
        jCheckBox.setVisible(bl);
        jCheckBox.setEnabled(bl2 || bl3);
        jCheckBox.setSelected(bl2);
        this.addActionListenerToDefineCheckbox(jCheckBox);
        this.m_checkbox = jCheckBox;
        super.setDefinePartitionsCheckbox(jCheckBox);
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"name"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = TreeNodeMaker.findNode(LocalIndexPartitionTreeEditorPanel.this.getCurrentChild(), (DefaultMutableTreeNode)LocalIndexPartitionTreeEditorPanel.this.getTreeModel().getRoot());
                LocalIndexPartitionTreeEditorPanel.this.getTreeModel().nodeChanged(defaultMutableTreeNode);
            }
        };
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"OracleIndexPartitions"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                LocalIndexPartitionTreeEditorPanel.this.m_partitions = null;
            }
        };
    }

    private void addActionListenerToDefineCheckbox(JCheckBox jCheckBox) {
        if (jCheckBox != null) {
            jCheckBox.removeActionListener(this.m_defPartitionsListener);
            jCheckBox.addActionListener(this.m_defPartitionsListener);
        }
    }

    @Override
    protected void populateComponent() {
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        if (indexPartitionArray == null || indexPartitionArray.length == 0) {
            indexPartitionArray = this.getIndexPartitionsFromTablePartitions(false);
        }
        if (indexPartitionArray != null) {
            for (IndexPartition indexPartition : indexPartitionArray) {
                this.addPartitionNode(indexPartition);
            }
        }
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.m_defPartitionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                LocalIndexPartitionTreeEditorPanel.this.refreshIndexPartitionsTree(jCheckBox.isSelected());
            }
        };
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        if (oracleIndexPartitions.getPartitions().length == 0) {
            this.refreshIndexPartitionsTree(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.getDefinePartitionsCheckbox().removeActionListener(this.m_defPartitionsListener);
    }

    @Override
    protected Class<IndexPartition> getChildClass() {
        return IndexPartition.class;
    }

    @Override
    protected final String getChildProperty() {
        int n = this.getLevel();
        return n == -1 ? null : PROPERTIES[n];
    }

    @Override
    protected ListButtons createListButtons() {
        return new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeAddRemoveButtons() {
                return false;
            }

            @Override
            public boolean includeReorderButtons() {
                return false;
            }
        };
    }

    protected IndexPartition[] getChildren() {
        return this.getChildrenImpl(true);
    }

    private IndexPartition[] getChildrenImpl(boolean bl) {
        SelectableComponent selectableComponent = this.getSelectableComponent();
        int n = selectableComponent.getSelectedIndex();
        DBObject dBObject = (DBObject)selectableComponent.get(n);
        Object object = n < 0 ? this.getUpdatedObject() : (bl ? (DBObject)selectableComponent.getParent(dBObject) : dBObject);
        return this.getPartitions((DBObject)object);
    }

    private IndexPartition[] getPartitions(DBObject dBObject) {
        SelectableComponent selectableComponent = this.getSelectableComponent();
        Object[] objectArray = selectableComponent.getChildren(dBObject);
        int n = objectArray == null ? 0 : objectArray.length;
        IndexPartition[] indexPartitionArray = new IndexPartition[]{};
        if (n > 0 && objectArray[0] instanceof IndexPartition) {
            indexPartitionArray = new IndexPartition[n];
            System.arraycopy(objectArray, 0, indexPartitionArray, 0, n);
        }
        return indexPartitionArray;
    }

    @Override
    protected void commitChildPropertyImpl(boolean bl) {
    }

    private DefaultMutableTreeNode addPartitionNode(IndexPartition indexPartition) {
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(indexPartition);
        defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
        IndexPartition[] indexPartitionArray = (IndexPartition[])this.getPropertyHelper().getPropertyValue((Object)indexPartition, PartitionProperty.INDEX_SUBPARTITIONS);
        this.addSubpartitionNodes(defaultMutableTreeNode2, indexPartitionArray);
        int n = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode, defaultMutableTreeNode2);
        this.getTree().expandRow(n);
        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{n});
        return defaultMutableTreeNode2;
    }

    private void addSubpartitionNodes(DefaultMutableTreeNode defaultMutableTreeNode, IndexPartition[] indexPartitionArray) {
        if (indexPartitionArray != null) {
            for (IndexPartition indexPartition : indexPartitionArray) {
                defaultMutableTreeNode.insert(new DefaultMutableTreeNode(indexPartition), defaultMutableTreeNode.getChildCount());
            }
        }
    }

    private IndexPartition[] getIndexPartitionsFromTablePartitions(boolean bl) {
        Table table = (Table)((Index)this.getUpdatedObject()).getParent();
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (bl || this.m_partitions == null) {
            this.m_partitions = new ArrayList<IndexPartition>();
            if (oracleTablePartitions != null) {
                TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
                Object object = tablePartitionArray;
                int n = ((TablePartition[])object).length;
                for (int i = 0; i < n; ++i) {
                    TablePartition tablePartition = object[i];
                    IndexPartition indexPartition = LocalIndexPartitionHelper.createLocalIndexPartition((TablePartition)tablePartition, (String)tablePartition.getName());
                    this.m_partitions.add(indexPartition);
                }
                if (tablePartitionArray.length == 0 && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH && (object = Integer.valueOf(oracleTablePartitions.getHashQuantity() == null ? 1 : oracleTablePartitions.getHashQuantity())) != null && (Integer)object > 0) {
                    for (n = 1; n <= (Integer)object; ++n) {
                        IndexPartition indexPartition = new IndexPartition("PARTITION" + n, null);
                        this.m_partitions.add(indexPartition);
                    }
                }
            }
        }
        return this.m_partitions.toArray(new IndexPartition[this.m_partitions.size()]);
    }

    private void refreshIndexPartitionsTree(boolean bl) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        int n = this.getSelectableComponent().getSelectedIndex();
        if (bl) {
            object = this.getIndexPartitionsFromTablePartitions(false);
            for (IndexPartition indexPartition : object) {
                oracleIndexPartitions.addPartition(indexPartition);
                DefaultMutableTreeNode defaultMutableTreeNode2 = TreeNodeMaker.findNode(indexPartition, defaultMutableTreeNode);
                defaultMutableTreeNode2.setUserObject(indexPartition);
                this.getTreeModel().nodeStructureChanged(defaultMutableTreeNode2);
            }
            if (n > -1) {
                IndexPartition indexPartition = (IndexPartition)this.getSelectableComponent().get(n);
                this.selectChild(indexPartition);
                this.listSelectionChanged();
                this.getListButtons().enableButtons();
            }
        } else {
            defaultMutableTreeNode.removeAllChildren();
            this.getTreeModel().nodeStructureChanged(defaultMutableTreeNode);
            object = this.getIndexPartitionsFromTablePartitions(true);
            for (IndexPartition indexPartition : object) {
                this.addPartitionNode(indexPartition);
            }
            oracleIndexPartitions.setPartitions(null);
            if (((Object)object).length > 0 && n > -1) {
                IndexPartition indexPartition = (IndexPartition)this.getSelectableComponent().get(n);
                this.selectChild(indexPartition);
                this.listSelectionChanged();
            }
            TreeNodeMaker.expandAll(this.getTree());
        }
        object = (LocalIndexPartitionDetailsPanel)this.getChildPanel();
        ((LocalIndexPartitionDetailsPanel)object).initialisePanel();
    }
}

