/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.ide.controls.FlatEditorTransparentPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.MutExChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.Pair;

public abstract class MutExChildObjectEditorControlPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final List<String> m_panelTitles = new ArrayList<String>();
    private final Map<String, MutExChildObjectEditorPanel<C, P>> m_panelMap = new HashMap<String, MutExChildObjectEditorPanel<C, P>>();
    private final JComboBox m_chooser = new JComboBox();
    private final ActionListener m_chooserListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MutExChildObjectEditorControlPanel.this.switchPanels(true);
        }
    };
    private JPanel m_container = new JPanel(new GridBagLayout());
    private final GridBagConstraints m_containerGBC = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
    private MutExChildObjectEditorPanel<C, P> m_currentPanel;

    protected MutExChildObjectEditorControlPanel(String string) {
        this(null, string);
    }

    protected MutExChildObjectEditorControlPanel(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected final void initialiseChildComponents() {
        Object object2;
        String string = this.getTitleForNullOption();
        if (string != null) {
            this.addPanel(new BlankPanel(), string);
        }
        for (Object object2 : this.getPanelsAndTitles()) {
            this.addPanel((MutExChildObjectEditorPanel)object2.getFirst(), (String)object2.getSecond());
        }
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        object2 = new JPanel();
        this.creatIdentityPanel((JPanel)object2);
        if (!this.isInFlatEditor()) {
            JScrollPane jScrollPane = new JScrollPane((Component)object2, 20, 31);
            jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            dBUILayoutHelper.add(jScrollPane);
        } else {
            dBUILayoutHelper.add((Component)object2, 1, 1, true, true);
        }
        dBUILayoutHelper.layout();
    }

    protected abstract String getLabelForChooser();

    protected String getTitleForNullOption() {
        return UIBundle.get("MUTEX_CHILD_OPTION_NONE");
    }

    protected List<Pair<MutExChildObjectEditorPanel<C, P>, String>> getPanelsAndTitles() {
        return Collections.emptyList();
    }

    private void addPanel(MutExChildObjectEditorPanel<C, P> mutExChildObjectEditorPanel, String string) {
        if (this.m_panelTitles.contains(string)) {
            throw new IllegalStateException("Panel with title " + string + " already added");
        }
        this.m_panelTitles.add(string);
        this.m_panelMap.put(string, mutExChildObjectEditorPanel);
    }

    private void switchPanels(boolean bl) {
        MutExChildObjectEditorPanel<C, P> mutExChildObjectEditorPanel = this.m_panelMap.get(this.m_chooser.getSelectedItem());
        if (mutExChildObjectEditorPanel != this.m_currentPanel) {
            if (this.m_currentPanel != null) {
                try {
                    this.m_currentPanel.onExit((TraversableContext)this.getDataContext());
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
                if (bl) {
                    this.m_currentPanel.clearProperty(this.getChildObject());
                }
                this.m_container.remove((Component)((Object)this.m_currentPanel));
            }
            this.m_currentPanel = mutExChildObjectEditorPanel;
            this.m_container.add((Component)((Object)this.m_currentPanel), this.m_containerGBC);
            if (bl) {
                this.m_currentPanel.initialiseProperty(this.getChildObject(), this.getEditorConfig());
            }
        }
        if (this.m_currentPanel != null) {
            this.m_currentPanel.onEntry((TraversableContext)this.getDataContext());
        }
        this.m_container.revalidate();
        this.m_container.repaint();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.m_chooser.removeActionListener(this.m_chooserListener);
        this.m_chooser.removeAllItems();
        Object c = this.getChildObject();
        boolean bl = false;
        boolean bl2 = false;
        if (c != null) {
            for (String string : this.m_panelTitles) {
                boolean bl3;
                MutExChildObjectEditorPanel mutExChildObjectEditorPanel = this.m_panelMap.get(string);
                boolean bl4 = bl3 = !bl && mutExChildObjectEditorPanel.accept(c);
                if (!bl3 && !this.isValidPanel(mutExChildObjectEditorPanel, c, this.getEditorConfig())) continue;
                this.m_chooser.addItem(string);
                if (bl3) {
                    this.m_chooser.setSelectedItem(string);
                    bl = true;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            if (!bl) {
                this.m_chooser.setSelectedIndex(0);
            }
            this.switchPanels(false);
        }
        this.m_chooser.addActionListener(this.m_chooserListener);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.m_currentPanel != null) {
            this.m_currentPanel.commitPanel();
        }
    }

    private boolean isValidPanel(MutExChildObjectEditorPanel<C, P> mutExChildObjectEditorPanel, C c, DBEditorConfig dBEditorConfig) {
        boolean bl = true;
        String string = mutExChildObjectEditorPanel.getChildValidationProperty();
        if (string != null) {
            ChildDBObject childDBObject = (ChildDBObject)c.copyTo(null, true);
            for (String string2 : this.m_panelTitles) {
                this.m_panelMap.get(string2).clearProperty(childDBObject);
            }
            mutExChildObjectEditorPanel.initialiseProperty(childDBObject, dBEditorConfig);
            try {
                dBEditorConfig.getProvider().validateObjectProperty((DBObject)childDBObject, string);
            }
            catch (ValidationException validationException) {
                bl = false;
            }
        }
        return bl;
    }

    private void creatIdentityPanel(JPanel jPanel) {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel, this.isInFlatEditor());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_chooser, (String)this.getLabelForChooser());
        dBUILayoutHelper.add(jLabel);
        dBUILayoutHelper.add(this.m_chooser);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_container, 2, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.layout();
    }

    private class BlankPanel
    extends MutExChildObjectEditorPanel<C, P> {
        BlankPanel() {
            super(null, null);
        }

        @Override
        public String getChildValidationProperty() {
            return null;
        }

        @Override
        public void initialiseProperty(C c, DBEditorConfig dBEditorConfig) {
        }

        @Override
        public void clearProperty(C c) {
        }

        @Override
        public boolean accept(C c) {
            return false;
        }

        @Override
        protected void initialiseChildComponents() {
            if (this.getEditorConfig().isInFlatEditor()) {
                FlatEditorTransparentPanel.makeTransparent((JComponent)((Object)this));
            }
        }
    }
}

