/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.ora.PlSqlPanelLibrary;
import oracle.ideimpl.db.panels.xmlschema.XMLSchemaInfoPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.util.ModelUtil;

public class XMLSchemaPanelLibrary
extends PlSqlPanelLibrary {
    public XMLSchemaPanelLibrary() {
        super("XML SCHEMA");
    }

    @Override
    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        return bl ? null : Collections.emptyList();
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_odbxmlschema_html";
    }

    @Override
    public Class<? extends Traversable> getHeader() {
        return XMLSchemaInfoPanel.class;
    }

    @Override
    protected String getDefaultSource(DBObjectProvider dBObjectProvider, SchemaObject schemaObject) {
        String string = ((XMLSchema)schemaObject).getSource();
        if (!ModelUtil.hasLength((String)string)) {
            string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           xmlns:xdb=\"http://xmlns.oracle.com/xdb\"\n           version=\"1.0\">\n</xs:schema>";
        }
        return string;
    }

    @Override
    public boolean showEditorAfterCommit() {
        return true;
    }

    @Override
    public Dimension getSize(boolean bl) {
        return OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE;
    }

    @Override
    protected String initialiseSource(DBEditorConfig dBEditorConfig) {
        SchemaObject schemaObject = (SchemaObject)dBEditorConfig.getUpdatedObject();
        String string = this.getDefaultSource(dBEditorConfig.getProvider(), schemaObject);
        if (schemaObject instanceof XMLSchema) {
            ((XMLSchema)schemaObject).setSource(string);
        }
        return string;
    }

    @Override
    protected String getSource(SystemObject systemObject) {
        if (systemObject instanceof XMLSchema) {
            return ((XMLSchema)systemObject).getSource();
        }
        return null;
    }
}

