/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.util.ClassUtils;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.ora.sxml.SXMLCommentGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

public class DatabaseExtensionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-hook";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-hook");
    private final List<HashStructure> m_recogHashes = new CopyOnWriteArrayList<HashStructure>();
    private final Map<String, ExtensionPropertyInfo> m_propertyInfos = new ConcurrentHashMap<String, ExtensionPropertyInfo>();
    private final Map<String, HashStructure> m_typeDisplayHashes = new ConcurrentHashMap<String, HashStructure>();
    private final MultiMap<String, Thunk<DBURLFactory.Helper>> m_urlHelpHashes = new MultiMap(CopyOnWriteArrayList.class);

    public DatabaseExtensionHook() {
        this.init();
    }

    private void init() {
        DBCore.setExtensionInitializer((Runnable)new Runnable(){

            @Override
            public void run() {
                DatabaseExtensionHook.this.checkListenerInit();
            }
        });
        DBCore dBCore = DBCore.getInstance();
        dBCore.registerFactoryList(DatabaseFactory.ConnectionCreatorFactory.class, this.createChildList("connection-creator-factories", "connection-creator-factory", DatabaseFactory.ConnectionCreatorFactory.class));
        dBCore.registerFactoryMap(DBObjectProviderFactory.Creator.class, this.createChildMap("provider-creators", "provider-creator", "type", "class", DBObjectProviderFactory.Creator.class));
        dBCore.registerFactoryMap(DBObjectProviderFactory.Listener.class, this.createChildMap("provider-factory-listeners", "provider-factory-listener", "type", "class", DBObjectProviderFactory.Listener.class));
        dBCore.registerFactoryMap(DBObjectXMLHandler.class, this.createChildMap("object-xml-handlers", "object-xml-handler", "namespace", "class", DBObjectXMLHandler.class));
        dBCore.registerFactoryList(SXMLFragmentGenerator.class, this.createChildList("sxml-fragment-generators", "sxml-fragment-generator", SXMLFragmentGenerator.class));
        dBCore.registerFactoryList(SXMLCommentGenerator.class, this.createChildList("sxml-comment-generators", "sxml-comment-generator", SXMLCommentGenerator.class));
        Metadata.getInstance().registerProperties((Iterable)new Iterable<ExtensionPropertyInfo>(){

            @Override
            public Iterator<ExtensionPropertyInfo> iterator() {
                DatabaseExtensionHook.this.checkListenerInit();
                return DatabaseExtensionHook.this.m_propertyInfos.values().iterator();
            }
        });
        this.createChildList("url-factory-helpers", "url-factory-helper", DBURLFactory.Helper.class);
    }

    @Override
    protected void processHashStructure(HashStructure hashStructure) {
        Object object;
        Object object2;
        Object object3;
        HashStructure hashStructure2;
        Object object42;
        Object object5;
        Object object6;
        super.processHashStructure(hashStructure);
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "url-factory-helpers", "url-factory-helper")) {
            object6 = this.getText(hashStructure3, "type", false);
            if (object6 == null) {
                object6 = "db";
                object5 = hashStructure3;
            } else {
                object5 = hashStructure3.getHashStructure("class");
            }
            if (object5 == null) {
                this.logMissingElemError(hashStructure3, "url-factory-helper", "class");
                continue;
            }
            this.m_urlHelpHashes.add(object6, this.createInstanceThunk((HashStructure)object5, DBURLFactory.Helper.class));
        }
        this.m_recogHashes.addAll(this.getChildList(hashStructure, "node-recognizers", "node-recognizer"));
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "object-types", "object-type")) {
            object6 = this.getText(hashStructure3, "object-type");
            if (!ModelUtil.hasLength((String)object6)) continue;
            object5 = hashStructure3.getHashStructure("object-class");
            if (object5 == null) {
                this.logMissingElemError(hashStructure3, "object-type", "object-class");
            } else {
                DBObjectRegistry.getInstance().registerClass(object6, this.createClassThunk((HashStructure)object5, DBObject.class));
            }
            this.registerTypeDisplayHash((String)object6, hashStructure3);
        }
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "object-properties", "object-property")) {
            object6 = new ExtensionPropertyInfo(hashStructure3);
            if (!((ExtensionPropertyInfo)((Object)object6)).isValid()) continue;
            this.m_propertyInfos.put(((ExtensionPropertyInfo)((Object)object6)).getPropertyName(), (ExtensionPropertyInfo)((Object)object6));
            try {
                Metadata.getInstance().registerProperty((PropertyInfo)object6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logError(hashStructure, illegalArgumentException.getMessage());
            }
            if (((ExtensionPropertyInfo)((Object)object6)).isCopyFromTemplate()) continue;
            for (Object object42 : ((ExtensionPropertyInfo)((Object)object6)).getObjectClasses()) {
                TemplateExpander.registerPropertyToClear((Class)object42, (String)((ExtensionPropertyInfo)((Object)object6)).getPropertyName());
            }
        }
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "object-registry", "registry-entry")) {
            object6 = hashStructure3.getHashStructure("database-match");
            if (object6 == null) {
                this.logMissingElemError(hashStructure3, "registry-entry", "database-match");
                continue;
            }
            object5 = this.getText(hashStructure3, "object-type");
            object42 = this.createDatabaseMatcher((HashStructure)object6);
            hashStructure2 = this.createClassThunk(hashStructure3, "validator-class", DBObjectValidator.class);
            object3 = this.createClassThunk(hashStructure3, "builder-class", DBObjectBuilder.class);
            object2 = this.createClassThunk(hashStructure3, "lister-class", DBObjectLister.class);
            object = this.createClassThunk(hashStructure3, "ddl-generator-class", DDLGenerator.class);
            if (object5 == null || object42 == null || hashStructure2 == null || object3 == null || object2 == null || object == null) continue;
            DBObjectRegistry.getInstance().registerObject((String)object5, object42, (Thunk)hashStructure2, (Thunk)object3, (Thunk)object2, (Thunk)object);
        }
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "database-creators", "database-creator")) {
            object6 = this.getText(hashStructure3, "database-type", false);
            object5 = this.getSingleChildMeta(hashStructure3, "database-creator-class", DatabaseFactory.DatabaseCreator.class);
            if (object5 == null) {
                this.logMissingElemError(hashStructure3, "database-creator-class");
                continue;
            }
            object42 = null;
            hashStructure2 = hashStructure3.getHashStructure("connection-matcher");
            if (hashStructure2 != null) {
                object42 = this.createConnectionMatcher(hashStructure2, hashStructure3);
            }
            object3 = new ArrayList();
            object2 = this.getChildList(hashStructure3, "databases", "database");
            object = object2.iterator();
            while (object.hasNext()) {
                HashStructure hashStructure4 = (HashStructure)object.next();
                String string = this.getText(hashStructure4, "database-version", true);
                String string2 = this.getText(hashStructure4, "database-name", false);
                String string3 = this.getText(hashStructure4, "database-class", true);
                if (string3 == null || string == null) continue;
                try {
                    int n = Integer.parseInt(string);
                    object3.add(new DatabaseRegistry.DatabaseVersion(n, string2, string3));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logError(hashStructure4, numberFormatException.getMessage());
                }
            }
            if (!object3.isEmpty() && object6 == null) {
                this.logMissingElemError(hashStructure3, "database-type");
            }
            object = DatabaseRegistry.getInstance();
            object.registerDatabases(object6, object5.getClassName(), object5.getClassLoader(), (ConnectionMatcher)object42, object3.toArray(new DatabaseRegistry.DatabaseVersion[object3.size()]));
        }
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "property-display-bundles", "property-display-bundle")) {
            PropertyDisplayRegistry.getInstance().registerBundle(this.createInstanceThunk(hashStructure3, ResourceBundle.class));
        }
        for (HashStructure hashStructure3 : this.getChildList(hashStructure, "property-display-plugins", "property-display-plugin")) {
            PropertyDisplayRegistry.getInstance().registerPlugin(this.createInstanceThunk(hashStructure3, PropertyDisplayRegistry.Plugin.class));
        }
    }

    private ConnectionMatcher createConnectionMatcher(HashStructure hashStructure, HashStructure hashStructure2) {
        List<String> list = Arrays.asList("and", "or", "database-product-version", "database-product-name", "driver-name");
        ConnectionMatcher connectionMatcher = null;
        String string = hashStructure.getStructName();
        if ("connection-matcher".equals(string)) {
            String string2;
            Object object;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext() && (!((object = hashStructure.getObject(string2 = iterator.next())) instanceof HashStructure) || (connectionMatcher = this.createConnectionMatcher((HashStructure)object, hashStructure)) == null)) {
            }
        } else if ("and".equals(string) || "or".equals(string)) {
            ArrayList<ConnectionMatcher> arrayList = new ArrayList<ConnectionMatcher>();
            for (String string3 : list) {
                ConnectionMatcher connectionMatcher2;
                Object object = hashStructure.getObject(string3);
                if (!(object instanceof HashStructure) || (connectionMatcher2 = this.createConnectionMatcher((HashStructure)object, hashStructure)) == null) continue;
                arrayList.add(connectionMatcher2);
            }
            if (arrayList.isEmpty()) {
                this.logError(hashStructure, string + " expects child elements.");
            } else {
                connectionMatcher = ConnectionMatcher.matchAll((boolean)"and".equals(string), (ConnectionMatcher[])arrayList.toArray(new ConnectionMatcher[arrayList.size()]));
            }
        } else {
            String string4 = HashStructureHook.getText((HashStructure)hashStructure);
            if (string4 == null) {
                this.logMissingElemError(hashStructure2, string);
            } else if ("database-product-version".equals(string)) {
                connectionMatcher = ConnectionMatcher.matchDatabaseProductVersion((String)string4);
            } else if ("database-product-name".equals(string)) {
                connectionMatcher = ConnectionMatcher.matchDatabaseProductName((String)string4);
            } else if ("driver-name".equals(string)) {
                connectionMatcher = ConnectionMatcher.matchDriverName((String)string4);
            } else {
                this.logError(hashStructure, "Unexpected element " + string);
            }
        }
        return connectionMatcher;
    }

    private DatabaseMatcher createDatabaseMatcher(HashStructure hashStructure) {
        DatabaseMatcher databaseMatcher = null;
        String string = this.getText(hashStructure, "database-type");
        String string2 = this.getText(hashStructure, "database-version");
        String string3 = this.getText(hashStructure, "database-version-match");
        DatabaseMatcher.Comparison comparison = null;
        try {
            comparison = DatabaseMatcher.Comparison.valueOf((String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logError(hashStructure, illegalArgumentException.getMessage());
        }
        Integer n = null;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logError(hashStructure, numberFormatException.getMessage());
            }
        }
        if (string != null && n != null && comparison != null) {
            databaseMatcher = new DatabaseMatcher(string, n.intValue(), comparison);
            String string4 = this.getText(hashStructure, "test-system-property", false);
            databaseMatcher.setTestSystemProperty(string4);
        }
        return databaseMatcher;
    }

    private void registerTypeDisplayHash(String string, HashStructure hashStructure) {
        if (this.m_typeDisplayHashes.size() == 0) {
            DBTypeDisplayRegistry.addDBTypeRegistry(new HashDisplayRegistry());
        }
        this.m_typeDisplayHashes.put(string, hashStructure);
    }

    public ProviderNodeRecognizer findNodeRecognizer(Object object) {
        ProviderNodeRecognizer providerNodeRecognizer = null;
        if (object != null) {
            this.checkListenerInit();
            for (HashStructure hashStructure : this.m_recogHashes) {
                HashStructure hashStructure2;
                String string = hashStructure.getString("node-class/#text");
                if (!ClassUtils.isInstanceOf(object.getClass(), (String)string) || (hashStructure2 = hashStructure.getHashStructure("recognizer-class")) == null || (providerNodeRecognizer = this.instantiateClass(hashStructure2, ProviderNodeRecognizer.class)) == null) continue;
                break;
            }
        }
        return providerNodeRecognizer;
    }

    public Collection<DBURLFactory.Helper> getURLFactoryHelpers(String string) {
        this.checkListenerInit();
        ArrayList<DBURLFactory.Helper> arrayList = new ArrayList<DBURLFactory.Helper>();
        Collection collection = this.m_urlHelpHashes.get((Object)string);
        if (collection != null) {
            for (Thunk thunk : collection) {
                DBURLFactory.Helper helper = (DBURLFactory.Helper)thunk.get();
                if (helper == null) continue;
                arrayList.add(helper);
            }
        }
        return arrayList;
    }

    public String getExtensionPropertyDisplayName(String string, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        this.checkListenerInit();
        ExtensionPropertyInfo extensionPropertyInfo = string == null ? null : this.m_propertyInfos.get(string);
        return extensionPropertyInfo == null ? null : extensionPropertyInfo.getDisplayName();
    }

    public Collection<PropertyInfo> getAutoIncludedProperties(DBObjectProvider dBObjectProvider, Class<? extends DBObject> clazz) {
        PropertyCriteria propertyCriteria = new PropertyCriteria();
        propertyCriteria.setIncludeBean(false);
        propertyCriteria.addPredicate(propertyInfo -> propertyInfo instanceof ExtensionPropertyInfo && ((ExtensionPropertyInfo)((Object)propertyInfo)).isAutoInclude());
        Map map = dBObjectProvider.getPropertyManager().getPropertyInfos(clazz, propertyCriteria);
        return map.values();
    }

    public static synchronized DatabaseExtensionHook getHook() {
        return DatabaseExtensionHook.findHook(NAME, DatabaseExtensionHook.class);
    }

    public class ExtensionPropertyInfo
    extends PropertyInfo {
        private final HashStructure m_hash;
        private List<Class<? extends DBObject>> m_objClzs;

        ExtensionPropertyInfo(HashStructure hashStructure) {
            this.m_hash = hashStructure;
        }

        boolean isValid() {
            boolean bl = true;
            String string = this.getPropertyName();
            if (ModelUtil.hasLength((String)string)) {
                if (!ModelUtil.hasLength((String)this.getDisplayName())) {
                    DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "display-name");
                    bl = false;
                }
                if (this.getPropertyClassName() == null) {
                    DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "property-class");
                    bl = false;
                }
            } else {
                DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "property-name");
                bl = false;
            }
            return bl;
        }

        public String getPropertyName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "property-name");
        }

        public String getDisplayName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "display-name");
        }

        String getPropertyClassName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "property-class");
        }

        public Class<? extends Object> getPropertyClass() {
            return DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "property-class", Object.class);
        }

        protected boolean equalsImpl(PropertyInfo propertyInfo) {
            return propertyInfo instanceof ExtensionPropertyInfo && this.m_hash == ((ExtensionPropertyInfo)propertyInfo).m_hash;
        }

        public Class getReferencedClass() {
            Class clazz = DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "referenced-class", DBObject.class);
            if (clazz == null) {
                clazz = super.getReferencedClass();
            }
            return clazz;
        }

        public Nullable.NullBehaviour getNullBehaviour() {
            String string;
            Nullable.NullBehaviour nullBehaviour = null;
            HashStructure hashStructure = this.m_hash.getHashStructure("null-behaviour");
            if (hashStructure != null && (string = HashStructureHook.getText((HashStructure)hashStructure)) != null) {
                try {
                    nullBehaviour = Nullable.NullBehaviour.valueOf((String)string);
                }
                catch (Exception exception) {
                    DatabaseExtensionHook.this.logError(hashStructure, exception.getMessage());
                }
            }
            return nullBehaviour == null ? super.getNullBehaviour() : nullBehaviour;
        }

        String getProviderClassName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "provider-class", false);
        }

        protected Class<? extends DBObjectProvider> getProviderClass() {
            return DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "provider-class", DBObjectProvider.class);
        }

        List<String> getObjectClassNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HashStructure hashStructure : DatabaseExtensionHook.this.getChildList(this.m_hash, "object-classes", "object-class")) {
                String string = HashStructureHook.getText((HashStructure)hashStructure);
                if (!ModelUtil.hasLength((String)string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        protected List<Class<? extends DBObject>> getObjectClasses() {
            if (this.m_objClzs == null) {
                for (HashStructure hashStructure : DatabaseExtensionHook.this.getChildList(this.m_hash, "object-classes", "object-class")) {
                    Class<DBObject> clazz = DatabaseExtensionHook.this.loadAPIClass(hashStructure, DBObject.class);
                    if (clazz == null) continue;
                    if (this.m_objClzs == null) {
                        this.m_objClzs = new ArrayList<Class<? extends DBObject>>();
                    }
                    this.m_objClzs.add(clazz);
                }
                if (this.m_objClzs == null) {
                    this.m_objClzs = Collections.singletonList(DBObject.class);
                }
            }
            return this.m_objClzs;
        }

        public boolean isStaticReference() {
            return Boolean.valueOf(DatabaseExtensionHook.this.getText(this.m_hash, "static-reference", false));
        }

        boolean isCopyFromTemplate() {
            String string = DatabaseExtensionHook.this.getText(this.m_hash, "copy-from-template", false);
            return string == null || Boolean.valueOf(string) != false;
        }

        boolean isAutoInclude() {
            String string = DatabaseExtensionHook.this.getText(this.m_hash, "auto-include-ui", false);
            return string != null && Boolean.valueOf(string) != false;
        }

        public boolean isSupported(Class<? extends DBObjectProvider> clazz, Class<? extends DBObject> clazz2) {
            Object object;
            if (clazz != null && (object = this.getProviderClassName()) != null && !DatabaseExtensionHook.this.isAssignableFrom((String)object, clazz)) {
                return false;
            }
            if (clazz2 != null && (object = this.getObjectClassNames()) != null && object.size() > 0) {
                boolean bl = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!DatabaseExtensionHook.this.isAssignableFrom(string, clazz2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            return true;
        }

        public DynamicPropertyProvider getDynamicPropertyProvider() {
            DynamicPropertyProvider dynamicPropertyProvider = null;
            HashStructure hashStructure = this.m_hash.getHashStructure("dynamic-property-provider");
            if (hashStructure != null) {
                dynamicPropertyProvider = DatabaseExtensionHook.this.instantiateClass(hashStructure, DynamicPropertyProvider.class);
            }
            return dynamicPropertyProvider;
        }
    }

    private class HashDisplayRegistry
    extends DBTypeDisplayRegistryEntry {
        private HashDisplayRegistry() {
        }

        @Override
        protected void populateEntries() {
        }

        private String getTextImpl(String string, String string2, boolean bl) {
            HashStructure hashStructure;
            String string3 = null;
            if (string != null && (hashStructure = DatabaseExtensionHook.this.m_typeDisplayHashes.get(string)) != null) {
                string3 = DatabaseExtensionHook.this.getText(hashStructure, string2, bl);
            }
            return string3;
        }

        @Override
        public String getDisplayName(String string) {
            return this.getTextImpl(string, "display-name", true);
        }

        @Override
        public String getSingularDisplayName(String string) {
            return this.getTextImpl(string, "singular-display-name", true);
        }

        @Override
        public String getNewMenuItemText(String string) {
            return this.getTextImpl(string, "new-menu-text", false);
        }

        private Icon getIconImpl(String string, String string2, boolean bl) {
            HashStructure hashStructure;
            Icon icon = null;
            if (string != null && (hashStructure = DatabaseExtensionHook.this.m_typeDisplayHashes.get(string)) != null) {
                icon = DatabaseExtensionHook.this.getIcon(hashStructure, string2, bl);
            }
            return icon;
        }

        @Override
        public Icon getNodeIcon(String string) {
            return this.getIconImpl(string, "node-icon", true);
        }

        @Override
        public Icon getFolderIcon(String string) {
            return this.getIconImpl(string, "folder-icon", false);
        }
    }
}

