/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.ide.db.insight.model.DataTypeProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.PropertyBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class PlSqlInsightDataProvider
extends DataTypeProvider {
    @Override
    public void addItems(DBObject dBObject) throws CancelledException {
        DBObject dBObject2;
        DataTypeUsage dataTypeUsage;
        int n;
        int n2;
        SchemaObject[] schemaObjectArray;
        PlSqlReference plSqlReference;
        SchemaObject[] schemaObjectArray2;
        if (dBObject instanceof PlSqlBlock) {
            schemaObjectArray2 = (SchemaObject[])dBObject;
            for (PlSqlReference plSqlReference22 : schemaObjectArray2.getSubPrograms()) {
                plSqlReference = plSqlReference22.getReturnTypeReference();
                if (this.isTargetClass(DBObject.class, true) && plSqlReference == null) continue;
                this.addDBObject((DBObject)plSqlReference22);
            }
            CancelledException.checkInterrupt();
            schemaObjectArray = schemaObjectArray2.getVariables();
            n2 = schemaObjectArray.length;
            for (n = 0; n < n2; ++n) {
                PlSqlVariable plSqlVariable = schemaObjectArray[n];
                this.addDBObject((DBObject)plSqlVariable);
            }
            CancelledException.checkInterrupt();
            if (this.isTargetClass(DataType.class, true) || this.isTargetClass(DataTypeUsage.class, true)) {
                schemaObjectArray = schemaObjectArray2.getDatatypes();
                n2 = schemaObjectArray.length;
                for (n = 0; n < n2; ++n) {
                    SchemaObject schemaObject = schemaObjectArray[n];
                    this.addDBObject((DBObject)schemaObject);
                }
            }
        }
        CancelledException.checkInterrupt();
        if (dBObject instanceof PlSqlSubProgram) {
            schemaObjectArray2 = (PlSqlSubProgram)dBObject;
            schemaObjectArray = schemaObjectArray2.getParameters();
            n2 = schemaObjectArray.length;
            for (n = 0; n < n2; ++n) {
                PlSqlVariable plSqlVariable = schemaObjectArray[n];
                this.addDBObject((DBObject)plSqlVariable);
            }
        }
        CancelledException.checkInterrupt();
        if (dBObject instanceof PlSqlDatum && (schemaObjectArray = (schemaObjectArray2 = (PlSqlDatum)dBObject).getDataTypeReference()) != null && (dataTypeUsage = schemaObjectArray.getDataTypeUsage()) != null && (dBObject2 = DBInsightProvider.resolveIDForInsight(dataTypeUsage.getDataTypeID())) instanceof Type) {
            Type type = (Type)dBObject2;
            this.addItems((DBObject)type);
            if (ModelUtil.hasLength((String)type.getCollectionType())) {
                this.addReservedWord("COUNT");
                this.addReservedWord("DELETE");
                this.addReservedWord("DELETE()");
                this.addReservedWord("DELETE(,)");
                this.addReservedWord("EXISTS()");
                this.addReservedWord("EXTEND");
                this.addReservedWord("EXTEND()");
                this.addReservedWord("EXTEND(,)");
                this.addReservedWord("DELETE");
                this.addReservedWord("FIRST");
                this.addReservedWord("LAST");
                this.addReservedWord("LIMIT");
                this.addReservedWord("NEXT()");
                this.addReservedWord("PRIOR()");
                this.addReservedWord("TRIM");
                this.addReservedWord("TRIM()");
            }
        }
        if (dBObject instanceof Sequence) {
            this.addReservedWord("NEXTVAL");
            this.addReservedWord("CURRVAL");
        }
        if (dBObject instanceof Schema && this.isTargetClass(null, true)) {
            schemaObjectArray2 = (Schema)dBObject;
            for (Schema schema : this.getMatchingSchemaItems((Schema)schemaObjectArray2, "PROCEDURE")) {
                this.addDBObject((DBObject)schema);
            }
        }
        CancelledException.checkInterrupt();
        if (this.addDataTypes(dBObject) || this.addDataTypeUsages(dBObject)) {
            super.addItems(dBObject);
            this.addPlSqlDataTypes("BINARY_INTEGER", "BOOLEAN", "NATURAL", "NATURALN", "PLS_INTEGER", "POSITIVE", "POSITIVEN", "RECORD", "REF", "REF CURSOR", "SIGNTYPE", "SMALLINT", "STRING", "TABLE", "VARRAY");
        }
        if (this.isTargetClass(DataType.class, true) || this.isTargetClass(DataTypeUsage.class, true)) {
            schemaObjectArray2 = new SchemaObject[]{};
            if (dBObject instanceof Schema) {
                schemaObjectArray = (SchemaObject[])dBObject;
                schemaObjectArray2 = this.getMatchingSchemaItems((Schema)schemaObjectArray, "TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM");
            } else if (dBObject instanceof Relation) {
                schemaObjectArray2 = new SchemaObject[]{(Relation)dBObject};
            } else if (dBObject instanceof Column || dBObject instanceof PlSqlDatum) {
                this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(dBObject.getName()), "%", "TYPE");
            }
            for (SchemaObject schemaObject : schemaObjectArray2) {
                CancelledException.checkInterrupt();
                plSqlReference = null;
                if (schemaObject instanceof Synonym) {
                    Column[] columnArray = DBUtil.getSynonymReference((Synonym)((Synonym)schemaObject));
                    CancelledException.checkInterrupt();
                    if (columnArray instanceof Relation) {
                        plSqlReference = (Relation)columnArray;
                    }
                } else if (schemaObject instanceof Relation) {
                    plSqlReference = (Relation)schemaObject;
                }
                if (plSqlReference == null) continue;
                for (Column column : plSqlReference.getColumns()) {
                    if (dBObject instanceof Schema) {
                        this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(plSqlReference.getName()), ".", this.getProvider().getExternalName(column.getName()), "%", "TYPE");
                        continue;
                    }
                    this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(column.getName()), "%", "TYPE");
                }
                this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(plSqlReference.getName()), "%", "ROWTYPE");
            }
        }
    }

    private void addPlSqlDataTypes(String ... stringArray) {
        for (String string : stringArray) {
            this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), string);
        }
    }
}

