/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.javatools.db.DBLog;

public abstract class SelectableComponent<T extends Component> {
    private final T m_component;
    private Collection<SelectionListener> m_listeners;
    private boolean m_useEquals;

    protected SelectableComponent(T t) {
        this.m_component = t;
    }

    public final T getComponent() {
        return this.m_component;
    }

    public final void addSelectionListener(SelectionListener selectionListener) {
        if (selectionListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new LinkedHashSet<SelectionListener>();
            }
            this.m_listeners.add(selectionListener);
        }
    }

    public final void removeSelectionListener(SelectionListener selectionListener) {
        if (selectionListener != null && this.m_listeners != null) {
            this.m_listeners.remove(selectionListener);
        }
    }

    protected final void fireSelectionEvent() {
        if (this.m_listeners != null) {
            SelectionEvent selectionEvent = new SelectionEvent(this);
            for (SelectionListener selectionListener : this.m_listeners) {
                try {
                    selectionListener.valueChanged(selectionEvent);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace((String)"SelectionListener error", (Throwable)exception);
                }
            }
        }
    }

    public abstract void clear();

    public abstract int size();

    public abstract Object get(int var1);

    public abstract Object[] getChildren(Object var1);

    public abstract Object getParent(Object var1);

    public abstract boolean swap(int var1, int var2);

    public abstract void setSelectedIndices(int ... var1);

    public abstract int[] getSelectedIndices();

    public int getNextIndex(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.size() - 1) {
            n2 = n + 1;
        }
        return n2;
    }

    public int getPreviousIndex(int n) {
        int n2 = -1;
        if (n > 0 && n < this.size()) {
            n2 = n - 1;
        }
        return n2;
    }

    public int getFirstIndex(int n) {
        return n > 0 ? 0 : -1;
    }

    public int getLastIndex(int n) {
        int n2 = this.size() - 1;
        return n < n2 ? n2 : -1;
    }

    public int getSelectedIndex() {
        int n = -1;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length == 1) {
            n = nArray[0];
        }
        return n;
    }

    public int indexOf(Object object) {
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != object) continue;
            n = i;
            break;
        }
        return n;
    }

    public abstract boolean add(Object var1);

    public boolean add(int n, Object object) {
        return this.add(n, object, Placement.Sibling);
    }

    public abstract boolean add(int var1, Object var2, Placement var3);

    public abstract boolean remove(Object var1);

    public abstract Object remove(int var1);

    public boolean moveUp(int n) {
        boolean bl = false;
        int n2 = this.getPreviousIndex(n);
        if (n2 >= 0) {
            bl = this.swap(n, n2);
        }
        return bl;
    }

    public boolean moveDown(int n) {
        boolean bl = false;
        int n2 = this.getNextIndex(n);
        if (n2 >= 0) {
            bl = this.swap(n, n2);
        }
        return bl;
    }

    public boolean moveFirst(int n) {
        Object object;
        boolean bl = false;
        int n2 = this.getFirstIndex(n);
        if (n2 >= 0 && (object = this.remove(n)) != null) {
            bl = this.add(n2, object);
            this.modelChanged();
        }
        return bl;
    }

    public boolean moveLast(int n) {
        Object object;
        boolean bl = false;
        int n2 = this.getLastIndex(n);
        if (n2 >= 0 && (object = this.remove(n)) != null) {
            bl = this.add(n2, object);
            this.modelChanged();
        }
        return bl;
    }

    protected void modelChanged() {
    }

    public static SelectableComponent<JTree> createSelectableComponent(JTree jTree) {
        return new TreeSC(jTree);
    }

    public static SelectableComponent<JList> createSelectableComponent(JList jList) {
        return new ListSC(jList);
    }

    public static SelectableComponent<JComboBox> createSelectableComponent(JComboBox jComboBox) {
        return new ComboSC(jComboBox);
    }

    public static final class SelectionEvent {
        private final SelectableComponent m_sc;

        private SelectionEvent(SelectableComponent selectableComponent) {
            this.m_sc = selectableComponent;
        }

        public SelectableComponent getSelectableComponent() {
            return this.m_sc;
        }
    }

    public static abstract class SelectionListener {
        public abstract void valueChanged(SelectionEvent var1);
    }

    public static enum Placement {
        Sibling,
        Child;

    }

    static class TreeSC
    extends SelectableComponent<JTree> {
        public TreeSC(JTree jTree) {
            super(jTree);
            TreeModel treeModel = jTree.getModel();
            if (!(treeModel instanceof DefaultTreeModel)) {
                throw new IllegalStateException("JTree must have a DefaultTreeModel to be used in SelectableComponent");
            }
            Object object = treeModel.getRoot();
            if (!(object instanceof DefaultMutableTreeNode)) {
                throw new IllegalStateException("JTree must have a root DefaultMutableTreeNode to be used in SelectableComponent");
            }
            jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    this.fireSelectionEvent();
                }
            });
        }

        DefaultTreeModel getModel() {
            return (DefaultTreeModel)((JTree)this.getComponent()).getModel();
        }

        DefaultMutableTreeNode getRoot() {
            return (DefaultMutableTreeNode)this.getModel().getRoot();
        }

        private Enumeration nodes() {
            Enumeration<TreeNode> enumeration = this.getRoot().preorderEnumeration();
            if (!((JTree)this.getComponent()).isRootVisible() && enumeration.hasMoreElements()) {
                enumeration.nextElement();
            }
            return enumeration;
        }

        @Override
        protected void modelChanged() {
            this.modelChanged(null);
        }

        private void modelChanged(TreeNode treeNode) {
            if (treeNode != null) {
                this.getModel().reload(treeNode);
            } else {
                this.getModel().reload();
            }
        }

        @Override
        public int size() {
            int n = 0;
            Enumeration enumeration = this.nodes();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            return n;
        }

        private int indexOfNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            int n = 0;
            int n2 = -1;
            Enumeration enumeration = this.nodes();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode == defaultMutableTreeNode2) {
                    n2 = n;
                    break;
                }
                ++n;
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n = 0;
            int n2 = -1;
            Enumeration enumeration = this.nodes();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode.getUserObject() == object) {
                    n2 = n;
                    break;
                }
                ++n;
            }
            return n2;
        }

        @Override
        public boolean add(int n, Object object, Placement placement) {
            if (placement == null) {
                placement = Placement.Sibling;
            }
            int n2 = 0;
            Enumeration enumeration = this.nodes();
            DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
            if (this.size() != 0) {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (n == 0) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)e;
                        break;
                    }
                    if (n2 == n - 1) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)e;
                        break;
                    }
                    ++n2;
                }
            }
            boolean bl = false;
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                DefaultMutableTreeNode defaultMutableTreeNode3 = placement == Placement.Sibling ? (DefaultMutableTreeNode)defaultMutableTreeNode.getParent() : defaultMutableTreeNode;
                int n3 = TreeNodeMaker.indexOfNode(defaultMutableTreeNode, defaultMutableTreeNode3);
                if (n3 >= 0 && n3 < defaultMutableTreeNode3.getChildCount()) {
                    defaultMutableTreeNode3.insert(defaultMutableTreeNode2, n3 + 1);
                } else {
                    defaultMutableTreeNode3.add(defaultMutableTreeNode2);
                }
                this.modelChanged(defaultMutableTreeNode3);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean add(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
            this.getRoot().add(defaultMutableTreeNode);
            this.modelChanged();
            return true;
        }

        @Override
        public Object get(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(n);
            return defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
        }

        @Override
        public Object[] getChildren(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(this.indexOf(object));
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)((JTree)this.getComponent()).getModel().getRoot();
            }
            if (defaultMutableTreeNode != null) {
                Object[] objectArray = new Object[defaultMutableTreeNode.getChildCount()];
                int n = 0;
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    objectArray[n++] = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                }
                return objectArray;
            }
            return new Object[0];
        }

        @Override
        public Object getParent(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(this.indexOf(object));
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            return defaultMutableTreeNode2 != null ? defaultMutableTreeNode2.getUserObject() : null;
        }

        private DefaultMutableTreeNode getNode(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            int n2 = 0;
            Enumeration enumeration = this.nodes();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (n2 == n) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)e;
                    break;
                }
                ++n2;
            }
            return defaultMutableTreeNode;
        }

        @Override
        public int[] getSelectedIndices() {
            int[] nArray = null;
            TreePath[] treePathArray = ((JTree)this.getComponent()).getSelectionModel().getSelectionPaths();
            if (treePathArray != null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (TreePath treePath : treePathArray) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    int n = this.indexOfNode(defaultMutableTreeNode);
                    if (n < 0) continue;
                    arrayList.add(n);
                }
                nArray = new int[arrayList.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
            }
            return nArray;
        }

        @Override
        public Object remove(int n) {
            Object object = false;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(n);
            if (defaultMutableTreeNode != null) {
                object = defaultMutableTreeNode.getUserObject();
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                defaultMutableTreeNode.removeFromParent();
                this.modelChanged(treeNode);
            }
            return object;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = TreeNodeMaker.findNode(object, this.getRoot());
            if (defaultMutableTreeNode != null) {
                TreeNode treeNode = defaultMutableTreeNode.getParent();
                defaultMutableTreeNode.removeFromParent();
                this.modelChanged(treeNode);
                bl = true;
            }
            return bl;
        }

        @Override
        public void setSelectedIndices(int ... nArray) {
            TreeSelectionModel treeSelectionModel = ((JTree)this.getComponent()).getSelectionModel();
            if (nArray == null || nArray.length == 0) {
                treeSelectionModel.clearSelection();
            } else {
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                for (int i = 0; i < nArray.length; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(nArray[i]);
                    if (defaultMutableTreeNode == null) continue;
                    arrayList.add(new TreePath(defaultMutableTreeNode.getPath()));
                }
                treeSelectionModel.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            }
        }

        @Override
        public boolean swap(int n, int n2) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n2);
            boolean bl = false;
            if (defaultMutableTreeNode != null && defaultMutableTreeNode2 != null && defaultMutableTreeNode != defaultMutableTreeNode2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode3 != null && defaultMutableTreeNode3 == defaultMutableTreeNode4) {
                    int n3 = TreeNodeMaker.indexOfNode(defaultMutableTreeNode, defaultMutableTreeNode3);
                    int n4 = TreeNodeMaker.indexOfNode(defaultMutableTreeNode2, defaultMutableTreeNode4);
                    defaultMutableTreeNode.removeFromParent();
                    defaultMutableTreeNode2.removeFromParent();
                    if (n3 > n4) {
                        defaultMutableTreeNode4.insert(defaultMutableTreeNode, n4);
                        defaultMutableTreeNode3.insert(defaultMutableTreeNode2, n3);
                    } else {
                        defaultMutableTreeNode3.insert(defaultMutableTreeNode2, n3);
                        defaultMutableTreeNode4.insert(defaultMutableTreeNode, n4);
                    }
                    bl = true;
                    this.modelChanged();
                }
            }
            return bl;
        }

        @Override
        public int getFirstIndex(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n2 = -1;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                if (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                }
                if (defaultMutableTreeNode3 != null && defaultMutableTreeNode3 != defaultMutableTreeNode2) {
                    n2 = this.indexOfNode(defaultMutableTreeNode3);
                }
            }
            return n2;
        }

        @Override
        public int getLastIndex(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n2 = -1;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                }
                if (defaultMutableTreeNode3 != null && defaultMutableTreeNode3 != defaultMutableTreeNode2) {
                    n2 = this.indexOfNode(defaultMutableTreeNode3);
                }
            }
            return n2;
        }

        @Override
        public int getNextIndex(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n2 = -1;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (defaultMutableTreeNode4 == defaultMutableTreeNode2) {
                        bl = true;
                        continue;
                    }
                    if (!bl || defaultMutableTreeNode3 != null) continue;
                    defaultMutableTreeNode3 = defaultMutableTreeNode4;
                    break;
                }
                if (defaultMutableTreeNode3 != null) {
                    n2 = this.indexOfNode(defaultMutableTreeNode3);
                }
            }
            return n2;
        }

        @Override
        public int getPreviousIndex(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n2 = -1;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                while (enumeration.hasMoreElements() && (defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement()) != defaultMutableTreeNode2) {
                    defaultMutableTreeNode4 = defaultMutableTreeNode3;
                }
                if (defaultMutableTreeNode4 != null) {
                    n2 = this.indexOfNode(defaultMutableTreeNode4);
                }
            }
            return n2;
        }

        @Override
        public boolean moveLast(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                bl = true;
                this.modelChanged(defaultMutableTreeNode);
            }
            return bl;
        }

        @Override
        public boolean moveFirst(int n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNode(n);
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, 0);
                bl = true;
                this.modelChanged(defaultMutableTreeNode);
            }
            return bl;
        }

        @Override
        public void clear() {
            this.getRoot().removeAllChildren();
            this.modelChanged();
        }
    }

    static class ListSC
    extends SelectableComponent<JList> {
        public ListSC(JList jList) {
            super(jList);
            ListModel listModel = jList.getModel();
            if (!(listModel instanceof DefaultListModel)) {
                throw new IllegalStateException("JList must have a DefaultListModel to be used in SelectableComponent");
            }
            jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        this.fireSelectionEvent();
                    }
                }
            });
        }

        private DefaultListModel getModel() {
            return (DefaultListModel)((JList)this.getComponent()).getModel();
        }

        @Override
        public int size() {
            return this.getModel().getSize();
        }

        @Override
        public Object get(int n) {
            return this.getModel().getElementAt(n);
        }

        @Override
        public Object[] getChildren(Object object) {
            return new Object[0];
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public int[] getSelectedIndices() {
            return ((JList)this.getComponent()).getSelectedIndices();
        }

        @Override
        public void setSelectedIndices(int ... nArray) {
            if (nArray != null && nArray.length == 1) {
                ((JList)this.getComponent()).setSelectedIndex(nArray[0]);
            } else {
                ((JList)this.getComponent()).setSelectedIndices(nArray);
            }
        }

        @Override
        public boolean swap(int n, int n2) {
            DefaultListModel defaultListModel = this.getModel();
            Object e = defaultListModel.getElementAt(n);
            Object e2 = defaultListModel.getElementAt(n2);
            defaultListModel.setElementAt(e, n2);
            defaultListModel.setElementAt(e2, n);
            return true;
        }

        @Override
        public boolean add(Object object) {
            this.getModel().addElement(object);
            return true;
        }

        @Override
        public boolean add(int n, Object object, Placement placement) {
            boolean bl = false;
            if (n >= 0) {
                if (n >= this.size()) {
                    bl = this.add(object);
                } else {
                    this.getModel().add(n, object);
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Object remove(int n) {
            Object e = this.getModel().get(n);
            if (e != null) {
                this.getModel().removeElementAt(n);
            }
            return e;
        }

        @Override
        public boolean remove(Object object) {
            this.getModel().removeElement(object);
            return true;
        }

        @Override
        public void clear() {
            this.getModel().clear();
        }
    }

    static class ComboSC
    extends SelectableComponent<JComboBox> {
        public ComboSC(JComboBox jComboBox) {
            super(jComboBox);
            ComboBoxModel comboBoxModel = jComboBox.getModel();
            if (!(comboBoxModel instanceof DefaultComboBoxModel)) {
                throw new IllegalStateException("JComboBox must have a DefaultComboBoxModel to be used inSelectableComponent");
            }
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        this.fireSelectionEvent();
                    }
                }
            });
        }

        private DefaultComboBoxModel getModel() {
            return (DefaultComboBoxModel)((JComboBox)this.getComponent()).getModel();
        }

        @Override
        public int size() {
            return this.getModel().getSize();
        }

        @Override
        public Object get(int n) {
            return this.getModel().getElementAt(n);
        }

        @Override
        public Object[] getChildren(Object object) {
            return new Object[0];
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public int[] getSelectedIndices() {
            return new int[]{((JComboBox)this.getComponent()).getSelectedIndex()};
        }

        @Override
        public void setSelectedIndices(int ... nArray) {
            if (nArray != null && nArray.length == 1) {
                ((JComboBox)this.getComponent()).setSelectedIndex(nArray[0]);
            } else if (nArray == null || nArray.length == 0) {
                ((JComboBox)this.getComponent()).setSelectedIndex(-1);
            } else {
                throw new UnsupportedOperationException("Attempt to multi-select in a combo box");
            }
        }

        @Override
        public boolean swap(int n, int n2) {
            throw new UnsupportedOperationException("Attempt to reorder in a combo box");
        }

        @Override
        public boolean add(Object object) {
            this.getModel().addElement(object);
            return true;
        }

        @Override
        public boolean add(int n, Object object, Placement placement) {
            this.getModel().addElement(object);
            return true;
        }

        @Override
        public Object remove(int n) {
            this.getModel().removeElementAt(n);
            return true;
        }

        @Override
        public boolean remove(Object object) {
            this.getModel().removeElement(object);
            return true;
        }

        @Override
        public void clear() {
            this.getModel().removeAllElements();
        }
    }
}

