/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class SchemaPicker
extends JComboBox {
    private DBObjectProvider m_prov;
    private Schema[] m_schemas;

    public SchemaPicker() {
        this(false);
    }

    public SchemaPicker(boolean bl) {
        super(bl ? new DefaultComboBoxModel() : new NonNullableComboBoxModel());
    }

    private DBObjectProvider getProvider() {
        if (this.m_prov == null) {
            throw new IllegalStateException("schema picker hasn't been initialized with a provider");
        }
        return this.m_prov;
    }

    public Schema getSchema() throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        Schema schema = null;
        String string = (String)this.getSelectedItem();
        if (this.isEditable() && !dBObjectProvider.isValidName("SCHEMA", string)) {
            String string2 = UIBundle.format("TABLE_INFO_ERROR_BAD_SCHEMA_NAME", string);
            throw new TraversalException(string2, UIBundle.get("SCHEMA_ERROR_TITLE"));
        }
        if (ModelUtil.hasLength((String)(string = dBObjectProvider.getInternalName(string)))) {
            if (this.m_schemas != null) {
                for (int i = 0; i < this.m_schemas.length; ++i) {
                    if (!string.equals(this.m_schemas[i].getName())) continue;
                    schema = this.m_schemas[i];
                    break;
                }
            }
            if (schema == null) {
                try {
                    schema = dBObjectProvider.getSchema(string);
                }
                catch (DBException dBException) {
                    String string3 = dBException.getMessage();
                    throw new TraversalException(string3, UIBundle.get("SCHEMA_ERROR_TITLE"));
                }
            }
        } else {
            try {
                schema = dBObjectProvider.getDefaultSchema();
            }
            catch (DBException dBException) {
                String string4 = dBException.getMessage();
                throw new TraversalException(string4, UIBundle.get("SCHEMA_ERROR_TITLE"));
            }
        }
        if (schema == null) {
            schema = new Schema(string);
            try {
                dBObjectProvider.validateObject((DBObject)schema);
            }
            catch (ValidationException validationException) {
                String string5 = validationException.getMessage();
                throw new TraversalException(string5, UIBundle.get("SCHEMA_ERROR_TITLE"));
            }
        }
        return schema;
    }

    public void init(DBEditorConfig dBEditorConfig, Schema schema) {
        this.init(dBEditorConfig.getProvider(), schema, dBEditorConfig.getSchemaList());
    }

    public void init(DBObjectProvider dBObjectProvider, String string) {
        Schema schema = null;
        try {
            schema = dBObjectProvider.getSchema(string);
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog((Component)this, UIBundle.get("SCHEMA_ERROR_TITLE"), dBException);
        }
        this.init(dBObjectProvider, schema);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema) {
        this.init(dBObjectProvider, schema, true);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, boolean bl) {
        Schema[] schemaArray = null;
        try {
            schemaArray = dBObjectProvider.listSchemas(bl);
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog((Component)this, UIBundle.get("SCHEMA_ERROR_TITLE"), dBException);
        }
        this.init(dBObjectProvider, schema, schemaArray);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, Schema[] schemaArray) {
        this.m_prov = dBObjectProvider;
        this.m_schemas = schemaArray;
        if (dBObjectProvider != null && schema == null) {
            try {
                schema = dBObjectProvider.getDefaultSchema();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.removeAllItems();
        boolean bl = false;
        if (this.m_schemas != null) {
            Arrays.sort(this.m_schemas, DBUtil.getNameComparator());
            for (int i = 0; i < this.m_schemas.length; ++i) {
                if (this.m_schemas[i] == null) continue;
                this.addItem(this.m_schemas[i]);
                if (bl || schema == null || !ModelUtil.areEqual((Object)this.m_schemas[i].getName(), (Object)schema.getName())) continue;
                bl = true;
            }
        }
        if (schema != null && !bl) {
            this.addItem(schema);
        }
        this.setSelectedItem(schema);
    }

    public void initWithOneSchema(DBObjectProvider dBObjectProvider, Schema schema) {
        this.m_prov = dBObjectProvider;
        this.removeAllItems();
        this.addItem(schema);
        this.setSelectedItem(schema);
    }

    public void addItem(Object object) {
        super.addItem(this.convertToString(object));
    }

    @Override
    public void removeItem(Object object) {
        super.removeItem(this.convertToString(object));
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(this.convertToString(object));
    }

    private String convertToString(Object object) {
        if (object instanceof Schema) {
            object = this.getProvider().getExternalName(((Schema)object).getName());
        } else if (object != null) {
            object = object.toString();
        }
        return (String)object;
    }
}

