/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.inspector.ExtendedPropertyEditor;

public class FontEditor
extends PropertyEditorSupport
implements ExtendedPropertyEditor {
    private static final String _KEY_STRING = "FONT_EDITOR_STRING";
    private static final Border _sBORDER = new EmptyBorder(8, 8, 8, 8);
    private FontPane _customFontPane;
    private FontPane _tearOffFontPane;
    private JPanel _customEditor;
    private JPanel _tearOffEditor;
    private PropertyChangeListener _listener;

    @Override
    public void setValue(Object newValue) {
        Font newFont = (Font)newValue;
        super.setValue(newFont);
        if (this._customFontPane != null) {
            this._customFontPane.setCurrentFont(newFont);
        }
        if (this._tearOffFontPane != null) {
            this._tearOffFontPane.setCurrentFont(newFont);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public final void paintValue(Graphics g, Rectangle paintBounds) {
        this.paintValue(this.getValue(), g, Locale.getDefault(), paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
    }

    @Override
    public String getJavaInitializationString() {
        Font currFont = this._getFont();
        return "new java.awt.Font(\"" + currFont.getFamily() + "\", " + currFont.getStyle() + ", " + currFont.getSize() + ")";
    }

    @Override
    public final String getAsText() {
        return null;
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public Component getCustomEditor() {
        if (this._customEditor == null) {
            FontPane fontPane = new FontPane();
            fontPane.setStyleButtonMask(3);
            fontPane.setAlignmentButtonMask(0);
            fontPane.setColorComponentMask(0);
            if (this._listener == null) {
                this._listener = new Listener();
            }
            fontPane.addPropertyChangeListener(this._listener);
            this._customFontPane = fontPane;
            JPanel customEditor = new JPanel(new BorderLayout());
            customEditor.setBorder(_sBORDER);
            customEditor.add("Center", (Component)fontPane);
            this._customEditor = customEditor;
        }
        return this._customEditor;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Object textToValue(String text, Locale locale) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String valueToText(Object value, Locale locale) {
        return "null";
    }

    @Override
    public void paintValue(Object value, Graphics g, Locale locale, int x, int y, int width, int height) {
        Font savedFont = g.getFont();
        Font currFont = (Font)value;
        if (currFont == null) {
            currFont = savedFont;
        }
        if (currFont != null) {
            g.setFont(currFont);
            FontMetrics metrics = g.getFontMetrics(currFont);
            int ascent = metrics.getAscent();
            int fontHeight = ascent + metrics.getDescent();
            String s = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle", locale).getString(_KEY_STRING);
            g.drawString(s, x, y + (height - fontHeight) / 2 + ascent);
        }
        g.setFont(savedFont);
    }

    @Override
    public boolean supportsSmallCustomEditor() {
        return true;
    }

    @Override
    public Component getSmallCustomEditor() {
        if (this._tearOffEditor == null) {
            FontPane fontPane = new FontPane();
            fontPane.setStyleButtonMask(3);
            fontPane.setAlignmentButtonMask(0);
            fontPane.setColorComponentMask(0);
            fontPane.setPreviewAreaVisible(false);
            if (this._listener == null) {
                this._listener = new Listener();
            }
            fontPane.addPropertyChangeListener(this._listener);
            this._tearOffFontPane = fontPane;
            JPanel tearOffEditor = new JPanel(new BorderLayout());
            tearOffEditor.setBorder(_sBORDER);
            tearOffEditor.add("Center", (Component)fontPane);
            this._tearOffEditor = tearOffEditor;
        }
        return this._tearOffEditor;
    }

    public FontPane getTearOffFontPane() {
        Component dummy = this.getSmallCustomEditor();
        return this._tearOffFontPane;
    }

    public FontPane getAdvancedFontPane() {
        Component dummy = this.getCustomEditor();
        return this._customFontPane;
    }

    private Font _getFont() {
        return (Font)this.getValue();
    }

    private void _setValue(Object newValue) {
        super.setValue(newValue);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Font newValue = null;
            newValue = e.getSource() == FontEditor.this._customFontPane ? FontEditor.this._customFontPane.getCurrentFont() : FontEditor.this._tearOffFontPane.getCurrentFont();
            FontEditor.this._setValue(newValue);
        }
    }
}

