/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class FieldPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private Field _field;

    public FieldPropertyEditorFactory(Object target, Field field) {
        super(target);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this._field = field;
    }

    public Field getField() {
        return this._field;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getField().getName();
    }

    @Override
    public boolean setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException {
        boolean changed = this.getCachedValue() != newValue;
        this.getField().set(this.getTarget(), newValue);
        this.setCachedValue(newValue);
        this.setCachedDisplayValue(INVALID_PROPERTY);
        return changed;
    }

    @Override
    public Object getValue(Object target) throws IllegalAccessException, IllegalArgumentException {
        Object cachedValue = this.getCachedValue();
        if (cachedValue == INVALID_PROPERTY) {
            cachedValue = this.getField().get(target);
            this.setCachedValue(cachedValue);
        }
        return cachedValue;
    }

    @Override
    public boolean isReadable() {
        int modifiers = this.getField().getModifiers();
        boolean readable = Modifier.isPublic(modifiers);
        return readable;
    }

    @Override
    public boolean isWritable() {
        int modifiers = this.getField().getModifiers();
        boolean writable = Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers);
        return writable;
    }

    @Override
    public Class getType() {
        return this.getField().getType();
    }

    @Override
    protected Object createPropertyID() {
        return new Object();
    }
}

