/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;

class ColumnModel
extends DefaultTableColumnModel {
    private Hashtable _columnCache = new Hashtable(13);
    private Object[] _visibleColumns = new Object[]{PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE};
    private PropertyModel _model;
    private ColumnSetListener _propertyModelListener = new ColumnSetListener();

    public void setPropertyModel(PropertyModel newModel) {
        if (newModel != this._model) {
            if (this._model != null) {
                this._model.removeTableModelListener(this._propertyModelListener);
            }
            this._model = newModel;
            if (newModel != null) {
                this._model.addTableModelListener(this._propertyModelListener);
            }
            this._updateVisibleColumns();
        }
    }

    public void setVisibleColumnIDs(Object[] visibleColumns) {
        if (!this._equals(this._visibleColumns, visibleColumns)) {
            this._visibleColumns = visibleColumns;
            this._updateVisibleColumns();
        }
    }

    public Object[] getVisibleColumnIDs() {
        return this._visibleColumns;
    }

    public TableColumn getTableColumn(Object columnID) {
        int modelIndex = this._model != null ? this._model.getColumnIndex(columnID) : -1;
        return this._getColumn(columnID, modelIndex);
    }

    private void _updateVisibleColumns() {
        int columnCount = this.getColumnCount();
        for (int i = columnCount - 1; i >= 0; --i) {
            this.removeColumn(this.getColumn(i));
        }
        PropertyModel model = this._model;
        if (model != null) {
            for (int i = 0; i < this._visibleColumns.length; ++i) {
                Object visibleColumnID = this._visibleColumns[i];
                int modelIndex = model.getColumnIndex(visibleColumnID);
                if (modelIndex == -1) continue;
                this.addColumn(this._getColumn(visibleColumnID, modelIndex));
            }
        }
    }

    private TableColumn _getColumn(Object columnID, int modelIndex) {
        TableColumn cachedColumn = (TableColumn)this._columnCache.get(columnID);
        if (cachedColumn == null) {
            cachedColumn = new TableColumn(modelIndex);
            cachedColumn.setIdentifier(columnID);
            this._columnCache.put(columnID, cachedColumn);
        } else {
            cachedColumn.setModelIndex(modelIndex);
        }
        return cachedColumn;
    }

    private boolean _equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private class ColumnSetListener
    implements TableModelListener {
        private ColumnSetListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1) {
                ColumnModel.this._updateVisibleColumns();
            }
        }
    }
}

