/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.Importer;
import oracle.dbtools.plusplus.util.CommandContext;

public interface ImporterFactory {
    public static final ServiceLoader<ImporterFactory> LOADER = ServiceLoader.load(ImporterFactory.class);

    public boolean canHandle(Path var1);

    public Importer create(Path var1, ConnectionStoreOptions.DuplicatesPolicy var2, Collection<String> var3, CommandContext var4, TextSecret var5);

    public static Importer getImporter(Path path, ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, CommandContext ctx, TextSecret key) {
        Importer importer = null;
        for (ImporterFactory factory : LOADER) {
            if (!factory.canHandle(path)) continue;
            importer = factory.create(path, duplicatesPolicy, existingConnections, ctx, key);
            break;
        }
        if (importer == null) {
            importer = ImporterFactory.createFallbackImporter(path, duplicatesPolicy, existingConnections, ctx);
        }
        return importer;
    }

    public static Importer createFallbackImporter(Path path, ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, final CommandContext ctx) {
        return new Importer(path, duplicatesPolicy, existingConnections, ctx, null){

            protected Map loadConnections() {
                ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("UNSUPPORTED_IMPORT_LOCATION", this.importPath));
                return Collections.emptyMap();
            }

            protected String getConnectionName(Object connectionDefinition) {
                return null;
            }
        };
    }
}

