/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.diagram.oppparse.OPPDiagramEdge;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public final class OPPGlyph
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private final OPPDiagramEdge _parent;
    private final Type _typeCode;
    private final Set<FillType> _fillType;
    private final int _customFillMask;
    private final OPPDimension _size;
    private final float _pcAlongLine;

    OPPGlyph(OPPDiagramEdge parent, XMLElement xmlSource) {
        super(xmlSource);
        this._parent = parent;
        NodeList ints = xmlSource.getChildrenByTagName("integer");
        Integer[] data = new Integer[5];
        int isize = ints.getLength();
        for (int i = 0; i < isize; ++i) {
            data[i] = (Integer)OPPParseUtil.parseTypedProperty((XMLElement)ints.item(i));
        }
        int typeCode = data[0];
        switch (typeCode) {
            case 1: {
                this._typeCode = Type.AGGREGATION;
                break;
            }
            case 2: {
                this._typeCode = Type.ARROWHEAD;
                break;
            }
            case 3: {
                this._typeCode = Type.BAR;
                break;
            }
            case 4: {
                this._typeCode = Type.CONTAINS;
                break;
            }
            case 5: {
                this._typeCode = Type.AGGREGATION_ARROW;
                break;
            }
            default: {
                this._typeCode = Type.CUSTOM;
            }
        }
        this._customFillMask = data[1];
        HashSet<FillType> fillType = new HashSet<FillType>(32);
        if ((this._customFillMask & 0x10000000) == 0x10000000) {
            fillType.add(FillType.FILLED);
        }
        if ((this._customFillMask & 0x20000000) == 0x20000000) {
            fillType.add(FillType.CLOSED);
        }
        if ((this._customFillMask & 0x40000000) == 0x40000000) {
            fillType.add(FillType.STRAIGHT_CLOSED);
        }
        if ((this._typeCode.equals((Object)Type.ARROWHEAD) || this._typeCode.equals((Object)Type.AGGREGATION) || this._typeCode.equals((Object)Type.AGGREGATION_ARROW)) && (this._customFillMask & 1) == 1) {
            fillType.add(FillType.HEAD);
        }
        this._fillType = Collections.unmodifiableSet(fillType);
        this._size = new OPPDimension(Float.intBitsToFloat(data[2]), Float.intBitsToFloat(data[3]));
        this._pcAlongLine = Float.intBitsToFloat(data[4]);
    }

    public final Type getGlyphStyle() {
        return this._typeCode;
    }

    public final Set<FillType> getFillTypes() {
        return this._fillType;
    }

    public final int getCustomFillTypeMask() {
        return this._customFillMask;
    }

    public final OPPDimension getSize() {
        return this._size;
    }

    public final float getPercentageAlongEdge() {
        return this._pcAlongLine;
    }

    public static enum Type {
        AGGREGATION,
        ARROWHEAD,
        BAR,
        CONTAINS,
        AGGREGATION_ARROW,
        CUSTOM;

    }

    public static enum FillType {
        HEAD,
        FILLED,
        CLOSED,
        STRAIGHT_CLOSED;

    }
}

