/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.palette;

import ilog.views.IlvGraphic;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.CreateDefaultLinkHandler;
import oracle.diagram.framework.palette.interactor.LinkItemFactory;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultLinkInSwimlaneHandler
extends CreateDefaultLinkHandler {
    public CreateDefaultLinkInSwimlaneHandler(DiagramContext context, PaletteItem item, LinkItemFactory factory) {
        super(context, item, factory);
    }

    @Override
    protected List<IlvGraphic> getValidSources() {
        List<IlvGraphic> sources = super.getValidSources();
        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
        if (plugin == null || plugin.getTopSwimlane(this.getDiagramContext().getManagerView().getManager()) == null) {
            return sources;
        }
        SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(this.getDiagramContext().getManagerView().getManager());
        LinkedList<IlvGraphic> swimlaneContexts = new LinkedList<IlvGraphic>();
        this.getSwimlanes(swimlaneContexts, topSwimlane, null);
        if (swimlaneContexts.isEmpty()) {
            return sources;
        }
        swimlaneContexts.addAll(sources);
        return Collections.unmodifiableList(swimlaneContexts);
    }

    @Override
    protected List<IlvGraphic> getValidTargets(IlvGraphic source) {
        List<IlvGraphic> targets = super.getValidSources();
        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
        if (plugin == null || plugin.getTopSwimlane(this.getDiagramContext().getManagerView().getManager()) == null) {
            return targets;
        }
        SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(this.getDiagramContext().getManagerView().getManager());
        LinkedList<IlvGraphic> swimlaneContexts = new LinkedList<IlvGraphic>();
        this.getSwimlanes(swimlaneContexts, topSwimlane, source);
        if (swimlaneContexts.isEmpty()) {
            return targets;
        }
        swimlaneContexts.addAll(targets);
        return Collections.unmodifiableList(swimlaneContexts);
    }

    private void getSwimlanes(List<IlvGraphic> swimlaneContexts, SwimlaneGraphic sg, IlvGraphic source) {
        if (sg instanceof PoolGraphic) {
            for (SwimlaneGraphic lane : ((PoolGraphic)sg).getLanes()) {
                this.getSwimlanes(swimlaneContexts, lane, source);
            }
        } else if (sg instanceof ExtendedSwimlaneGraphic) {
            ExtendedSwimlaneGraphic esg = (ExtendedSwimlaneGraphic)sg;
            if (esg.getPool() != null) {
                this.getSwimlanes(swimlaneContexts, esg.getPool(), source);
            } else if (source == null && this.getFactory().isValidSource(this.getPaletteItem(), (IlvGraphic)esg) || source != null && this.getFactory().isValidDestination(this.getPaletteItem(), source, (IlvGraphic)esg)) {
                swimlaneContexts.add((IlvGraphic)esg);
            }
        } else if (source == null && this.getFactory().isValidSource(this.getPaletteItem(), (IlvGraphic)sg) || source != null && this.getFactory().isValidDestination(this.getPaletteItem(), source, (IlvGraphic)sg)) {
            swimlaneContexts.add((IlvGraphic)sg);
        }
    }
}

