/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.framework.graphic.IMultipresentationContainer;
import oracle.diagram.framework.interaction.MakeRectangleInteractor;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.DragEventBridge;
import oracle.diagram.framework.palette.interactor.NodeItemFactory;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.framework.selection.SubSelectionManager;

public class MakeNodeInteractor
extends MakeRectangleInteractor
implements DragAndDropAwareInteractor {
    private static final int THRESHOLD = 5;
    private final PaletteTask _task;
    private IlvGraphic _newGraphic = null;
    private IlvRect _ghostRect = new IlvRect();
    private DropTargetListener _dtl = new DragEventBridge(){

        @Override
        protected boolean isValidTarget(DropTargetEvent event) {
            return MakeNodeInteractor.this.getCurrentTarget() != null;
        }

        @Override
        protected void processAWTEvent(AWTEvent event) {
            MakeNodeInteractor.this.processEvent(event);
        }
    };
    private static final NullInteractor NULL_INTERACTOR = new NullInteractor();

    public MakeNodeInteractor(PaletteTask task, NodeItemFactory factory) {
        this._task = task;
        this.setObjectFactory(factory);
        this.setFillOn(true);
        this.setStrokeOn(true);
        this.setCreationInSubManagersAllowed(true);
        this.setSelectionMode(true);
        this.setOpaqueMode(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.enableEvents(8L);
    }

    @Override
    public IlvRect getGhostRectangle() {
        return new IlvRect(this._ghostRect);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && this.getManagerView().getInteractor() == this) {
            this.getManagerView().popInteractor();
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected final PaletteTask getPaletteTask() {
        return this._task;
    }

    @Override
    protected void attach(final IlvManagerView view) {
        super.attach(view);
        this.setGrapherMode(view.getManager() instanceof IlvGrapher && this.getNodeItemFactory().isGrapherMode());
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeNodeInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
        }
    }

    @Override
    protected void detach() {
        super.detach();
        if (!this._task.isAborting()) {
            this._task.finished();
        }
    }

    protected void addObject(IlvGraphic graphic) {
        this._newGraphic = graphic;
        this.getNodeItemFactory().initializeNewObject(this._task.getDiagramContext(), this._task.getPaletteItem(), (IlvGraphic)(this.getCurrentTarget() == null ? this.getManagerView().getManager() : this.getCurrentTarget()), graphic);
        this.addObjectImpl(graphic);
    }

    private void addObjectImpl(IlvGraphic g) {
        IlvManager ilvmanager;
        IlvManager parentManager = ilvmanager = this.getManager();
        if (this.isCreationInSubManagersAllowed()) {
            IlvGraphic ilvgraphic1;
            IlvPoint ilvpoint = this.getStartPoint();
            IlvTransformer ilvtransformer = this.getTransformer();
            if (ilvtransformer != null) {
                ilvtransformer.apply(ilvpoint);
            }
            if ((ilvgraphic1 = ilvmanager.getObject(ilvpoint, this.getManagerView(), true)) != null) {
                if (ilvgraphic1 instanceof IlvManager && ilvgraphic1 != parentManager) {
                    parentManager = (IlvManager)ilvgraphic1;
                } else if (ilvgraphic1.getGraphicBag() != parentManager && ilvgraphic1.getGraphicBag() instanceof IlvManager) {
                    parentManager = (IlvManager)ilvgraphic1.getGraphicBag();
                }
            }
            if (parentManager != ilvmanager) {
                IlvGraphic target = this.getActualTargetFromHit((IlvGraphic)parentManager);
                if (!this.isValidTarget(target) && this.getCurrentTarget() != null && this.getCurrentTarget() instanceof IlvManager) {
                    parentManager = (IlvManager)this.getCurrentTarget();
                }
                if (parentManager instanceof IMultipresentationContainer) {
                    IlvGraphic currentPresentation = ((IMultipresentationContainer)parentManager).getCurrentPresentation();
                    assert (currentPresentation instanceof IlvManager) : "currentPresentation is not instance of IlvManager: " + currentPresentation.getClass();
                    parentManager = (IlvManager)currentPresentation;
                }
                IlvRect ilvrect = g.boundingBox(ilvtransformer);
                IlvTransformer ilvtransformer1 = parentManager.getDrawingTransformer(this.getManagerView());
                if (ilvtransformer1 != null) {
                    ilvtransformer1.inverse(ilvrect);
                }
                g.moveResize(ilvrect);
            }
        }
        parentManager.initReDraws();
        boolean flag = this.isSelectionMode();
        if (parentManager != ilvmanager) {
            parentManager.setContentsAdjusting(true, true);
            if (flag) {
                ilvmanager.setSelectionAdjusting(true);
                SubSelectionManager.getInstance().setAdjusting(ilvmanager, true);
            }
        } else if (flag) {
            parentManager.setSelectionAdjusting(true);
            SubSelectionManager.getInstance().setAdjusting(parentManager, true);
        }
        if (flag) {
            ilvmanager.deSelectAll(true, true);
            SubSelectionManager.getInstance().deselectAll(ilvmanager, true);
        }
        if (this.isGrapherMode() && parentManager instanceof IlvGrapher) {
            ((IlvGrapher)parentManager).addNode(g, true);
        } else {
            parentManager.addObject(g, true);
        }
        if (flag && parentManager.isSelectable(g)) {
            parentManager.setSelected(g, true, true);
        }
        if (parentManager != ilvmanager) {
            parentManager.setContentsAdjusting(false, true);
            if (flag) {
                ilvmanager.setSelectionAdjusting(false);
                SubSelectionManager.getInstance().setAdjusting(ilvmanager, false);
            }
        } else if (flag) {
            parentManager.setSelectionAdjusting(false);
            SubSelectionManager.getInstance().setAdjusting(parentManager, false);
        }
        parentManager.reDrawViews();
    }

    protected void resizeObject(IlvGraphic g, IlvRect r) {
        IlvPoint startPoint = this.getStartPoint();
        Dimension size = this.getNodeItemFactory().getMinimumSize();
        IlvRect r2 = new IlvRect(r);
        if (r2.x < startPoint.x && r2.x + r2.width < startPoint.x) {
            float width = startPoint.x - r2.x;
            if (width < (float)size.width) {
                r2.x -= (float)size.width - width;
                r2.width = size.width;
            }
        } else {
            r2.width = Math.max((float)size.width, r2.width);
        }
        if (r2.y < startPoint.y) {
            float height = startPoint.y - r2.y;
            if (height < (float)size.height) {
                r2.y -= (float)size.height - height;
                r2.height = size.height;
            }
        } else {
            r2.height = Math.max((float)size.height, r2.height);
        }
        this._ghostRect.setRect((Rectangle2D)r2);
        super.resizeObject(g, r2);
    }

    protected IlvGraphic makeObject(IlvRect r) {
        IlvPoint startPoint = this.getStartPoint();
        Dimension prefSize = this.getNodeItemFactory().getPreferredSize();
        if (r.width < 5.0f || r.height < 5.0f) {
            IlvRect r2 = new IlvRect(r);
            r2.width = prefSize.width;
            r2.height = prefSize.height;
            this._ghostRect.setRect((Rectangle2D)r2);
            return super.makeObject(r2);
        }
        Dimension size = this.getNodeItemFactory().getMinimumSize();
        IlvRect r2 = new IlvRect(r);
        if (r2.x < startPoint.x) {
            float width = startPoint.x - r2.x;
            if (width < (float)size.width) {
                r2.x -= (float)size.width - width;
                r2.width = size.width;
            }
        } else {
            r2.width = Math.max((float)size.width, r2.width);
        }
        if (r2.y < startPoint.y) {
            float height = startPoint.y - r2.y;
            if (height < (float)size.height) {
                r2.y -= (float)size.height - height;
                r2.height = size.height;
            }
        } else {
            r2.height = Math.max((float)size.height, r2.height);
        }
        this._ghostRect.setRect((Rectangle2D)r2);
        return super.makeObject(r2);
    }

    protected NodeItemFactory getNodeItemFactory() {
        return (NodeItemFactory)this.getObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRectangleDraggedEvent(IlvRect ilvRect, MouseEvent mouseEvent) {
        IlvManager context;
        final IlvManagerView view = this.getManagerView();
        Object object = context = this.getCurrentTarget() == null ? view.getManager() : this.getCurrentTarget();
        if (!ReadOnlyUtil.checkWritableCreateNode(this.getPaletteTask().getDiagramContext(), (IlvGraphic)context)) {
            this._newGraphic = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeNodeInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
            return;
        }
        super.fireRectangleDraggedEvent(ilvRect, mouseEvent);
        try {
            view.pushInteractor((IlvManagerViewInteractor)NULL_INTERACTOR);
            this.getNodeItemFactory().postCreateNewObject(this._task.getDiagramContext(), this._task.getPaletteItem(), (IlvGraphic)context, this._newGraphic, false);
            this._newGraphic = null;
        }
        catch (Throwable throwable) {
            this._newGraphic = null;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ IlvManagerView val$view;
                {
                    this.val$view = ilvManagerView;
                }

                @Override
                public void run() {
                    if (this.val$view.getInteractor() == NULL_INTERACTOR) {
                        this.val$view.popInteractor();
                    } else {
                        this.val$view.addInteractorListener(new InteractorListener(){

                            public void interactorChanged(InteractorChangedEvent evt) {
                                if (evt.getNewValue() == NULL_INTERACTOR) {
                                    val$view.removeInteractorListener((InteractorListener)this);
                                    val$view.popInteractor();
                                }
                            }
                        });
                    }
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return null;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return null;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }

    private static class NullInteractor
    extends IlvManagerViewInteractor {
        private NullInteractor() {
        }

        public void processMouseEvent(MouseEvent event) {
        }

        public void processMouseMotionEvent(MouseEvent event) {
        }
    }
}

