/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.manager;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class VisibleObjectsIterator
implements Iterator<IlvGraphic>,
Iterable<IlvGraphic> {
    private final IlvManager _mgr;
    private final boolean _traverse;
    private LinkedList<IlvGraphic> _items;

    public VisibleObjectsIterator(IlvManager manager) {
        this(manager, false);
    }

    public VisibleObjectsIterator(IlvManager manager, boolean traverse) {
        this._mgr = manager;
        this._traverse = traverse;
    }

    @Override
    public boolean hasNext() {
        this.initialize();
        return !this._items.isEmpty();
    }

    @Override
    public IlvGraphic next() throws NoSuchElementException {
        this.initialize();
        if (this._items.isEmpty()) {
            throw new NoSuchElementException();
        }
        IlvGraphic g = this._items.removeFirst();
        if (this._traverse && g instanceof IlvManager) {
            this.appendManagerContents((IlvManager)g);
        }
        return g;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IlvGraphic> iterator() {
        return this;
    }

    private void initialize() {
        if (this._items == null) {
            this._items = new LinkedList();
            this.appendManagerContents(this._mgr);
        }
    }

    private void appendManagerContents(IlvManager mgr) {
        if (mgr.isCollapsed()) {
            return;
        }
        IlvGraphicEnumeration e = mgr.getObjects();
        while (e.hasMoreElements()) {
            IlvGraphic child = e.nextElement();
            if (!mgr.isVisible(child)) continue;
            this._items.add(child);
        }
    }
}

