/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.inspector;

import oracle.bali.inspector.PropertyInspector;
import oracle.diagram.framework.inspector.AbstractInspectable;
import oracle.diagram.framework.inspector.InspectorState;
import oracle.ide.Context;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public abstract class CustomizedInspectorInspectable
extends AbstractInspectable
implements ViewSelectionListener {
    private InspectorWindow _inspectorWindow = null;
    private InspectorState _state = null;

    protected CustomizedInspectorInspectable() {
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            this._inspectorWindow = (InspectorWindow)context.getView();
            this.enableCustomFeatures(this._inspectorWindow);
            this._inspectorWindow.addViewSelectionListener((ViewSelectionListener)this);
        } else {
            this.disableCustomFeatures(this._inspectorWindow);
            if (this._inspectorWindow != null) {
                this._inspectorWindow.removeViewSelectionListener((ViewSelectionListener)this);
            }
            this._inspectorWindow = null;
            this._state = null;
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        this.setContext(null);
    }

    protected InspectorState createState(InspectorWindow inspectorWindow) {
        return new DefaultInspectorState();
    }

    private void enableCustomFeatures(InspectorWindow inspectorWindow) {
        if (inspectorWindow != null) {
            this._state = this.createState(inspectorWindow);
            this._state.set(inspectorWindow);
        } else {
            this._state = null;
        }
    }

    private void disableCustomFeatures(InspectorWindow inspectorWindow) {
        if (inspectorWindow != null) {
            this._state.restore(inspectorWindow);
        }
    }

    protected class DefaultInspectorState
    implements InspectorState {
        private boolean _wasCategorized = false;
        private boolean _wasIntersection = false;
        private boolean _wasAlphabetized = false;
        private boolean _wasReadOnlyIncluded = false;

        protected DefaultInspectorState() {
        }

        @Override
        public void set(InspectorWindow inspectorWindow) {
            PropertyInspector pi = inspectorWindow.getPropertyInspector();
            this._wasCategorized = pi.isCategorized();
            if (this._wasCategorized != this.isCategorized()) {
                pi.setCategorized(this.isCategorized());
            }
            this._wasIntersection = pi.isIntersection();
            if (this._wasIntersection != this.isIntersection()) {
                pi.setIntersection(this.isIntersection());
            }
            this._wasAlphabetized = pi.isAlphabetizeGroupProperties();
            if (this._wasAlphabetized != this.isAlphabetized()) {
                pi.setAlphabetizeGroupProperties(this.isAlphabetized());
            }
            this._wasReadOnlyIncluded = pi.isReadOnlyIncluded();
            if (this._wasReadOnlyIncluded != this.isReadOnlyIncluded()) {
                pi.setReadOnlyIncluded(this.isReadOnlyIncluded());
            }
        }

        @Override
        public void restore(InspectorWindow inspectorWindow) {
            PropertyInspector pi = inspectorWindow.getPropertyInspector();
            if (pi.isCategorized() != this._wasCategorized) {
                pi.setCategorized(this._wasCategorized);
            }
            if (pi.isIntersection() != this._wasIntersection) {
                pi.setIntersection(this._wasIntersection);
            }
            if (pi.isAlphabetizeGroupProperties() != this._wasAlphabetized) {
                pi.setAlphabetizeGroupProperties(this._wasAlphabetized);
            }
            if (pi.isReadOnlyIncluded() != this._wasReadOnlyIncluded) {
                pi.setReadOnlyIncluded(this._wasReadOnlyIncluded);
            }
        }

        protected boolean isCategorized() {
            return true;
        }

        protected boolean isIntersection() {
            return false;
        }

        protected boolean isAlphabetized() {
            return false;
        }

        protected boolean isReadOnlyIncluded() {
            return true;
        }
    }
}

