/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout;

import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.graphic.layout.Fill;

public class ListConstraint {
    private Anchor _anchor;
    private Fill _fill;
    private float _weight;

    private ListConstraint(Anchor anchor, Fill fill, float weight) {
        if (anchor == null) {
            throw new IllegalArgumentException("Missing anchor");
        }
        if (fill == null) {
            throw new IllegalArgumentException("Missing fill");
        }
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Weight negative");
        }
        this._anchor = anchor;
        this._fill = fill;
        this._weight = fill.isVertical() ? weight : 0.0f;
    }

    public Anchor getAnchor() {
        return this._anchor;
    }

    public Fill getFill() {
        return this._fill;
    }

    public float getWeight() {
        return this._weight;
    }

    public ListConstraint derive(float weight) {
        return ListConstraint.create(this._anchor, this._fill, weight);
    }

    public static ListConstraint create(Anchor anchor, Fill fill) {
        return ListConstraint.create(anchor, fill, fill.isVertical() ? 1.0f : 0.0f);
    }

    public static ListConstraint create(Anchor anchor, Fill fill, float weight) {
        return new ListConstraint(anchor, fill, weight);
    }
}

