/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.diagram.framework.accessibility.ADACreate;
import oracle.diagram.framework.graphic.IMultipresentationContainer;
import oracle.javatools.columnlayout.LayoutBuilder;

public abstract class ADACreateLink
extends ADACreate {
    protected static String SOURCE_SUBKEY = "source";
    protected static String TARGET_SUBKEY = "destination";

    protected ADACreateLink() {
    }

    public boolean createLink() {
        boolean result;
        List<IlvGraphic> srcs = this.getValidSources();
        if (srcs.isEmpty()) {
            return false;
        }
        final JList<Object> sourceList = new JList<Object>(srcs.toArray());
        JLabel sourceListLabel = new JLabel();
        sourceListLabel.setText(this.getResources().getString(ADACreateLink.makeResKey(this.getBaseResourceKey(), SOURCE_SUBKEY, "text")));
        sourceListLabel.setDisplayedMnemonic(this.getResources().getString(ADACreateLink.makeResKey(this.getBaseResourceKey(), SOURCE_SUBKEY, "mnemonic")).charAt(0));
        sourceList.setBorder(new LineBorder(Color.BLACK));
        sourceListLabel.setLabelFor(sourceList);
        sourceList.setSelectionMode(0);
        sourceList.setCellRenderer(new ADACreate.GraphicListCellRenderer());
        sourceList.setVisibleRowCount(10);
        DefaultListModel destinationModel = new DefaultListModel();
        final JList<Object> destinationList = new JList<Object>(destinationModel);
        destinationList.setBorder(new LineBorder(Color.BLACK));
        JLabel destinationListLabel = new JLabel();
        destinationListLabel.setText(this.getResources().getString(ADACreateLink.makeResKey(this.getBaseResourceKey(), TARGET_SUBKEY, "text")));
        destinationListLabel.setDisplayedMnemonic(this.getResources().getString(ADACreateLink.makeResKey(this.getBaseResourceKey(), TARGET_SUBKEY, "mnemonic")).charAt(0));
        destinationListLabel.setLabelFor(destinationList);
        destinationList.setSelectionMode(0);
        destinationList.setCellRenderer(new ADACreate.GraphicListCellRenderer());
        LayoutBuilder builder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        JPanel listLayout = new JPanel(new GridBagLayout());
        builder.add((Component)sourceListLabel, i, 1, false, false);
        builder.addVGap();
        builder.add((Component)destinationListLabel, i, 1, false, false);
        builder.nl();
        builder.add((Component)new JScrollPane(sourceList), i, 1, true, true);
        builder.addVGap();
        builder.add((Component)new JScrollPane(destinationList), i, 1, true, true);
        builder.nl();
        builder.addToPanel((Container)listLayout);
        final ADACreate.ADACreateDialog dlg = new ADACreate.ADACreateDialog(listLayout);
        ListSelectionListener rebuildTargetListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IlvGraphic source = (IlvGraphic)sourceList.getSelectedValue();
                if (source != null) {
                    DefaultListModel<IlvGraphic> newModel = new DefaultListModel<IlvGraphic>();
                    for (IlvGraphic g : ADACreateLink.this.getValidTargets(source)) {
                        newModel.addElement(g);
                    }
                    destinationList.setModel(newModel);
                } else {
                    destinationList.setModel(new DefaultListModel());
                }
                if (destinationList.getModel().getSize() > 0) {
                    destinationList.setSelectedIndex(0);
                }
            }
        };
        sourceList.addListSelectionListener(rebuildTargetListListener);
        ListSelectionListener okayListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                dlg.setOKButtonEnabled(!destinationList.isSelectionEmpty());
            }
        };
        okayListener.valueChanged(null);
        destinationList.addListSelectionListener(okayListener);
        IlvGraphic singleSelectionGraphic = this.getInitialSelection();
        int singleSelectionIndex = srcs.indexOf(singleSelectionGraphic);
        if (singleSelectionIndex == -1 && singleSelectionGraphic != null && singleSelectionGraphic instanceof IMultipresentationContainer) {
            IlvGraphic pres = ((IMultipresentationContainer)singleSelectionGraphic).getCurrentPresentation();
            singleSelectionIndex = srcs.indexOf(pres);
        }
        if (singleSelectionIndex == -1 && !srcs.isEmpty()) {
            singleSelectionIndex = 0;
        }
        if (singleSelectionIndex != -1) {
            sourceList.addSelectionInterval(singleSelectionIndex, singleSelectionIndex);
        }
        if (result = dlg.runDialog()) {
            return this.createLink((IlvGraphic)sourceList.getSelectedValue(), (IlvGraphic)destinationList.getSelectedValue());
        }
        return result;
    }

    @Override
    protected String getBaseResourceKey() {
        return "ADACreateLink";
    }

    protected abstract boolean createLink(IlvGraphic var1, IlvGraphic var2);

    protected abstract List<IlvGraphic> getValidSources();

    protected abstract List<IlvGraphic> getValidTargets(IlvGraphic var1);
}

