/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvManagerView;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.editor.ScrollManagerViewPlugin;
import oracle.diagram.core.thumbnail.ConstrainedThumbnailView;
import oracle.diagram.core.thumbnail.ThumbnailView;
import oracle.ide.editor.AsynchronousEditor;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.thumbnail.ThumbnailDockable;
import oracle.ide.thumbnail.ThumbnailViewFactory;

public abstract class JViewsEditor
extends AsynchronousEditor
implements DiagramView {
    protected JViewsEditor() {
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return 31;
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return 21;
        }
        if ("custom_horizontal_scrollbar".equals(attribute)) {
            return this.getHorizontalScrollBar();
        }
        if ("custom_vertical_scrollbar".equals(attribute)) {
            return this.getVerticalScrollBar();
        }
        return super.getEditorAttribute(attribute);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    protected abstract Component getHorizontalScrollBar();

    protected abstract Component getVerticalScrollBar();

    static {
        ThumbnailDockable.registerThumbnailViewFactory(JViewsEditor.class, (ThumbnailViewFactory)new ThumbnailViewFactory(){

            public Component getThumbnailComponent(Editor editor) {
                IlvManagerView view = ((JViewsEditor)editor).getActiveManagerView();
                if (view != null) {
                    ScrollManagerViewPlugin plugin;
                    boolean isConstrained = false;
                    DiagramContext dc = DiagramContext.getDiagramContext(view);
                    if (dc != null && (plugin = dc.getPlugin(ScrollManagerViewPlugin.class)) != null) {
                        isConstrained = plugin.isThumbnailConstrained();
                    }
                    ThumbnailView thumb = isConstrained ? new ConstrainedThumbnailView(view) : new ThumbnailView(view);
                    JScrollPane scrollPane = new JScrollPane((Component)((Object)thumb));
                    scrollPane.setBorder(BorderFactory.createEmptyBorder());
                    return scrollPane;
                }
                return null;
            }
        });
    }
}

