/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.cmp.transport.TCPMessage;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class ErrorTCPMsg
extends TCPMessage {
    private static final TCPMessage.Type TYPE = TCPMessage.Type.ERROR_MSG_REP;
    private Code errorType;
    private byte[] data;
    private String text;
    private transient byte[] contents;

    public ErrorTCPMsg(TCPMessage.Version version, Code errorType) {
        super(version);
        this.errorType = errorType;
        this.text = errorType.toString();
        if (errorType == Code.VERSION_NOT_SUPPORTED) {
            this.data = new byte[]{(byte)version.getValue()};
            this.text = this.text + ": " + version;
        } else if (errorType == Code.GENERAL_CLIENT_ERROR) {
            this.data = new byte[0];
        } else if (errorType == Code.GENERAL_SERVER_ERROR) {
            this.data = new byte[0];
        } else {
            throw new IllegalArgumentException("Unsupported error type: " + errorType);
        }
    }

    public ErrorTCPMsg(Code errorType) {
        this(TCPMessage.Version.CMP2000, errorType);
    }

    public ErrorTCPMsg(TCPMessage.Version version, TCPMessage.Type msgType) {
        super(version);
        this.errorType = Code.INVALID_MESSAGE_TYPE;
        this.text = this.errorType + ": " + msgType;
        this.data = new byte[]{(byte)msgType.getValue()};
    }

    public ErrorTCPMsg(TCPMessage.Type msgType) {
        this(TCPMessage.Version.CMP2000, msgType);
    }

    public ErrorTCPMsg(TCPMessage.Version version, int pollRef) {
        super(version);
        this.errorType = Code.INVALID_MESSAGE_TYPE;
        this.text = this.errorType + ": " + pollRef;
        this.data = Utils.wordToBytes((int)pollRef);
    }

    public ErrorTCPMsg(int pollRef) {
        this(TCPMessage.Version.CMP2000, pollRef);
    }

    public ErrorTCPMsg(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public TCPMessage.Type getType() {
        return TYPE;
    }

    public Code getCode() {
        return this.errorType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    byte[] getValueBytes() {
        if (this.contents == null) {
            int dataLen = this.data.length;
            byte[] utf8Bytes = this.text != null ? Utils.toUTF8((String)this.text) : new byte[]{};
            int len = 4 + dataLen + utf8Bytes.length;
            try {
                FixedByteArrayOutputStream baos = new FixedByteArrayOutputStream(len);
                baos.write(this.errorType.getMajor());
                baos.write(this.errorType.getMinor());
                baos.write(dataLen >> 8);
                baos.write(dataLen);
                baos.write(this.data);
                baos.write(utf8Bytes);
                this.contents = baos.toByteArray();
                baos.close();
            }
            catch (IOException ie) {
                throw new StreamableOutputException("Error generating ErrorTCPMsg bytes");
            }
        }
        return this.contents;
    }

    @Override
    void setValueBytes(byte[] value) {
        int off = 0;
        byte major = value[off++];
        byte minor = value[off++];
        if (major >= Code.LIST.length || minor >= Code.LIST[major].length) {
            throw new StreamableInputException("Unrecognized error code: " + new Code(major, minor));
        }
        this.errorType = Code.LIST[major][minor];
        if (this.errorType == Code.DUMMY) {
            throw new StreamableInputException("Unrecognized error code: " + new Code(major, minor));
        }
        short dataLen = Utils.bytesToShort((int)value[off], (int)value[off + 1]);
        this.data = new byte[dataLen];
        System.arraycopy(value, off += 2, this.data, 0, dataLen);
        if ((off += dataLen) < value.length) {
            byte[] utf8Bytes = new byte[value.length - off];
            System.arraycopy(value, off, utf8Bytes, 0, utf8Bytes.length);
            this.text = Utils.fromUTF8((byte[])utf8Bytes);
        } else {
            this.text = null;
        }
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(TYPE.toString());
        s.append(" { errorType = " + this.errorType.toString());
        s.append(", data = " + Utils.toHexString((byte[])this.data));
        if (this.text != null) {
            s.append(", text = \"" + this.text + "\"");
        }
        s.append(" }");
        return s.toString();
    }

    public static class Code {
        public static final int VERSION_NEGOTIATION = 1;
        public static final int CLIENT_ERROR = 2;
        public static final int SERVER_ERROR = 3;
        public static final Code VERSION_NOT_SUPPORTED = new Code(1, 1);
        public static final Code GENERAL_CLIENT_ERROR = new Code(2, 0);
        public static final Code INVALID_MESSAGE_TYPE = new Code(2, 1);
        public static final Code INVALID_POLL_ID = new Code(2, 2);
        public static final Code GENERAL_SERVER_ERROR = new Code(3, 0);
        private static final Code DUMMY = new Code(-1, -1);
        private static final Code[][] LIST = new Code[][]{{DUMMY}, {DUMMY, VERSION_NOT_SUPPORTED}, {GENERAL_CLIENT_ERROR, INVALID_MESSAGE_TYPE, INVALID_POLL_ID}, {GENERAL_SERVER_ERROR}};
        private int majorValue;
        private int minorValue;

        private Code(int majorValue, int minorValue) {
            this.majorValue = majorValue;
            this.minorValue = minorValue;
        }

        public int getMajor() {
            return this.majorValue;
        }

        public int getMinor() {
            return this.minorValue;
        }

        public String toString() {
            int value = this.majorValue << 8 | this.minorValue;
            switch (value) {
                case 257: {
                    return "Version not supported";
                }
                case 512: {
                    return "General client error";
                }
                case 513: {
                    return "Invalid message type";
                }
                case 514: {
                    return "Invalid poll ID";
                }
                case 768: {
                    return "General server error";
                }
            }
            return "error 0x" + Utils.toHexString((byte[])new byte[]{(byte)this.majorValue, (byte)this.minorValue});
        }
    }
}

