/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.HereFunctionDOMXPath;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathFilter2
extends XSTransformer {
    private static final boolean xmlDebugXPath = System.getProperty("xml.debug.xpath") != null;
    static final int FILTER_SUBTRACT = 1;
    static final int FILTER_INTERSECT = 2;
    static final int FILTER_UNION = 3;
    private int[] filterType;
    private String[] xpString;
    private Element[] param;
    private Node[] xpNode;

    public XPathFilter2(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://www.w3.org/2002/06/xmldsig-filter2".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("XPath filter2 Transform required");
        }
        NodeList pList = trans.getParameters();
        if (pList.getLength() == 0) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
        this.param = new Element[pList.getLength()];
        this.xpNode = new Node[pList.getLength()];
        this.filterType = new int[pList.getLength()];
        this.xpString = new String[pList.getLength()];
        block0: for (int i = 0; i < pList.getLength(); ++i) {
            this.param[i] = (Element)pList.item(i);
            this.xpString[i] = XMLUtils.collectText(this.param[i]).trim();
            if (this.xpString[i] == null || this.xpString[i].length() == 0) {
                throw new IllegalArgumentException("Bad or missing XPath filter expression");
            }
            String filterTypeStr = this.param[i].getAttribute("Filter");
            if (filterTypeStr.equals("subtract")) {
                this.filterType[i] = 1;
            } else if (filterTypeStr.equals("intersect")) {
                this.filterType[i] = 2;
            } else if (filterTypeStr.equals("union")) {
                this.filterType[i] = 3;
            } else {
                throw new IllegalArgumentException("Illegal filter type:" + this.filterType[i] + " Expecting subtract, intersect or union");
            }
            NodeList xpList = this.param[i].getChildNodes();
            int x = xpList.getLength();
            for (int j = 0; j < x; ++j) {
                Node n = xpList.item(j);
                if (n.getNodeType() != 3) continue;
                this.xpNode[i] = n;
                continue block0;
            }
        }
    }

    static boolean intersects(List nodeList1, List nodeList2) {
        Iterator it = nodeList1.iterator();
        while (it.hasNext()) {
            if (!nodeList2.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        try {
            if (source.getSubTree().getNodeType() == 9 && this.filterType.length == 1 && this.filterType[0] == 2) {
                HereFunctionDOMXPath xpath = new HereFunctionDOMXPath(this.xpString[0]);
                xpath.setNamespaceContext(XMLUtils.createNamespaceContext(this.param[0]));
                xpath.setXPathNode(this.xpNode[0]);
                List nodes = xpath.selectNodes(this.param[0].getOwnerDocument());
                if (nodes.size() == 0) {
                    return new XMLContainer();
                }
                if (nodes.size() == 1) {
                    return new XMLContainer((Node)nodes.get(0), source.getWithComments());
                }
            }
            LinkedHashSet<Node> result = new LinkedHashSet<Node>();
            Collection nodeSet = source.subTreeAvailable() ? XMLContainer.subtreeToNodeList(source.getSubTree(), source.getWithComments(), false) : source.getNodeSet();
            if (nodeSet == null) {
                return new XMLContainer();
            }
            List[] filterNodes = new List[this.xpString.length];
            for (int i = 0; i < this.xpString.length; ++i) {
                HereFunctionDOMXPath xpath = new HereFunctionDOMXPath(this.xpString[i]);
                xpath.setNamespaceContext(XMLUtils.createNamespaceContext(this.param[i]));
                xpath.setXPathNode(this.xpNode[i]);
                filterNodes[i] = xpath.selectNodes(this.param[i].getOwnerDocument());
            }
            ArrayList lastNodeAncestors = new ArrayList();
            for (Node context : nodeSet) {
                if (xmlDebugXPath) {
                    System.err.println("Considering node " + XMLUtils.toStringNode(context));
                }
                XMLUtils.computeAncestors(context, lastNodeAncestors);
                boolean include = true;
                for (int i = 0; i < filterNodes.length; ++i) {
                    boolean inFilter = XPathFilter2.intersects(filterNodes[i], lastNodeAncestors);
                    if (this.filterType[i] == 3) {
                        if (!inFilter) continue;
                        include = true;
                        if (!xmlDebugXPath) continue;
                        System.err.println("Node included by union filter #" + i + "  " + this.xpString[i]);
                        continue;
                    }
                    if (this.filterType[i] == 1) {
                        if (!inFilter) continue;
                        include = false;
                        if (!xmlDebugXPath) continue;
                        System.err.println("Node excluded by subtract filter #" + i + "  " + this.xpString[i]);
                        continue;
                    }
                    if (this.filterType[i] != 2 || inFilter) continue;
                    include = false;
                    if (!xmlDebugXPath) continue;
                    System.err.println("Node excluded by intersect filter #" + i + "  " + this.xpString[i]);
                }
                if (!include) continue;
                result.add(context);
            }
            return new XMLContainer(result);
        }
        catch (JaxenException ex) {
            throw new TransformationException(ex);
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
    }
}

