/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.DSIGInitializer;

public class RawX509Cert
implements KeyInfoData {
    private X509Certificate cert;

    public RawX509Cert(InputStream is) throws IOException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)cf.generateCertificate(is);
        }
        catch (CertificateException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Invalid certificate bytes");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    public RawX509Cert(byte[] certBytes) throws IOException {
        this((InputStream)new UnsyncByteArrayInputStream(certBytes));
    }

    public X509Certificate getCertificate() throws IOException {
        return this.cert;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#rawX509Certificate";
    }

    static {
        DSIGInitializer.initialize();
    }
}

