/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.CipherValue;
import javax.xml.crypto.enc.EncryptedData;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.ToBeEncryptedOctetStream;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.XMLEncryptionFactory;
import javax.xml.crypto.enc.dom.DOMDecryptContext;
import javax.xml.crypto.enc.dom.DOMEncryptContext;
import javax.xml.crypto.enc.dom.DOMToBeEncryptedXML;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import javax.xml.crypto.enc.spec.RSAOAEPParameterSpec;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.dsig.JSR105Util;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSR106Util {
    static XEEncryptedData encryptUsingJSR106(XEEncryptedData enc, Element element, byte[] bytes, SecretKey key, byte[] iv, XEEncryptedData.ByteArrayHolder cipherBytes) throws XESchemaException, XECipherException {
        try {
            EncryptedData encData1;
            ToBeEncryptedOctetStream toBeEnc;
            XMLEncryptionFactory encFactory = XMLEncryptionFactory.getInstance((String)"DOM");
            DOMEncryptContext context = new DOMEncryptContext((Key)key);
            if (iv != null) {
                context.setIvParameterSpec(new IvParameterSpec(iv));
            }
            XEEncryptionMethod encMethod = enc.getEncryptionMethod();
            EncryptionMethod encMethod1 = encFactory.newEncryptionMethod(encMethod.getAlgorithm(), null, null);
            String dataType = null;
            if (element != null) {
                dataType = enc.getDataType();
                if (dataType == null) {
                    throw new XESchemaException("Missing data type attribute");
                }
                if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                    toBeEnc = new DOMToBeEncryptedXML(element, null);
                    context.setParent(element.getParentNode());
                    if (element.getNextSibling() != null) {
                        context.setNextSibling(element.getNextSibling());
                    }
                } else if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                    toBeEnc = new DOMToBeEncryptedXML(element.getChildNodes(), null);
                    context.setParent((Node)element);
                } else {
                    throw new XESchemaException("Unexpected data type: " + dataType);
                }
                if (cipherBytes != null) {
                    context.setParent(null);
                }
            } else if (bytes != null) {
                toBeEnc = new ToBeEncryptedOctetStream((InputStream)new UnsyncByteArrayInputStream(bytes));
            } else {
                throw new NullPointerException("Either element or bytes should be non null");
            }
            KeyInfo keyInfo = null;
            if (enc.getKeyInfo() != null) {
                KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");
                keyInfo = keyInfoFactory.unmarshalKeyInfo(new DOMStructure(enc.getKeyInfo().getElement()));
            }
            if (cipherBytes == null) {
                encData1 = encFactory.newEncryptedData((ToBeEncrypted)toBeEnc, encMethod1, keyInfo, null, null);
            } else {
                CipherReference cref = encFactory.newCipherReference("dummy", null);
                encData1 = encFactory.newEncryptedData((ToBeEncrypted)toBeEnc, encMethod1, keyInfo, null, null, cref);
            }
            encData1.encrypt((XMLEncryptContext)context);
            if (cipherBytes == null) {
                if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                    if (context.getNextSibling() != null) {
                        return new XEEncryptedData((Element)context.getNextSibling().getPreviousSibling());
                    }
                    return new XEEncryptedData((Element)context.getParent().getLastChild());
                }
                if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                    return new XEEncryptedData((Element)element.getFirstChild());
                }
                throw new XESchemaException("Unexpected data type: " + dataType);
            }
            cipherBytes.value = XMLUtils.readBytes(encData1.getCipherText());
            return null;
        }
        catch (MarshalException ex) {
            throw new XESchemaException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XESchemaException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XESchemaException(ex);
        }
        catch (XMLEncryptionException ex) {
            throw new XECipherException(ex);
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }

    static Element decryptUsingJSR106(XEEncryptedData enc, SecretKey key, XEEncryptedData.ByteArrayHolder plaintextBytes) throws XECipherException, XESchemaException {
        try {
            Element parent = (Element)enc.getParentNode();
            Node nextSibling = enc.getNextSibling();
            Document doc = enc.getOwnerDocument();
            XMLEncryptionFactory encFactory = XMLEncryptionFactory.getInstance((String)"DOM");
            DOMDecryptContext context = new DOMDecryptContext((Key)key, enc.getElement());
            EncryptedData encData1 = (EncryptedData)encFactory.unmarshalEncryptedType((XMLDecryptContext)context);
            context.setURIDereferencer((URIDereferencer)new JSR105Util.JSR105URIDereferencer(doc));
            String dataType = encData1.getType();
            if (plaintextBytes == null) {
                encData1.decryptAndReplace((XMLDecryptContext)context);
                if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                    if (nextSibling != null) {
                        return (Element)nextSibling.getPreviousSibling();
                    }
                    if (parent != null) {
                        return (Element)parent.getLastChild();
                    }
                    return doc.getDocumentElement();
                }
                if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                    return parent;
                }
                throw new XESchemaException("Unexpected encrypted data Type=" + dataType);
            }
            plaintextBytes.value = XMLUtils.readBytes(encData1.decrypt((XMLDecryptContext)context));
            return null;
        }
        catch (MarshalException ex) {
            throw new XESchemaException(ex);
        }
        catch (XMLEncryptionException ex) {
            throw new XECipherException(ex);
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }

    static byte[] encryptKeyUsingJSR106(XEEncryptedKey encKey, Key contentKey, Key keyEncKey) throws XESchemaException, XECipherException {
        try {
            EncryptionMethod encMethod1;
            XMLEncryptionFactory encFactory = XMLEncryptionFactory.getInstance((String)"DOM");
            DOMEncryptContext context = new DOMEncryptContext(keyEncKey);
            XEEncryptionMethod encMethod = encKey.getEncryptionMethod();
            if (encMethod.getAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
                String digestAlg = encMethod.getDigestMethod() != null ? encMethod.getDigestMethod().getAlgorithm() : "http://www.w3.org/2000/09/xmldsig#sha1";
                DigestMethod dmethod = sigFactory.newDigestMethod(digestAlg, null);
                RSAOAEPParameterSpec oaepParams = encMethod.getOAEPParams() != null ? new RSAOAEPParameterSpec(dmethod, encMethod.getOAEPParams()) : new RSAOAEPParameterSpec(dmethod);
                encMethod1 = encFactory.newEncryptionMethod(encMethod.getAlgorithm(), null, (EncryptionMethodParameterSpec)oaepParams);
            } else {
                encMethod1 = encFactory.newEncryptionMethod(encMethod.getAlgorithm(), null, null);
            }
            ToBeEncryptedKey toBeEnc = new ToBeEncryptedKey(contentKey);
            EncryptedKey encKey1 = encFactory.newEncryptedKey(toBeEnc, encMethod1, null, null, null, null, null, null);
            encKey1.encrypt((XMLEncryptContext)context);
            return ((CipherValue)encKey1.getCipherData()).getValue();
        }
        catch (MarshalException ex) {
            throw new XESchemaException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XESchemaException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XESchemaException(ex);
        }
        catch (XMLEncryptionException ex) {
            throw new XECipherException(ex);
        }
    }

    static byte[] decryptKeyUsingJSR106(XEEncryptedKey encKey, Key keyDecKey) throws XESchemaException, XECipherException {
        try {
            XMLEncryptionFactory encFactory = XMLEncryptionFactory.getInstance((String)"DOM");
            DOMDecryptContext context = new DOMDecryptContext(keyDecKey, encKey.getElement());
            EncryptedKey encKey1 = (EncryptedKey)encFactory.unmarshalEncryptedType((XMLDecryptContext)context);
            return XMLUtils.readBytes(encKey1.decrypt((XMLDecryptContext)context));
        }
        catch (MarshalException ex) {
            throw new XESchemaException(ex);
        }
        catch (XMLEncryptionException ex) {
            throw new XECipherException(ex);
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }
}

