/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class DecryptInputStream
extends FilterInputStream {
    final Cipher c;
    final int nonceLength;
    int nonceOffset = 0;
    final byte[] input;
    byte[] output;
    int inputLength = 0;
    int outputPos = 0;
    int outputLength = 0;
    boolean eof = false;
    final int blockSize;
    final boolean doPadding;
    final int paddingSize;

    public DecryptInputStream(InputStream in, Cipher c, int nonceLength) {
        super(in);
        this.c = c;
        this.blockSize = c.getBlockSize();
        this.nonceLength = nonceLength;
        this.input = new byte[1024];
        this.output = new byte[this.input.length + this.blockSize * 2];
        this.doPadding = c.getAlgorithm().contains("GCM") ? false : !c.getAlgorithm().endsWith("ISO10126Padding");
        this.paddingSize = this.doPadding ? this.blockSize : 0;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int n = this.read(b, 0, 1);
        return n == -1 ? -1 : b[0];
    }

    private int copyFromOutputBuffer(byte[] b, int off, int len) {
        if (this.outputLength - this.outputPos == 0) {
            return 0;
        }
        if (!this.eof && this.outputLength - this.outputPos <= this.paddingSize) {
            return 0;
        }
        int n = 0;
        int toCopy = Math.min(this.eof ? this.outputLength - this.outputPos : this.outputLength - this.outputPos - this.paddingSize, len);
        System.arraycopy(this.output, this.outputPos, b, off, toCopy);
        n += toCopy;
        this.outputPos += toCopy;
        if (!this.eof && this.outputLength - this.outputPos == this.paddingSize) {
            System.arraycopy(this.output, this.outputPos, this.output, 0, this.outputLength - this.outputPos);
            this.outputLength -= this.outputPos;
            this.outputPos = 0;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        int off1 = off;
        int len1 = len;
        int n1 = this.copyFromOutputBuffer(b, off1, len1);
        n += n1;
        off1 += n1;
        len1 -= n1;
        if (this.eof) {
            if (n == 0) {
                return -1;
            }
            return n;
        }
        if (this.outputLength - this.outputPos > this.paddingSize) {
            return n;
        }
        do {
            this.inputLength = this.in.read(this.input);
            if (this.inputLength == -1) {
                try {
                    if (this.c.getAlgorithm().contains("GCM")) {
                        this.output = new byte[this.c.getOutputSize(1)];
                        this.outputLength += this.c.doFinal(this.output, this.outputLength);
                    } else {
                        this.outputLength += this.c.doFinal(this.output, this.outputLength);
                    }
                }
                catch (ShortBufferException shortBufferException) {
                }
                catch (BadPaddingException badPaddingException) {
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    // empty catch block
                }
                this.eof = true;
            } else {
                try {
                    this.outputLength += this.c.update(this.input, 0, this.inputLength, this.output, this.outputLength);
                }
                catch (ShortBufferException shortBufferException) {
                    // empty catch block
                }
            }
            if (this.nonceOffset < this.nonceLength) {
                int nonceSkipped = Math.min(this.nonceLength - this.nonceOffset, this.outputLength - this.outputPos);
                this.nonceOffset += nonceSkipped;
                this.outputPos += nonceSkipped;
            }
            if (this.eof && this.doPadding) {
                byte padLength = this.output[this.outputLength - 1];
                if (padLength < 0 || padLength > this.blockSize) {
                    BadPaddingException ex = new BadPaddingException("last bytes is " + padLength);
                    IOException ex1 = new IOException();
                    ex1.initCause(ex);
                    throw ex1;
                }
                this.outputLength -= padLength;
            }
            n1 = this.copyFromOutputBuffer(b, off1, len1);
            off1 += n1;
            len1 -= n1;
        } while (!this.eof && (n += n1) < len);
        if (this.eof && n == 0) {
            return -1;
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

