/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareHighLite;
import oracle.javatools.compare.CompareHintListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.DiffGutter;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.InlineCodeHighlighter;
import oracle.javatools.compare.view.SequenceCompareView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.ViewMemento;
import oracle.javatools.compare.view.wedge.EditorHighlighter;
import oracle.javatools.compare.view.wedge.InlineCompareModel;
import oracle.javatools.compare.view.wedge.InlineDiffHighlighter;
import oracle.javatools.compare.view.wedge.OffsetDifferenceBlock;
import oracle.javatools.compare.view.wedge.TextPane;
import oracle.javatools.controls.EditorPeekPopup;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class WedgeCompareView
extends SequenceCompareView
implements EditorPaneView,
ToolTipProvider {
    private static final int WEDGE_EDGE_SIZE = 16;
    private static final String HIGHLITE_COLUMN = "HIGHLIGHT";
    private static final String PROPERTY_UNDO_MOMENTO = "wedgeCompareUndoMemento";
    private static final String PROPERTY_REDO_MOMENTO = "wedgeCompareRedoMemento";
    private final CustomViewport _leftGutter = new CustomViewport();
    private final CustomViewport _rightGutter = new CustomViewport();
    private final CustomViewport _leftEditor = new CustomViewport(ContributorKind.FIRST);
    private final CustomViewport _rightEditor = new CustomViewport(ContributorKind.SECOND);
    private CustomViewport _centerEditor;
    private CompareHintListener _compareHintListener = null;
    private final TextPane _leftPane;
    private final TextPane _rightPane;
    private TextPane _centerPane;
    private InlineDiffHighlighter _leftInlineHilite = null;
    private InlineDiffHighlighter _rightInlineHilite = null;
    private InlineDiffHighlighter _centerInlineHilite = null;
    private InlineCodeHighlighter _leftCodeHilite = null;
    private InlineCodeHighlighter _rightCodeHilite = null;
    private InlineCodeHighlighter _centerCodeHilite = null;
    private final LineGutterPlugin _leftGutterPlugin = new LineGutterPlugin();
    private final LineGutterPlugin _rightGutterPlugin = new LineGutterPlugin();
    private GutterClickListener _leftGutterClickListener;
    private GutterClickListener _rightGutterClickListener;
    private int _textPaneFontHeight;
    private boolean _verticalScrollLock = false;
    private Boolean _showInlineCharDiffs;
    private TextBufferListener _resolveOnEditListener;
    private SequenceCompareDifference _currentBlock;
    private TextPane _currentTextPane;
    private final BlockActivationListener _activationListener;
    private final PositionListenerImpl _positionListener;
    private final AutoScrollChangeListener _cl;
    private final BaseCompareView.CentralGutterMouseHandler _gutterHandler;
    private CompareHighLite _moveHighLite;
    private ViewMemento _currentMemento;
    private OffsetsMemento _currentOffsetsMemento;

    public WedgeCompareView() {
        this(CompareMode.TWO_WAY_COMPARE);
    }

    public WedgeCompareView(CompareMode mode) {
        this(mode, CompareViewBias.RIGHT);
    }

    public WedgeCompareView(CompareMode mode, CompareViewBias bias) {
        super(mode, bias);
        this._leftPane = new TextPane(ContributorKind.FIRST, bias);
        this._rightPane = new TextPane(ContributorKind.SECOND, bias);
        if (mode == CompareMode.TWO_WAY_COMPARE) {
            this.setLeftDiffGutter(new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.SECOND));
            this.setRightDiffGutter(null);
            this._centerEditor = null;
            this._centerPane = null;
            this.setThreePaneMode(false);
        }
        if (mode == CompareMode.THREE_WAY_MERGE) {
            this.setLeftDiffGutter(new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.ANCESTOR));
            this.setRightDiffGutter(new WedgeDiffGutter(ContributorKind.ANCESTOR, ContributorKind.SECOND));
            this._centerEditor = new CustomViewport(ContributorKind.ANCESTOR);
            this._centerPane = new TextPane(ContributorKind.ANCESTOR, bias);
            this.setThreePaneMode(true);
        }
        this.setLeftScrollPane(this.createHorizontalScrollPane(this._leftEditor));
        this.setRightScrollPane(this.createHorizontalScrollPane(this._rightEditor));
        if (this._centerEditor != null) {
            this.setCenterScrollPane(this.createHorizontalScrollPane(this._centerEditor));
        }
        this.getSplitPanel().add((Component)this._leftGutter, "leftGutter");
        this.getSplitPanel().add((Component)this._rightGutter, "rightGutter");
        this.getSplitPanel().add((Component)this.getLeftScrollPane(), "leftEditor");
        this.getSplitPanel().add((Component)this.getRightScrollPane(), "rightEditor");
        this.getSplitPanel().add((Component)this.getLeftTitle(), "leftTitle");
        this.getSplitPanel().add((Component)this.getCenterTitle(), "centerTitle");
        if (this._centerEditor != null) {
            this.getSplitPanel().add((Component)this.getCenterScrollPane(), "centerEditor");
        }
        this.getSplitPanel().add((Component)this.getRightTitle(), "rightTitle");
        this.getSplitPanel().add((Component)this.getLeftDiffGutter(), "leftSplit");
        if (this.getRightDiffGutter() != null) {
            this.getSplitPanel().add((Component)this.getRightDiffGutter(), "centerSplit");
        }
        this.getSplitPanel().add((Component)this.getLeftOverview(), "leftOverview");
        this.getSplitPanel().add((Component)this.getRightOverview(), "rightOverview");
        this.getSplitPanel().add((Component)this.getVerticalScrollPanel(), "rightScrollbar");
        this._leftGutter.setView(this._leftGutterPlugin);
        this._rightGutter.setView(this._rightGutterPlugin);
        this._leftEditor.setView(this._leftPane);
        this._rightEditor.setView(this._rightPane);
        if (this._centerEditor != null) {
            this._centerEditor.setView(this._centerPane);
        }
        this._leftEditor.setBackground(this._leftPane.getBackground());
        this._rightEditor.setBackground(this._leftEditor.getBackground());
        if (this._centerEditor != null) {
            this._centerEditor.setBackground(this._leftEditor.getBackground());
        }
        this._rightGutterPlugin.setLocation(4);
        this.updateFontMetrics();
        this._cl = new AutoScrollChangeListener();
        this._gutterHandler = new BaseCompareView.CentralGutterMouseHandler();
        this._activationListener = new BlockActivationListener();
        this._positionListener = new PositionListenerImpl();
        this.install();
        if (mode == CompareMode.THREE_WAY_MERGE) {
            this._resolveOnEditListener = new ResolveOnEditTextBufferListener();
        }
        this._currentTextPane = this._leftPane;
    }

    @Override
    public Component getFocusComponent() {
        return this._currentTextPane;
    }

    @Override
    public void moveToLine(ContributorKind kind, int line, boolean highLite) {
        BasicEditorPane editorMv = this.getEditorPane(kind);
        int startPos = line > -1 ? editorMv.getLineStartOffset(line) : 0;
        int endPos = line > -1 ? editorMv.getLineEndOffset(line) : 0;
        CompareContributor cont = this.getContributor(kind);
        if (cont instanceof TextCompareContributor) {
            if (highLite) {
                this._moveHighLite = new CompareHighLite(startPos, endPos, "fixed-selection-style");
                ((TextCompareContributor)cont).addHighLite(this._moveHighLite);
            } else if (this._moveHighLite != null) {
                ((TextCompareContributor)cont).deleteHighLite(this._moveHighLite);
                this.updateCodeHighLight();
            }
        }
        if (line > -1) {
            this.moveTo(kind, startPos, endPos);
        }
    }

    @Override
    public void moveTo(ContributorKind kind, int startPos, int endPos) {
        BasicEditorPane editorMv = this.getEditorPane(kind);
        int startLine = editorMv.getLineFromOffset(startPos);
        if (this.getVerticalScrollBar().isVisible()) {
            int virtualLine = this.getVirtualLineForReal(startLine, kind);
            this.verticalScrollTo(virtualLine);
        }
        this.updateModelImpl();
        this.getTextPane(kind).requestFocus();
        editorMv.setCaretPosition(startPos);
    }

    private void install() {
        this._leftEditor.addChangeListener(this._cl);
        this._rightEditor.addChangeListener(this._cl);
        this._leftPane.addFocusListener(this._activationListener);
        this._leftPane.addCaretListener(this._activationListener);
        this._rightPane.addFocusListener(this._activationListener);
        this._rightPane.addCaretListener(this._activationListener);
        this._leftPane.addToolTipProvider(this);
        this._rightPane.addToolTipProvider(this);
        this._leftPane.addFocusListener(this._positionListener);
        this._leftPane.addCaretListener(this._positionListener);
        this._rightPane.addFocusListener(this._positionListener);
        this._rightPane.addCaretListener(this._positionListener);
        this.getLeftDiffGutter().addMouseListener(this._gutterHandler);
        if (this.getRightDiffGutter() != null) {
            this.getRightDiffGutter().addMouseListener(this._gutterHandler);
        }
        if (this._centerEditor == null) {
            return;
        }
        this._centerEditor.addChangeListener(this._cl);
        this._centerPane.addFocusListener(this._activationListener);
        this._centerPane.addCaretListener(this._activationListener);
        this._centerPane.addToolTipProvider(this);
        this._centerPane.addFocusListener(this._positionListener);
        this._centerPane.addCaretListener(this._positionListener);
    }

    @Override
    public void dispose() {
        this._leftEditor.removeChangeListener(this._cl);
        this._rightEditor.removeChangeListener(this._cl);
        this._leftPane.removeFocusListener(this._activationListener);
        this._leftPane.removeCaretListener(this._activationListener);
        this._rightPane.removeFocusListener(this._activationListener);
        this._rightPane.removeCaretListener(this._activationListener);
        this._leftPane.removeToolTipProvider(this);
        this._rightPane.removeToolTipProvider(this);
        this._leftPane.removeFocusListener(this._positionListener);
        this._leftPane.removeCaretListener(this._positionListener);
        this._rightPane.removeFocusListener(this._positionListener);
        this._rightPane.removeCaretListener(this._positionListener);
        this.getLeftDiffGutter().removeMouseListener(this._gutterHandler);
        if (this.getRightDiffGutter() != null) {
            this.getRightDiffGutter().removeMouseListener(this._gutterHandler);
        }
        if (this._leftCodeHilite != null) {
            this._leftPane.deinstallPlugin(this._leftCodeHilite);
        }
        if (this._rightCodeHilite != null) {
            this._rightPane.deinstallPlugin(this._rightCodeHilite);
        }
        if (this._centerEditor != null) {
            this._centerEditor.removeChangeListener(this._cl);
            this._centerPane.removeFocusListener(this._activationListener);
            this._centerPane.removeCaretListener(this._activationListener);
            this._centerPane.removeToolTipProvider(this);
            this._centerPane.removeFocusListener(this._positionListener);
            this._centerPane.removeCaretListener(this._positionListener);
            if (this._centerCodeHilite != null) {
                this._centerPane.deinstallPlugin(this._centerCodeHilite);
            }
        }
        this._leftPane.dispose();
        this._rightPane.dispose();
        if (this._centerPane != null) {
            this._centerPane.dispose();
        }
        super.dispose();
    }

    @Override
    protected void createOverviews() {
        BlockActivationListener activationListener = new BlockActivationListener();
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            this._leftOverview = new WedgeOverviewComponent(this, ContributorKind.FIRST, ContributorKind.SECOND);
            this._rightOverview = new WedgeOverviewComponent(this, ContributorKind.SECOND, ContributorKind.FIRST);
        } else {
            this._leftOverview = new WedgeOverviewComponent(this, ContributorKind.FIRST, ContributorKind.ANCESTOR);
            this._rightOverview = new WedgeOverviewComponent(this, ContributorKind.SECOND, ContributorKind.ANCESTOR);
        }
        this._leftOverview.addFocusListener(activationListener);
        this._rightOverview.addFocusListener(activationListener);
    }

    @Override
    protected Component getOverviewLeftEditor() {
        return this._leftPane;
    }

    @Override
    protected Component getOverviewRightEditor() {
        return this._rightPane;
    }

    @Override
    protected Component getFocusableCenterEditor() {
        return this._centerPane;
    }

    private void evaluateOffsets(CompareModel compareModel) {
        for (int i = 0; i < compareModel.getDifferences().length; ++i) {
            if (!(compareModel.getDifferences()[i] instanceof OffsetDifferenceBlock)) continue;
            ((OffsetDifferenceBlock)compareModel.getDifferences()[i]).evaluateOffsets();
        }
    }

    @Override
    protected Color getOverviewDifferenceColor(SequenceCompareDifference differenceBlock, boolean isLeft, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
        HighlightStyle style;
        if (isLeft) {
            ContributorKind tempKind = firstContributorKind;
            firstContributorKind = secondContributorKind;
            secondContributorKind = tempKind;
        }
        if ((style = EditorHighlighter.getStyle((SequenceCompareModel)this.getCompareModel(), differenceBlock, firstContributorKind, secondContributorKind, secondContributorKind, this.getBias())) != null && style.getEnabled()) {
            return style.getBackgroundColor();
        }
        return null;
    }

    @Override
    protected Action[] getEditActions(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        ArrayList actions = new ArrayList();
        if (this.isGuardedDiff((SequenceCompareDifference)difference)) {
            return actions.toArray(new Action[0]);
        }
        return super.getEditActions(difference, contributor, adjacentContributor);
    }

    private void clearInlineHighLighters() {
        if (this._leftInlineHilite != null) {
            this._leftPane.deinstallPlugin(this._leftInlineHilite);
            this._rightPane.deinstallPlugin(this._rightInlineHilite);
            this._leftInlineHilite = null;
            this._rightInlineHilite = null;
        }
    }

    private void repaintEditors() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WedgeCompareView.this._leftEditor.repaint();
                WedgeCompareView.this._rightEditor.repaint();
                if (WedgeCompareView.this._centerEditor != null) {
                    WedgeCompareView.this._centerEditor.repaint();
                }
            }
        });
    }

    @Override
    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        if (this.getToolTipProvider() == null) {
            return null;
        }
        TextPane textPane = (TextPane)editorPane;
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        SequenceCompareDifference difference = this.getBlockAtRealLine(textPane, this.getTextContributor(contributorKind).getTextBuffer().getLineMap().getLineFromOffset(offset));
        return difference != null ? this.getToolTipProvider().getToolTipText(contributorKind, (CompareDifference)difference) : null;
    }

    @Override
    public void addViewEditListener(ViewEditListener l) {
        EditListenerAdapter editListener = new EditListenerAdapter(l);
        this.addViewEditListener(editListener, ContributorKind.FIRST);
        this.addViewEditListener(editListener, ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.addViewEditListener(editListener, ContributorKind.ANCESTOR);
        }
        this.getUndoableEditListeners().add(editListener);
    }

    private void addViewEditListener(EditListenerAdapter l, ContributorKind contributorKind) {
        Document jdkDoc = this.getDocument(contributorKind);
        if (!(jdkDoc instanceof BasicDocument)) {
            return;
        }
        BasicDocument basicDoc = (BasicDocument)jdkDoc;
        basicDoc.addUndoableEditListener(l);
    }

    @Override
    public void removeViewEditListener(ViewEditListener l) {
        EditListenerAdapter editListener = null;
        for (EditListenerAdapter currentEditListener : this.getUndoableEditListeners()) {
            if (currentEditListener.getViewEditListener() != l) continue;
            editListener = currentEditListener;
            break;
        }
        if (editListener == null) {
            return;
        }
        this.removeViewEditListener(editListener, ContributorKind.FIRST);
        this.removeViewEditListener(editListener, ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.removeViewEditListener(editListener, ContributorKind.ANCESTOR);
        }
        this.getUndoableEditListeners().remove(editListener);
    }

    private void removeViewEditListener(EditListenerAdapter l, ContributorKind contributorKind) {
        Document jdkDoc = this.getDocument(contributorKind);
        if (!(jdkDoc instanceof BasicDocument)) {
            return;
        }
        BasicDocument basicDoc = (BasicDocument)jdkDoc;
        basicDoc.removeUndoableEditListener(l);
    }

    @Override
    protected ViewEditListener[] getViewEditListeners() {
        ArrayList<ViewEditListener> viewEditListeners = new ArrayList<ViewEditListener>();
        Iterator itr = this.getUndoableEditListeners().iterator();
        while (itr.hasNext()) {
            viewEditListeners.add(((EditListenerAdapter)itr.next()).getViewEditListener());
        }
        return viewEditListeners.toArray(new ViewEditListener[0]);
    }

    private ContributorKind getTextContributor(Document jdkDoc) {
        if (jdkDoc == this.getDocument(ContributorKind.FIRST)) {
            return ContributorKind.FIRST;
        }
        if (jdkDoc == this.getDocument(ContributorKind.SECOND)) {
            return ContributorKind.SECOND;
        }
        if (jdkDoc == this.getDocument(ContributorKind.ANCESTOR)) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    @Override
    protected CompareModel createModel(CompareModel compareModel, CompareDifference[] differences) {
        compareModel = super.createModel(compareModel, differences);
        this.evaluateOffsets(compareModel);
        return compareModel;
    }

    private void setThreePaneMode(boolean threePanes) {
        this._leftPane.setThreePaneMode(threePanes);
        this._rightPane.setThreePaneMode(threePanes);
        if (this._centerPane != null) {
            this._centerPane.setThreePaneMode(threePanes);
        }
        this.getSplitPanel().setThreePaneMode(threePanes);
    }

    private void setCurrentBlock(SequenceCompareDifference block) {
        if (this._currentBlock != block) {
            this._currentBlock = block;
            this._leftPane.setCurrentBlock(block);
            this._rightPane.setCurrentBlock(block);
            if (this._centerPane != null) {
                this._centerPane.setCurrentBlock(block);
            }
            this.repaintDiffGutters();
            if (this.isShowInlineCharDiffs()) {
                this.clearInlineHighLighters();
                if (this._centerPane != null && this._centerInlineHilite != null) {
                    this._centerPane.deinstallPlugin(this._centerInlineHilite);
                    this._centerInlineHilite = null;
                }
                if (block != null && block.getKind() == 2) {
                    this.showInlineDifferences(block);
                }
            }
        }
    }

    private void showInlineDifferences(SequenceCompareDifference block) {
        try {
            InlineCompareModel inlineDiffs = InlineCompareModel.buildModel((SequenceCompareModel)this.getCompareModel(), block);
            this._leftInlineHilite = new InlineDiffHighlighter(ContributorKind.FIRST, this.getBias());
            this._rightInlineHilite = new InlineDiffHighlighter(ContributorKind.SECOND, this.getBias());
            if (this._centerPane != null) {
                this._centerInlineHilite = new InlineDiffHighlighter(ContributorKind.ANCESTOR, this.getBias());
            }
            this._leftPane.installPlugin(this._leftInlineHilite);
            this._rightPane.installPlugin(this._rightInlineHilite);
            if (this._centerInlineHilite != null) {
                this._centerPane.installPlugin(this._centerInlineHilite);
            }
            this._leftInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.FIRST).getTextBuffer());
            this._rightInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.SECOND).getTextBuffer());
            if (this._centerInlineHilite != null) {
                this._centerInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer());
            }
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
        }
    }

    private SequenceCompareDifference getBlockAtRealLine(TextPane textPane, int line) {
        ContributorKind contributor = this.getContributorForPane(textPane);
        return this.getBlockAtRealLine(contributor, line);
    }

    protected SequenceCompareDifference getBlockAtRealLine(ContributorKind contributor, int line) {
        Iterator i = this.getDiffBlockIterator();
        while (i.hasNext()) {
            SequenceCompareDifference block = (SequenceCompareDifference)i.next();
            if (line < block.getStart(contributor) || line >= block.getStart(contributor) + Math.max(1, block.getLength(contributor))) continue;
            if (block.getKind() == 0) {
                return null;
            }
            return block;
        }
        return null;
    }

    protected void rightSelected() {
    }

    protected void leftSelected() {
    }

    protected void centerSelected() {
    }

    private void updateCurrentBlock() {
        int maxLine;
        if (this._currentTextPane == null) {
            return;
        }
        LineMap lineMap = this.getTextContributor(this.getContributorForPane(this._currentTextPane)).getTextBuffer().getLineMap();
        int minLine = lineMap.getLineFromOffset(this._currentTextPane.getSelectionStart());
        if (minLine == (maxLine = lineMap.getLineFromOffset(this._currentTextPane.getSelectionEnd()))) {
            this.setCurrentBlock(this.getBlockAtRealLine(this._currentTextPane, minLine));
        } else {
            SequenceCompareDifference maxDiffererenceBlock;
            SequenceCompareDifference minDiffererenceBlock;
            if (lineMap.getLineStartOffset(maxLine) == this._currentTextPane.getSelectionEnd()) {
                maxLine = Math.max(minLine, maxLine - 1);
            }
            this.setCurrentBlock((SequenceCompareDifference)((minDiffererenceBlock = this.getBlockAtRealLine(this._currentTextPane, minLine)) == (maxDiffererenceBlock = this.getBlockAtRealLine(this._currentTextPane, maxLine)) ? minDiffererenceBlock : null));
        }
    }

    @Override
    public void setEditLocked(boolean isLocked) {
        super.setEditLocked(isLocked);
        this._leftPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.FIRST) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.FIRST)).isEditable());
        this._rightPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.SECOND) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.SECOND)).isEditable());
        if (this._centerPane == null) {
            return;
        }
        if (this.getTextContributor(ContributorKind.ANCESTOR) == null) {
            this._centerPane.setEditable(false);
        } else {
            this._centerPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.ANCESTOR) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.ANCESTOR)).isEditable());
        }
    }

    private void updateFontMetrics() {
        this._textPaneFontHeight = this._leftPane.getFontMetrics(this._leftPane.getFont()).getHeight();
    }

    private void moveCaretToBlock(SequenceCompareDifference block, ContributorKind contributor) {
        TextCompareContributor textCompareContributor = this.getTextContributor(contributor);
        if (textCompareContributor == null) {
            return;
        }
        if (block.getStart(contributor) < 0 || block.getLength(contributor) < 0) {
            return;
        }
        LineMap lineMap = textCompareContributor.getTextBuffer().getLineMap();
        if (this.canSelectBlockOnMoveCaret(block, contributor)) {
            int lineEndOffset = lineMap.getLineEndOffset(block.getStart(contributor) + block.getLength(contributor) - 1);
            int lineStartOffset = lineMap.getLineStartOffset(block.getStart(contributor));
            this.getTextPane(contributor).setCaretPosition(lineEndOffset);
            this.getTextPane(contributor).moveCaretPosition(lineStartOffset);
        } else {
            this.getTextPane(contributor).setCaretPosition(lineMap.getLineStartOffset(block.getStart(contributor)));
        }
    }

    private boolean canSelectBlockOnMoveCaret(SequenceCompareDifference block, ContributorKind contributor) {
        if (this.isShowInlineCharDiffs() || block.getLength(contributor) <= 0) {
            return false;
        }
        return this.getTextPane(contributor) == this._currentTextPane;
    }

    private boolean isTextPaneFocusOwner() {
        return this._leftPane.isFocusOwner() || this._rightPane.isFocusOwner() || this._centerPane != null && this._centerPane.isFocusOwner();
    }

    protected BasicEditorPane getEditorPane(ContributorKind contributor) {
        return this.getTextPane(contributor);
    }

    private TextPane getTextPane(ContributorKind contributor) {
        if (contributor == ContributorKind.FIRST) {
            return this._leftPane;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._rightPane;
        }
        if (contributor == ContributorKind.ANCESTOR) {
            return this._centerPane;
        }
        return null;
    }

    private CustomViewport getViewPort(ContributorKind contributor) {
        if (contributor == ContributorKind.FIRST) {
            return this._leftEditor;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._rightEditor;
        }
        if (contributor == ContributorKind.ANCESTOR) {
            return this._centerEditor;
        }
        return null;
    }

    private CustomViewport getGutterViewportFor(JViewport editorViewport) {
        if (editorViewport == this._leftEditor) {
            return this._leftGutter;
        }
        if (editorViewport == this._rightEditor) {
            return this._rightGutter;
        }
        return null;
    }

    private ContributorKind getContributorForViewPort(JViewport viewPort) {
        if (viewPort == this._leftEditor) {
            return ContributorKind.FIRST;
        }
        if (viewPort == this._rightEditor) {
            return ContributorKind.SECOND;
        }
        if (this._centerEditor != null && viewPort == this._centerEditor) {
            return ContributorKind.ANCESTOR;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verticalScrollTo(int virtualLine) {
        if (this._verticalScrollLock) {
            return;
        }
        try {
            this._verticalScrollLock = true;
            int leftRealLine = 0;
            int rightRealLine = 0;
            int ancestorRealLine = 0;
            int virtualHeight = 0;
            Iterator i = this.getDiffBlockIterator();
            while (i.hasNext()) {
                SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                int distance = thisBlock.getMaxLength();
                leftRealLine += thisBlock.getLength(ContributorKind.FIRST);
                rightRealLine += thisBlock.getLength(ContributorKind.SECOND);
                ancestorRealLine += thisBlock.getLength(ContributorKind.ANCESTOR);
                if ((virtualHeight += distance) < virtualLine) continue;
                int adjust = virtualHeight - virtualLine;
                leftRealLine -= Math.min(thisBlock.getLength(ContributorKind.FIRST), adjust);
                rightRealLine -= Math.min(thisBlock.getLength(ContributorKind.SECOND), adjust);
                ancestorRealLine -= Math.min(thisBlock.getLength(ContributorKind.ANCESTOR), adjust);
                break;
            }
            int pixelPosLeft = leftRealLine * this._textPaneFontHeight;
            int pixelPosRight = rightRealLine * this._textPaneFontHeight;
            int pixelPosAncestor = ancestorRealLine * this._textPaneFontHeight;
            CustomViewport leftEditor = this.getViewPort(ContributorKind.FIRST);
            CustomViewport rightEditor = this.getViewPort(ContributorKind.SECOND);
            CustomViewport ancestorEditor = this.getViewPort(ContributorKind.ANCESTOR);
            leftEditor.setViewPositionImpl(new Point(leftEditor.getViewPosition().x, pixelPosLeft));
            rightEditor.setViewPositionImpl(new Point(rightEditor.getViewPosition().x, pixelPosRight));
            if (ancestorEditor != null) {
                ancestorEditor.setViewPositionImpl(new Point(ancestorEditor.getViewPosition().x, pixelPosAncestor));
            }
            this.repaintDiffGutters();
            this.getVerticalScrollBar().setValue(virtualLine);
        }
        finally {
            this._verticalScrollLock = false;
        }
    }

    protected void updateCurrentMemento() {
        this._currentMemento = this.createMemento();
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return;
        }
        this._currentOffsetsMemento = new OffsetsMemento();
        for (CompareDifference compareDifference : this.getCompareModel().getDifferences()) {
            SequenceCompareDifference block = (SequenceCompareDifference)compareDifference;
            TextBuffer textBuffer = this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            this._currentOffsetsMemento.setStartOffset(compareDifference, lineMap.getLineStartOffset(block.getStart(ContributorKind.ANCESTOR)));
            int endOffset = lineMap.getLineStartOffset(block.getStart(ContributorKind.ANCESTOR) + Math.max(1, block.getLength(ContributorKind.ANCESTOR)));
            this._currentOffsetsMemento.setEndOffset(compareDifference, endOffset >= 0 ? endOffset : textBuffer.getLength());
        }
    }

    @Override
    protected void updateModelImpl() {
        this._currentBlock = null;
        this.updateTextPaneModel(this._leftPane);
        this.updateTextPaneModel(this._rightPane);
        if (this._centerPane != null) {
            this.updateTextPaneModel(this._centerPane);
        }
        this.updateCurrentBlock();
        this.updateCurrentMemento();
        this.updateCodeHighLight();
        this.updateCodeHighLightGutters();
    }

    private void updateCodeHighLight() {
        CompareHighLite[] hl = this.getTextContributor(ContributorKind.FIRST).getHighLite();
        this._leftCodeHilite = this.codeHighList(this._leftPane, this._leftCodeHilite, hl);
        hl = this.getTextContributor(ContributorKind.SECOND).getHighLite();
        this._rightCodeHilite = this.codeHighList(this._rightPane, this._rightCodeHilite, hl);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            hl = this.getTextContributor(ContributorKind.ANCESTOR).getHighLite();
            this._centerCodeHilite = this.codeHighList(this._centerPane, this._centerCodeHilite, hl);
        }
    }

    private void updateCodeHighLightGutters() {
        CompareHighLite[] hl = this.getTextContributor(ContributorKind.FIRST).getHighLite();
        if (hl != null) {
            this.gutterHighLite(this._leftPane, this._leftGutterPlugin, ContributorKind.FIRST, hl);
        }
        if ((hl = this.getTextContributor(ContributorKind.SECOND).getHighLite()) != null) {
            this.gutterHighLite(this._rightPane, this._rightGutterPlugin, ContributorKind.SECOND, hl);
        }
    }

    private InlineCodeHighlighter codeHighList(TextPane pane, InlineCodeHighlighter highlighter, CompareHighLite[] hl) {
        if (hl != null && highlighter == null) {
            highlighter = new InlineCodeHighlighter();
            pane.installPlugin(highlighter);
        }
        if (highlighter != null) {
            highlighter.setHighlight(hl);
        }
        return highlighter;
    }

    private void gutterHighLite(TextPane pane, LineGutterPlugin gutterPlugin, ContributorKind kind, CompareHighLite[] hls) {
        GutterColumn column = gutterPlugin.lookupGutterColumn(HIGHLITE_COLUMN);
        if (column == null) {
            column = gutterPlugin.createGutterColumn(HIGHLITE_COLUMN, new HighLiteGutterColumnListener(kind));
        }
        column.removeAllGutterMarks();
        for (CompareHighLite hl : hls) {
            int line = pane.getLineFromOffset(hl.getStartPos()) + 1;
            Object mark = column.addGutterMark(line, hl.getIcon(), null, 1, 1);
            mark.setUserData((CompareHighLite)hl);
        }
    }

    private void updateTextPaneModel(TextPane textPane) {
        int caretPos = textPane.getCaret().getDot();
        int selectionStart = textPane.getSelectionStart();
        int selectionEnd = textPane.getSelectionEnd();
        this._verticalScrollLock = true;
        if (selectionEnd <= selectionStart) {
            textPane.setSelectionStart(caretPos);
            textPane.setSelectionEnd(caretPos);
        } else {
            textPane.setSelectionStart(selectionStart);
            textPane.setSelectionEnd(selectionEnd);
        }
        this._verticalScrollLock = false;
        textPane.updateModel((SequenceCompareModel)this.getCompareModel());
    }

    @Override
    protected void initializeView(CompareModel model) {
        if (this.getCompareModel() == null && model != null) {
            EditorPlugin fontUpdatePlugin = new EditorPlugin(){

                @Override
                public void install(BasicEditorPane bep) {
                }

                @Override
                public void deinstall(BasicEditorPane bep) {
                }

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    if (pce.getPropertyName().equals("editor-font")) {
                        WedgeCompareView.this.updateFontMetrics();
                        WedgeCompareView.this.getGUI().repaint();
                    }
                }
            };
            this._leftPane.installPlugin(fontUpdatePlugin);
            this.addCompareHintListener();
        }
        if (this.getCompareModel() != null) {
            if (this._leftGutterClickListener != null) {
                this._leftGutterPlugin.removeGutterClickListener(this._leftGutterClickListener);
            }
            this._leftPane.deinstallPlugin(this._leftGutterPlugin);
            if (this._rightGutterClickListener != null) {
                this._rightGutterPlugin.removeGutterClickListener(this._rightGutterClickListener);
            }
            this._rightPane.deinstallPlugin(this._rightGutterPlugin);
        }
        this._currentBlock = null;
        this.setCompareModel(model);
        this._leftPane.setModel((SequenceCompareModel)this.getCompareModel());
        this._rightPane.setModel((SequenceCompareModel)this.getCompareModel());
        if (this._centerPane != null) {
            if (this._resolveOnEditListener != null) {
                this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer().removeTextBufferListener(this._resolveOnEditListener);
            }
            this._centerPane.setModel((SequenceCompareModel)this.getCompareModel());
            if (this._resolveOnEditListener != null) {
                this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer().addTextBufferListener(this._resolveOnEditListener);
            }
        }
        if (model != null) {
            this._leftPane.installPlugin(this._leftGutterPlugin);
            this._rightPane.installPlugin(this._rightGutterPlugin);
            if (this.getTextContributor(ContributorKind.FIRST).isHighLite()) {
                this._leftGutterClickListener = new CompareGutterClickListener(ContributorKind.FIRST);
                this._leftGutterPlugin.addGutterClickListener(this._leftGutterClickListener);
                this._leftGutterPlugin.setShowLineNumbers(1);
            }
            if (this.getTextContributor(ContributorKind.SECOND).isHighLite()) {
                this._rightGutterClickListener = new CompareGutterClickListener(ContributorKind.SECOND);
                this._rightGutterPlugin.addGutterClickListener(this._rightGutterClickListener);
                this._rightGutterPlugin.setShowLineNumbers(1);
            }
            this.setEditLocked(false);
            this.repaintDiffGutters();
        }
        if (model == null) {
            CompareHints.removeListener((CompareHintListener)this._compareHintListener);
            this._compareHintListener = null;
        }
        if (model != null && model.getType() == CompareType.DIRECTORY) {
            this._leftGutterPlugin.setShowLineNumbers(2);
            this._rightGutterPlugin.setShowLineNumbers(2);
            this._leftPane.setEditable(false);
            this._rightPane.setEditable(false);
            if (this._centerPane != null) {
                this._centerPane.setEditable(false);
            }
            this._leftPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            this._rightPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            if (this._centerPane != null) {
                this._centerPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            }
        }
        this.updateCurrentMemento();
        this.updateCodeHighLight();
        this.updateCodeHighLightGutters();
    }

    @Override
    protected CompareModel createMutableModel(CompareModel compareModel) {
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            compareModel = ((SequenceCompareModel)compareModel).createInstance((CompareDifference[])OffsetDifferenceBlock.createOffsetDifferenceBlocks(((SequenceCompareModel)compareModel).getDifferenceBlocks(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.FIRST)).getTextBuffer(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.SECOND)).getTextBuffer(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer()));
            this.evaluateOffsets(compareModel);
        }
        return compareModel;
    }

    private void addCompareHintListener() {
        if (this._compareHintListener == null) {
            this._compareHintListener = new HintListener();
        }
        CompareHints.addListener((CompareHintListener)this._compareHintListener);
    }

    private TextCompareContributor getTextContributor(ContributorKind contrib) {
        return (TextCompareContributor)this.getContributor(contrib);
    }

    public Document getDocument(ContributorKind contrib) {
        return this.getTextPane(contrib).getDocument();
    }

    private void updateVerticalScrollbar() {
        int virtualHeight = this.getVirtualHeightLines(null);
        this.getVerticalScrollBar().setMaximum(virtualHeight);
        int visibleLineCount = this.getLeftScrollPane().getViewport().getViewRect().height / this._textPaneFontHeight;
        this.getVerticalScrollBar().setVisibleAmount(visibleLineCount);
        this.getVerticalScrollBar().setBlockIncrement(visibleLineCount - 1);
        if (visibleLineCount < virtualHeight) {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalScrollbar");
        } else {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalSpacer");
        }
    }

    private boolean isGuardedBuffer(ContributorKind contributor, int lineStart) {
        TextCompareContributor tcc = this.getTextContributor(contributor);
        TextBuffer buffer = tcc.getTextBuffer();
        if (buffer instanceof GuardedTextBuffer) {
            BasicEditorPane editor = this.getEditorPane(contributor);
            int startOffset = editor.getLineStartOffset(lineStart);
            return ((GuardedTextBuffer)buffer).isOffsetGuarded(startOffset);
        }
        return false;
    }

    private boolean isGuardedDiff(SequenceCompareDifference diff) {
        if (diff == null) {
            return false;
        }
        return this.isGuardedBuffer(ContributorKind.FIRST, diff.getStart(ContributorKind.FIRST)) || this.isGuardedBuffer(ContributorKind.SECOND, diff.getStart(ContributorKind.SECOND));
    }

    @Override
    protected boolean isViewFocusOwner() {
        return this.isTextPaneFocusOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteBlock(BaseCompareDifference difference, ContributorKind contributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        if (this.isGuardedDiff(block)) {
            return;
        }
        TextCompareContributor tcc = this.getTextContributor(contributor);
        TextPane pane = this.getTextPane(contributor);
        UndoableEdit contributorEdit = null;
        try {
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("REMOVE_ACTION_NAME")));
            TextBuffer buffer = tcc.getTextBuffer();
            int start = block.getStart(contributor);
            int end = block.getStart(contributor) + block.getLength(contributor) - 1;
            int startCaretPos = buffer.getLineMap().getLineStartOffset(start);
            MergeEditState mergeEditState = this.mergePreEdit(block, contributor, 0);
            contributorEdit = tcc.deleteElement(start, end);
            this.mergePostEdit(block, contributor, mergeEditState);
            this.getTextPane(contributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(contributor).setCaretPosition(startCaretPos);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, contributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, contributor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertBlockCopy(BaseCompareDifference difference, ContributorKind fromContributor, ContributorKind toContributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        if (this.isGuardedDiff(block)) {
            return;
        }
        TextCompareContributor tcc = this.getTextContributor(toContributor);
        TextPane pane = this.getTextPane(toContributor);
        SequenceCompareElement element = this.getTextContributor(fromContributor).getElement(block, fromContributor);
        UndoableEdit contributorEdit = null;
        try {
            boolean after;
            int index;
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("INSERT_ACTION_NAME")));
            TextBuffer toBuffer = tcc.getTextBuffer();
            if (block.getLength(toContributor) == 0) {
                index = block.getStart(toContributor);
                after = false;
            } else {
                index = block.getStart(toContributor) + block.getLength(toContributor) - 1;
                after = true;
            }
            int indexCaretPos = !after ? toBuffer.getLineMap().getLineStartOffset(index) : toBuffer.getLineMap().getLineEndOffset(index);
            MergeEditState mergeEditState = this.mergePreEdit(block, toContributor, block.getLength(fromContributor) + block.getLength(toContributor));
            contributorEdit = tcc.insertElement(index, after, element);
            this.mergePostEdit(block, toContributor, mergeEditState);
            this.getTextPane(toContributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(toContributor).setCaretPosition(indexCaretPos);
            this.getTextPane(toContributor).moveCaretPosition(indexCaretPos + ((char[])element.getData()).length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, toContributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, toContributor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceBlock(BaseCompareDifference difference, ContributorKind fromContributor, ContributorKind toContributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        TextCompareContributor tcc = this.getTextContributor(toContributor);
        TextPane pane = this.getTextPane(toContributor);
        SequenceCompareElement element = this.getTextContributor(fromContributor).getElement(block, fromContributor);
        UndoableEdit contributorEdit = null;
        try {
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("REPLACE_ACTION_NAME")));
            TextBuffer toBuffer = tcc.getTextBuffer();
            int start = block.getStart(toContributor);
            int end = block.getStart(toContributor) + block.getLength(toContributor) - 1;
            int startCaretPos = toBuffer.getLineMap().getLineStartOffset(start);
            MergeEditState mergeEditState = this.mergePreEdit(block, toContributor, block.getLength(fromContributor));
            contributorEdit = tcc.replaceElement(start, end, element);
            this.mergePostEdit(block, toContributor, mergeEditState);
            this.getTextPane(toContributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(toContributor).setCaretPosition(startCaretPos);
            this.getTextPane(toContributor).moveCaretPosition(startCaretPos + ((char[])element.getData()).length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, toContributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, toContributor);
    }

    private MergeEditState mergePreEdit(SequenceCompareDifference block, ContributorKind toContributor, int length) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return null;
        }
        OffsetDifferenceBlock offsetBlock = (OffsetDifferenceBlock)block;
        MergeEditState mergeEditState = new MergeEditState(offsetBlock.getStart(toContributor), length);
        this.getTextPane(toContributor).putClientProperty(PROPERTY_UNDO_MOMENTO, this.createMemento());
        offsetBlock.resetStart(toContributor);
        offsetBlock.resetLength(toContributor);
        return mergeEditState;
    }

    private void mergePostEdit(SequenceCompareDifference block, ContributorKind toContributor, MergeEditState mergeEditState) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return;
        }
        OffsetDifferenceBlock offsetBlock = (OffsetDifferenceBlock)block;
        offsetBlock.setStart(toContributor, mergeEditState.getStartLine());
        offsetBlock.setLength(toContributor, mergeEditState.getLength());
        offsetBlock.evaluateOffsets();
        offsetBlock.setResolved(true);
        this.getTextPane(toContributor).putClientProperty(PROPERTY_REDO_MOMENTO, this.createMemento());
    }

    private void mergeEndEdit(SequenceCompareDifference block, final ContributorKind toContributor) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return;
        }
        this.updateCurrentMemento();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WedgeCompareView.this.getTextPane(toContributor).putClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO, null);
                WedgeCompareView.this.getTextPane(toContributor).putClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO, null);
            }
        });
    }

    @Override
    protected CompareDifference getPreviousDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        for (int i = this.getCompareModel().getDifferences().length - 1; i >= 0; --i) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.getStart(contributorKind) == caretLine || block.getStart(contributorKind) + block.getLength(contributorKind) > caretLine) continue;
            return block;
        }
        return null;
    }

    @Override
    protected CompareDifference getNextDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        for (int i = 0; i < this.getCompareModel().getDifferences().length; ++i) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.getStart(contributorKind) <= caretLine) continue;
            return block;
        }
        return null;
    }

    @Override
    protected CompareDifference getPreviousConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        for (int i = this.getCompareModel().getDifferences().length - 1; i >= 0; --i) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (!block.isConflict() || block.isResolved() || block.getStart(contributorKind) == caretLine || block.getStart(contributorKind) + block.getLength(contributorKind) > caretLine) continue;
            return block;
        }
        return null;
    }

    @Override
    protected CompareDifference getNextConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        for (int i = 0; i < this.getCompareModel().getDifferences().length; ++i) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (!block.isConflict() || block.isResolved() || block.getStart(contributorKind) <= caretLine) continue;
            return block;
        }
        return null;
    }

    @Override
    protected CompareDifference getCurrentDifference() {
        return this._currentBlock;
    }

    @Override
    protected ContributorKind getCurrentContributorKind() {
        TextPane currentTextPane = this.getCurrentTextPane();
        if (currentTextPane == null) {
            return null;
        }
        return this.getContributorForPane(currentTextPane);
    }

    @Override
    protected void goToDifference(CompareDifference difference, boolean requestFocus) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        int leftLine = Math.max(0, differenceBlock.getStart(ContributorKind.FIRST));
        int virtualLine = this.getVirtualLineForReal(leftLine, ContributorKind.FIRST);
        if (this.getVerticalScrollBar().isVisible()) {
            this.verticalScrollTo(virtualLine);
        }
        this.moveCaretToBlock(differenceBlock, ContributorKind.FIRST);
        this.moveCaretToBlock(differenceBlock, ContributorKind.SECOND);
        this.moveCaretToBlock(differenceBlock, ContributorKind.ANCESTOR);
    }

    public void setShowInlineDiffs(boolean showInlineDiffs) {
        this._showInlineCharDiffs = showInlineDiffs;
    }

    public boolean isShowInlineCharDiffs() {
        if (this._showInlineCharDiffs == null) {
            return CompareHints.isShowCharDifferences();
        }
        return this._showInlineCharDiffs;
    }

    private int getCurrentCaretLine(ContributorKind contributor) {
        TextPane pane = this.getTextPane(contributor);
        return this.getTextContributor(contributor).getTextBuffer().getLineMap().getLineFromOffset(pane.getCaretPosition());
    }

    private TextPane getCurrentTextPane() {
        return this._currentTextPane;
    }

    private ContributorKind getContributorForPane(TextPane pane) {
        if (pane == this._leftPane) {
            return ContributorKind.FIRST;
        }
        if (pane == this._rightPane) {
            return ContributorKind.SECOND;
        }
        if (pane == this._centerPane && this._centerPane != null) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    @Override
    public void addPopupManager(ComparePopupManager manager) {
        PopupManagerAdapter popupManager = new PopupManagerAdapter(manager);
        this._leftPane.addPopupManager(popupManager);
        this._rightPane.addPopupManager(popupManager);
        if (this._centerPane != null) {
            this._centerPane.addPopupManager(popupManager);
        }
    }

    @Override
    public void removePopupManager(ComparePopupManager manager) {
        this.removePopupManager(manager, this._leftPane);
        this.removePopupManager(manager, this._rightPane);
        if (this._centerPane != null) {
            this.removePopupManager(manager, this._centerPane);
        }
    }

    public void removePopupManager(ComparePopupManager manager, BasicEditorPane editorPane) {
        if (editorPane.getPopupManager() != null && ((PopupManagerAdapter)editorPane.getPopupManager()).getManager() == manager) {
            editorPane.removePopupManager(editorPane.getPopupManager());
        }
    }

    @Override
    public BasicEditorPane[] getEditorPanes() {
        if (this._centerPane == null) {
            return new BasicEditorPane[]{this._leftPane, this._rightPane};
        }
        return new BasicEditorPane[]{this._leftPane, this._rightPane, this._centerPane};
    }

    @Override
    public BasicEditorPane getCurrentEditorPane() {
        return this.getCurrentTextPane();
    }

    private class CustomViewport
    extends JViewport {
        private final ContributorKind _contributorKind;

        CustomViewport() {
            this(null);
        }

        CustomViewport(ContributorKind contributorKind) {
            this._contributorKind = contributorKind;
        }

        @Override
        public void setViewPosition(Point p) {
            p.y = this.getViewPosition().y;
            super.setViewPosition(p);
        }

        @Override
        public void scrollRectToVisible(Rectangle contentRect) {
            super.scrollRectToVisible(contentRect);
            if (this._contributorKind == null) {
                return;
            }
            TextPane textPane = WedgeCompareView.this.getTextPane(this._contributorKind);
            Rectangle caretRectangle = null;
            try {
                caretRectangle = textPane.modelToView(textPane.getCaret().getDot());
            }
            catch (BadLocationException ble) {
                return;
            }
            Rectangle visibleRectangle = textPane.getVisibleRect();
            if (caretRectangle == null || visibleRectangle.contains(caretRectangle)) {
                return;
            }
            if (caretRectangle.y < visibleRectangle.y || caretRectangle.y > visibleRectangle.y + visibleRectangle.height) {
                int topLine = caretRectangle.y / WedgeCompareView.this._textPaneFontHeight;
                int virtualLine = WedgeCompareView.this.getVirtualLineForReal(topLine, this._contributorKind);
                WedgeCompareView.this.verticalScrollTo(virtualLine);
            }
            if (caretRectangle.x < visibleRectangle.x || caretRectangle.x > visibleRectangle.x + visibleRectangle.width) {
                WedgeCompareView.this.horizontalScrollTo(null, caretRectangle.x);
            }
        }

        void setViewPositionImpl(Point p) {
            super.setViewPosition(p);
        }
    }

    private class WedgeDiffGutter
    extends DiffGutter {
        private Rectangle _gutterBounds;

        WedgeDiffGutter(ContributorKind leftContributor, ContributorKind rightContributor) {
            super(WedgeCompareView.this, leftContributor, rightContributor);
            this._gutterBounds = new Rectangle();
        }

        @Override
        protected ContributorKind getContributorAtPoint(Point p) {
            if (p.x <= 16) {
                return this._leftContributorKind;
            }
            if (p.x >= WedgeCompareView.this.getLeftDiffGutter().getWidth() - 16) {
                return this._rightContributorKind;
            }
            return null;
        }

        @Override
        protected CompareDifference getBlockAtPoint(Point p) {
            ContributorKind contributor = this.getContributorAtPoint(p);
            if (contributor == null) {
                return null;
            }
            int lineAtTop = WedgeCompareView.this.getViewPort((ContributorKind)contributor).getViewPosition().y / WedgeCompareView.this._textPaneFontHeight;
            int mouseLine = lineAtTop + p.y / WedgeCompareView.this._textPaneFontHeight;
            Iterator i = WedgeCompareView.this.getDiffBlockIterator();
            while (i.hasNext()) {
                SequenceCompareDifference diff = (SequenceCompareDifference)i.next();
                if (diff.getStart(contributor) > mouseLine || diff.getStart(contributor) + diff.getLength(contributor) <= mouseLine) continue;
                if (diff.getKind() == 2) {
                    return diff;
                }
                return null;
            }
            return null;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            CompareDifference block = this.getBlockAtPoint(event.getPoint());
            if (block != null && block instanceof SequenceCompareDifference && WedgeCompareView.this.isGuardedDiff((SequenceCompareDifference)block)) {
                return null;
            }
            return super.getToolTipText(event);
        }

        @Override
        public void paint(Graphics g) {
            if (WedgeCompareView.this.getCompareModel() == null) {
                return;
            }
            Rectangle clipRect = g.getClipBounds();
            this._gutterBounds.x = 0;
            this._gutterBounds.y = 0;
            this._gutterBounds.width = this.getWidth();
            this._gutterBounds.height = this.getHeight();
            clipRect = clipRect.intersection(this._gutterBounds);
            g.setColor(this.getBackground());
            g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, clipRect.y, 0, clipRect.y + clipRect.height);
            g.drawLine(this.getWidth() - 1, clipRect.y, this.getWidth() - 1, clipRect.y + clipRect.height);
            SequenceCompareDifference[] diffs = ((SequenceCompareModel)WedgeCompareView.this.getCompareModel()).getDifferenceBlocks();
            for (int i = 0; i < diffs.length; ++i) {
                int highY;
                SequenceCompareDifference diff = diffs[i];
                boolean guarded = WedgeCompareView.this.isGuardedDiff(diff);
                g.setColor(this.getLineColor(diff));
                int leftLineStart = diff.getStart(this._leftContributorKind);
                int rightLineStart = diff.getStart(this._rightContributorKind);
                int leftY = this.getLineYPos(leftLineStart) - 1;
                int rightY = this.getLineYPos(rightLineStart) - 1;
                int leftScrollPos = WedgeCompareView.this.getViewPort((ContributorKind)this._leftContributorKind).getViewPosition().y;
                int rightScrollPos = WedgeCompareView.this.getViewPort((ContributorKind)this._rightContributorKind).getViewPosition().y;
                rightY -= rightScrollPos;
                if ((leftY -= leftScrollPos) == -1) {
                    leftY = 0;
                }
                if (rightY == -1) {
                    rightY = 0;
                }
                if (leftY < 0 && rightY < 0 || leftY > (highY = g.getClipBounds().height) && rightY > highY) continue;
                int leftConnectorY = leftY;
                int rightConnectorY = rightY;
                g.drawLine(0, leftY, 16, leftY);
                int leftLength = diff.getLength(this._leftContributorKind);
                if (leftLength > 0) {
                    Icon editIcon;
                    int bottomY = this.getLineYPos(leftLineStart + leftLength) - leftScrollPos - 1;
                    leftConnectorY += (bottomY - leftY) / 2;
                    g.drawLine(0, bottomY, 16, bottomY);
                    Color oldColor = g.getColor();
                    HighlightStyle style = EditorHighlighter.getStyle((SequenceCompareModel)WedgeCompareView.this.getCompareModel(), diff, this._leftContributorKind, this._rightContributorKind, this._leftContributorKind, WedgeCompareView.this.getBias());
                    Color c = style != null && style.getEnabled() ? style.getBackgroundColor() : WedgeCompareView.this._leftPane.getBackground();
                    g.setColor(c);
                    g.fillRect(0, leftY + 1, 16, bottomY - leftY - 1);
                    g.setColor(oldColor);
                    g.drawLine(16, leftY, 16, bottomY);
                    if (!guarded && (editIcon = WedgeCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)diff, this._leftContributorKind, this._rightContributorKind, true)) != null) {
                        int x = (16 - editIcon.getIconWidth()) / 2;
                        editIcon.paintIcon(this, g, x, leftY + 3);
                    }
                }
                g.drawLine(this.getWidth() - 16, rightY, this.getWidth(), rightY);
                int rightLength = diff.getLength(this._rightContributorKind);
                if (rightLength > 0) {
                    Icon editIcon;
                    int bottomY = this.getLineYPos(rightLineStart + rightLength) - rightScrollPos - 1;
                    rightConnectorY += (bottomY - rightY) / 2;
                    g.drawLine(this.getWidth() - 16, bottomY, this.getWidth(), bottomY);
                    Color oldColor = g.getColor();
                    HighlightStyle style = EditorHighlighter.getStyle((SequenceCompareModel)WedgeCompareView.this.getCompareModel(), diff, this._leftContributorKind, this._rightContributorKind, this._rightContributorKind, WedgeCompareView.this.getBias());
                    Color c = style != null && style.getEnabled() ? style.getBackgroundColor() : WedgeCompareView.this._rightPane.getBackground();
                    g.setColor(c);
                    g.fillRect(this.getWidth() - 16, rightY + 1, 16, bottomY - rightY - 1);
                    g.setColor(oldColor);
                    g.drawLine(this.getWidth() - 16, rightY, this.getWidth() - 16, bottomY);
                    if (!guarded && (editIcon = WedgeCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)diff, this._rightContributorKind, this._leftContributorKind, false)) != null) {
                        int x = this.getWidth() - 16 + 1 + (16 - editIcon.getIconWidth()) / 2;
                        editIcon.paintIcon(this, g, x, rightY + 3);
                    }
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int curvaceousness = 12;
                CubicCurve2D.Double curve = new CubicCurve2D.Double(16.0, leftConnectorY, 16 + curvaceousness, leftConnectorY, this.getWidth() - 16 - curvaceousness, rightConnectorY, this.getWidth() - 16, rightConnectorY);
                ((Graphics2D)g).draw(curve);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }

        private int getLineYPos(int line) {
            return WedgeCompareView.this._leftEditor.getInsets().top - this.getInsets().top + line * WedgeCompareView.this._textPaneFontHeight;
        }

        private Color getLineColor(SequenceCompareDifference diff) {
            Color c = UIManager.getColor("controlShadow");
            if (diff != WedgeCompareView.this._currentBlock || WedgeCompareView.this.getCompareModel().getType() == CompareType.DIRECTORY) {
                return c;
            }
            if (WedgeCompareView.this._leftPane == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane null"));
                return c;
            }
            if (WedgeCompareView.this._leftPane.getBlockHighlighter() == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane.getBlockHighlighter() returned null"));
                return c;
            }
            if (WedgeCompareView.this._leftPane.getBlockHighlighter().getSeparatorStyle(true) == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane.getBlockHighlighter().getSeparatorStyle() returned null"));
                return c;
            }
            return WedgeCompareView.this._leftPane.getBlockHighlighter().getSeparatorStyle(true).getUnderlineColor();
        }
    }

    private class AutoScrollChangeListener
    implements ChangeListener {
        private final Point _scratchPoint = new Point();

        private AutoScrollChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            CustomViewport viewport = (CustomViewport)ce.getSource();
            if (!WedgeCompareView.this._verticalScrollLock && WedgeCompareView.this.isSyncVerticalScroll()) {
                int mod = viewport.getViewPosition().y % WedgeCompareView.this._textPaneFontHeight;
                if (mod != 0) {
                    this._scratchPoint.x = viewport.getViewPosition().x;
                    this._scratchPoint.y = viewport.getViewPosition().y + (WedgeCompareView.this._textPaneFontHeight - mod);
                    viewport.setViewPositionImpl(this._scratchPoint);
                    return;
                }
                int topLine = viewport.getViewPosition().y / WedgeCompareView.this._textPaneFontHeight;
                int virtualPos = WedgeCompareView.this.getVirtualLineForReal(topLine, WedgeCompareView.this.getContributorForViewPort(viewport));
                WedgeCompareView.this.verticalScrollTo(virtualPos);
            }
            WedgeCompareView.this.updateVerticalScrollbar();
            CustomViewport gutter = WedgeCompareView.this.getGutterViewportFor(viewport);
            if (gutter != null) {
                this._scratchPoint.x = 0;
                this._scratchPoint.y = viewport.getViewPosition().y;
                gutter.setViewPositionImpl(this._scratchPoint);
            }
        }
    }

    private class BlockActivationListener
    implements FocusListener,
    CaretListener {
        private BlockActivationListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            try {
                TextPane nextTextPane = null;
                if (e.getSource() instanceof TextPane) {
                    nextTextPane = (TextPane)e.getSource();
                }
                if (e.getSource() == WedgeCompareView.this._leftOverview) {
                    nextTextPane = WedgeCompareView.this._leftPane;
                }
                if (e.getSource() == WedgeCompareView.this._rightOverview) {
                    nextTextPane = WedgeCompareView.this._rightPane;
                }
                assert (nextTextPane != null);
                boolean clearSelection = nextTextPane != WedgeCompareView.this._currentTextPane;
                WedgeCompareView.this._currentTextPane = nextTextPane;
                WedgeCompareView.this.updateCurrentBlock();
                if (!clearSelection) {
                    return;
                }
                if (WedgeCompareView.this._currentTextPane != WedgeCompareView.this._leftPane) {
                    this.clearSelection(WedgeCompareView.this._leftPane);
                }
                if (WedgeCompareView.this._centerPane != null && WedgeCompareView.this._currentTextPane != WedgeCompareView.this._centerPane) {
                    this.clearSelection(WedgeCompareView.this._centerPane);
                }
                if (WedgeCompareView.this._currentTextPane != WedgeCompareView.this._rightPane) {
                    this.clearSelection(WedgeCompareView.this._rightPane);
                }
                if (WedgeCompareView.this._currentTextPane == WedgeCompareView.this._leftPane) {
                    WedgeCompareView.this.leftSelected();
                } else if (WedgeCompareView.this._currentTextPane == WedgeCompareView.this._rightPane) {
                    WedgeCompareView.this.rightSelected();
                } else {
                    WedgeCompareView.this.centerSelected();
                }
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                // empty catch block
            }
        }

        private void clearSelection(TextPane textPane) {
            textPane.select(textPane.getCaretPosition(), textPane.getCaretPosition());
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            try {
                WedgeCompareView.this.updateCurrentBlock();
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                // empty catch block
            }
        }
    }

    private class PositionListenerImpl
    extends BaseCompareView.PositionListener
    implements CaretListener {
        private PositionListenerImpl() {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            this.resetTimer();
        }
    }

    private class ResolveOnEditTextBufferListener
    implements TextBufferListener {
        private ResolveOnEditTextBufferListener() {
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            this.resolveOnEdit(offset, count);
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            this.resolveOnEdit(offset, count);
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void resolveOnEdit(int offset, int count) {
            for (CompareDifference compareDifference : this.getBlocksFromMemento(offset, count)) {
                compareDifference.setResolved(true);
            }
        }

        private Collection<CompareDifference> getBlocksFromMemento(int offset, int count) {
            ArrayList<CompareDifference> compareDifferences = new ArrayList<CompareDifference>();
            WedgeCompareView.this.updateCurrentMemento();
            if (WedgeCompareView.this._currentMemento == null) {
                return compareDifferences;
            }
            for (CompareDifference compareDifference : WedgeCompareView.this.getCompareModel().getDifferences()) {
                if (WedgeCompareView.this._currentOffsetsMemento.getStartOffset(compareDifference) >= offset + count || WedgeCompareView.this._currentOffsetsMemento.getEndOffset(compareDifference) <= offset) continue;
                compareDifferences.add(compareDifference);
            }
            return compareDifferences;
        }
    }

    private static class WedgeOverviewComponent
    extends SequenceCompareView.OverviewComponent {
        private final WedgeCompareView _view;

        public WedgeOverviewComponent(WedgeCompareView view, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
            super(view, firstContributorKind, secondContributorKind);
            this._view = view;
            MouseHandler mh = new MouseHandler();
            this.addMouseListener(mh);
            this.addMouseMotionListener(mh);
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            return null;
        }

        private class MouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                EditorPeekPopup.hidePopup(true);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SequenceCompareDifference diff = WedgeOverviewComponent.this.getDifferenceForPosition(e.getPoint());
                if (diff != null) {
                    TextPane pane = WedgeOverviewComponent.this._view.getTextPane(WedgeOverviewComponent.this._firstContributorKind);
                    boolean isLeft = WedgeOverviewComponent.this._firstContributorKind == ContributorKind.FIRST;
                    Insets insets = WedgeOverviewComponent.this.getInsets();
                    int height = WedgeOverviewComponent.this.getHeight() - insets.top - insets.bottom;
                    int virtualHeight = pane.getLineCount();
                    float vPixelsPerLine = (float)height / (float)virtualHeight;
                    int blockHeight = diff.getLength(WedgeOverviewComponent.this._firstContributorKind);
                    if (diff.getKind() == 2) {
                        int y = (int)((float)this._getBlockY(diff) * vPixelsPerLine) + insets.top;
                        int h = Math.max((int)((float)blockHeight * vPixelsPerLine), 1);
                        Point topPoint = new Point(insets.left, y);
                        SwingUtilities.convertPointToScreen(topPoint, WedgeOverviewComponent.this);
                        Rectangle sourceRect = new Rectangle(topPoint.x, topPoint.y, WedgeOverviewComponent.this.getWidth() - insets.right - insets.left, h);
                        int lineStart = diff.getStart(WedgeOverviewComponent.this._firstContributorKind);
                        int lineEnd = lineStart + diff.getLength(WedgeOverviewComponent.this._firstContributorKind);
                        String text = WedgeOverviewComponent.this.getDescription(diff, lineStart + 1, lineEnd - lineStart);
                        EditorPeekPopup.showPopup((Object)diff, (BasicEditorPane)pane, text, sourceRect, lineStart - 1, lineEnd - 1, WedgeOverviewComponent.this._view._textPaneFontHeight, WedgeOverviewComponent.this._view.getOverviewDifferenceColor(diff, isLeft, WedgeOverviewComponent.this._secondContributorKind, WedgeOverviewComponent.this._firstContributorKind), (int)((float)WedgeOverviewComponent.this._view._textPaneFontHeight * 0.2f), -1);
                    }
                } else {
                    WedgeOverviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    EditorPeekPopup.hidePopup(false);
                }
            }

            protected String getAccessibleDifferenceText(SequenceCompareDifference diff) {
                if (diff.getKind() != 2) {
                    return null;
                }
                int lineStart = diff.getStart(WedgeOverviewComponent.this._firstContributorKind);
                int lineEnd = lineStart + diff.getLength(WedgeOverviewComponent.this._firstContributorKind);
                return WedgeOverviewComponent.this.getDescription(diff, lineStart + 1, lineEnd - lineStart);
            }

            private int _getBlockY(SequenceCompareDifference diff) {
                int y = 0;
                Iterator i = WedgeOverviewComponent.this._view.getDiffBlockIterator();
                while (i.hasNext()) {
                    SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                    if (thisBlock == diff) {
                        return y;
                    }
                    y += thisBlock.getLength(WedgeOverviewComponent.this._firstContributorKind);
                }
                return 0;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EditorPeekPopup.hidePopup(false);
            }
        }
    }

    private class EditListenerAdapter
    implements UndoableEditListener {
        private final ViewEditListener _l;

        EditListenerAdapter(ViewEditListener l) {
            this._l = l;
        }

        ViewEditListener getViewEditListener() {
            return this._l;
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent event) {
            if (!event.getEdit().isSignificant()) {
                return;
            }
            ContributorKind contributor = WedgeCompareView.this.getTextContributor((Document)event.getSource());
            ViewMemento undoMemento = (ViewMemento)WedgeCompareView.this.getTextPane(contributor).getClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO);
            ViewMemento redoMemento = (ViewMemento)WedgeCompareView.this.getTextPane(contributor).getClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO);
            if (undoMemento == null) {
                undoMemento = WedgeCompareView.this._currentMemento;
            }
            if (redoMemento == null) {
                redoMemento = WedgeCompareView.this.createMemento();
            }
            WedgeCompareView.this.updateCurrentMemento();
            this._l.viewEditHappened(new ViewEditEvent(WedgeCompareView.this, 1, contributor, new ViewEdit(event.getEdit(), WedgeCompareView.this, undoMemento, redoMemento)));
            WedgeCompareView.this.fireStatusChanged();
        }
    }

    private class OffsetsMemento {
        private final Map<CompareDifference, Integer> _offsets1 = new HashMap<CompareDifference, Integer>();
        private final Map<CompareDifference, Integer> _offsets2 = new HashMap<CompareDifference, Integer>();

        private OffsetsMemento() {
        }

        void setStartOffset(CompareDifference compareDifference, int offset) {
            this._offsets1.put(compareDifference, offset);
        }

        void setEndOffset(CompareDifference compareDifference, int offset) {
            this._offsets2.put(compareDifference, offset);
        }

        int getStartOffset(CompareDifference compareDifference) {
            return this._offsets1.get(compareDifference);
        }

        int getEndOffset(CompareDifference compareDifference) {
            return this._offsets2.get(compareDifference);
        }
    }

    private class HighLiteGutterColumnListener
    implements GutterColumnListener {
        private ContributorKind _kind;

        HighLiteGutterColumnListener(ContributorKind kind) {
            this._kind = kind;
        }

        public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        }

        public void markRemoved(GutterMark gutterMark, int deletedLine) {
        }

        public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
            CompareHighLite data = (CompareHighLite)gutterMark.getUserData();
            ((TextCompareContributor)WedgeCompareView.this.getContributor(this._kind)).selected(data);
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
            CompareHighLite data = (CompareHighLite)gutterMark.getUserData();
            return data.getToolTip();
        }
    }

    private class CompareGutterClickListener
    implements GutterClickListener {
        private ContributorKind _kind;

        CompareGutterClickListener(ContributorKind kind) {
            this._kind = kind;
        }

        @Override
        public void lineClicked(Gutter gutter, int clickedLine, MouseEvent event) {
            --clickedLine;
            BasicEditorPane editor = WedgeCompareView.this.getEditorPane(this._kind);
            int startPos = editor.getSelectionStart();
            int endPos = editor.getSelectionEnd();
            int startLine = editor.getLineFromOffset(startPos);
            int endLine = editor.getLineFromOffset(endPos);
            if (endPos == 0 || startPos == endPos || clickedLine < startLine || clickedLine > endLine) {
                endPos = editor.getLineEndOffset(clickedLine);
                startPos = editor.getLineStartOffset(clickedLine);
                startLine = clickedLine;
                endLine = clickedLine + 1;
                editor.setCaretPosition(endPos);
                editor.moveCaretPosition(startPos);
                ++startLine;
            } else {
                int posFromEnd = editor.getLineStartOffset(endLine);
                if (posFromEnd != endPos) {
                    ++endLine;
                }
                ++startLine;
            }
            if (endLine < startLine) {
                endLine = startLine;
            }
            ((TextCompareContributor)WedgeCompareView.this.getContributor(this._kind)).newHighLite(startPos, endPos, startLine, endLine);
        }
    }

    private class HintListener
    implements CompareHintListener {
        private HintListener() {
        }

        public void CompareHintUpdated(String key) {
            if (!WedgeCompareView.this.isShowInlineCharDiffs()) {
                WedgeCompareView.this.clearInlineHighLighters();
            }
            SequenceCompareDifference tBlock = WedgeCompareView.this._currentBlock;
            WedgeCompareView.this._currentBlock = null;
            WedgeCompareView.this.setCurrentBlock(tBlock);
            WedgeCompareView.this.repaintEditors();
        }
    }

    private class MergeEditState {
        private final int _startLine;
        private final int _length;

        MergeEditState(int startLine, int length) {
            this._startLine = startLine;
            this._length = length;
        }

        int getStartLine() {
            return this._startLine;
        }

        int getLength() {
            return this._length;
        }
    }

    class PopupManagerAdapter
    implements PopupManager {
        private ComparePopupManager _manager;

        PopupManagerAdapter(ComparePopupManager manager) {
            this._manager = manager;
        }

        @Override
        public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
            this._manager.showPopup(mouseEvent);
        }

        @Override
        public void hidePopup(BasicEditorPane editorPane) {
            this._manager.hidePopup();
        }

        ComparePopupManager getManager() {
            return this._manager;
        }
    }
}

