/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Container;
import java.util.ArrayList;
import oracle.javatools.columnlayout.LayoutComponent;
import oracle.javatools.columnlayout.LayoutRow;

public class LayoutPanel
implements LayoutComponent {
    private int m_currentRow = 0;
    private int m_totalRowCount = 0;
    private int m_totalColumnCount = 0;
    private boolean m_createRow = true;
    private ArrayList m_grid = new ArrayList();

    @Override
    public void addToPanel(Container container, int baseRow, int baseColumn, boolean[] rowConstraints, boolean[] columnConstraints, int rowSpan) {
        if (rowSpan < this.m_totalRowCount) {
            throw new IllegalArgumentException("Row span is not large enough");
        }
        int end = this.m_grid.size() - 1;
        if (end >= 0) {
            for (int i = 0; i < end; ++i) {
                LayoutRow row = (LayoutRow)this.m_grid.get(i);
                int rowCount = row.getRowCount();
                row.addToPanel(container, baseRow, baseColumn, rowConstraints, columnConstraints, rowCount);
                baseRow += rowCount;
                rowSpan -= rowCount;
            }
            LayoutRow row = (LayoutRow)this.m_grid.get(end);
            row.addToPanel(container, baseRow, baseColumn, rowConstraints, columnConstraints, rowSpan);
        }
    }

    @Override
    public void areRowsResizable(boolean[] rowConstraints, int baseRow, int rowSpan) {
        if (rowSpan < this.m_totalRowCount) {
            throw new IllegalArgumentException("Row span is not large enough");
        }
        int end = this.m_grid.size() - 1;
        if (end >= 0) {
            for (int i = 0; i < end; ++i) {
                LayoutRow row = (LayoutRow)this.m_grid.get(i);
                int rowCount = row.getRowCount();
                row.areRowsResizable(rowConstraints, baseRow, rowCount);
                baseRow += rowCount;
                rowSpan -= rowCount;
            }
            LayoutRow row = (LayoutRow)this.m_grid.get(end);
            row.areRowsResizable(rowConstraints, baseRow, rowSpan);
        }
    }

    @Override
    public void areColumnsResizable(boolean[] columnConstraints, int baseColumn) {
        for (int i = this.m_grid.size() - 1; i >= 0; --i) {
            LayoutRow row = (LayoutRow)this.m_grid.get(i);
            row.areColumnsResizable(columnConstraints, baseColumn);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_totalRowCount;
    }

    @Override
    public int getColumnCount() {
        return this.m_totalColumnCount;
    }

    public void add(LayoutComponent lc) {
        int newColumnCount;
        if (this.m_createRow) {
            this.m_grid.add(new LayoutRow());
            this.m_createRow = false;
        }
        LayoutRow row = (LayoutRow)this.m_grid.get(this.m_currentRow);
        int oldRowCount = row.getRowCount();
        row.add(lc);
        int newRowCount = row.getRowCount();
        if (newRowCount > oldRowCount) {
            this.m_totalRowCount += newRowCount - oldRowCount;
        }
        if ((newColumnCount = row.getColumnCount()) > this.m_totalColumnCount) {
            this.m_totalColumnCount = newColumnCount;
        }
    }

    public void nl() {
        if (this.m_createRow) {
            return;
        }
        ++this.m_currentRow;
        this.m_createRow = true;
    }
}

