/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.xml;

import java.util.ArrayList;
import oracle.olapi.xml.XMLDeferredElementState;
import oracle.olapi.xml.XMLException;
import oracle.olapi.xml.XMLState;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class TagHandler
extends DefaultHandler {
    private XMLState m_State = null;
    private XMLState m_InitialState = null;
    private XMLException m_RootException = null;
    private boolean m_NeedsReset = false;
    private String m_ErrorElemName = null;
    private Locator m_Locator = null;
    private ArrayList<XMLDeferredElementState> m_DeferredElements = null;
    private boolean m_CanDeferElement = true;
    private Attributes m_CurrentAttrs = null;

    protected TagHandler() {
    }

    public final XMLState getInitialState() {
        XMLState xMLState = this.m_InitialState;
        if (null == xMLState) {
            this.m_InitialState = xMLState = this.createInitialState();
        }
        return xMLState;
    }

    public final XMLState getState() {
        return this.m_State;
    }

    protected final void setState(XMLState xMLState) {
        this.m_State = xMLState;
    }

    public final boolean hasErrors() {
        return null != this.getRootException() && !this.getRootException().isWarning();
    }

    public final boolean hasWarnings() {
        return null != this.getRootException() && !this.getRootException().isError();
    }

    public final XMLException getRootException() {
        return this.getRootException(false);
    }

    public final XMLException getRootException(boolean bl) {
        XMLException xMLException = this.m_RootException;
        if (null == xMLException && bl) {
            this.m_RootException = xMLException = this.createRootException();
        }
        return xMLException;
    }

    public final void reportError(String string) {
        this.reportError(string, new String[]{null});
    }

    public final void reportWarning(String string) {
        this.reportWarning(string, new String[]{null});
    }

    public final void reportError(String string, String string2) {
        this.reportError(string, new String[]{string2, null});
    }

    public final void reportWarning(String string, String string2) {
        this.reportWarning(string, new String[]{string2, null});
    }

    public final void reportError(String string, String[] stringArray) {
        this.reportError(string, stringArray, true);
    }

    public final void reportError(String string, String[] stringArray, boolean bl) {
        this.reportException(string, stringArray, bl, false);
    }

    public final void reportWarning(String string, String[] stringArray) {
        this.reportException(string, stringArray, false, true);
    }

    public final void reportException(String string, String[] stringArray, boolean bl, boolean bl2) {
        int n;
        if (null != this.getState()) {
            String string2 = this.getState().getFullXmlTagName(this);
            for (n = 0; n < stringArray.length; ++n) {
                if (null != stringArray[n]) continue;
                stringArray[n] = string2;
            }
        }
        int n2 = this.getCurrentLineNumber();
        n = this.getCurrentColumnNumber();
        XMLException xMLException = this.createXMLException(string, stringArray, bl2, n2, n);
        this.reportException(xMLException, bl, bl2);
    }

    public final void reportException(Exception exception, boolean bl, boolean bl2) {
        if (!(exception instanceof XMLException)) {
            int n = this.getCurrentLineNumber();
            int n2 = this.getCurrentColumnNumber();
            exception = this.createXMLException(exception, bl2, n, n2);
        }
        this.getRootException(true).addException(exception, bl2);
        if (bl) {
            throw this.getRootException();
        }
    }

    public final int getCurrentLineNumber() {
        return this.getCurrentLocatorNumber(true);
    }

    public final int getCurrentColumnNumber() {
        return this.getCurrentLocatorNumber(false);
    }

    protected final boolean needsReset() {
        return this.m_NeedsReset;
    }

    protected final void setNeedsReset(boolean bl) {
        this.m_NeedsReset = bl;
    }

    final String getErrorElementName() {
        return this.m_ErrorElemName;
    }

    protected final Locator getLocator() {
        return this.m_Locator;
    }

    protected final void processException(Exception exception) {
        if (this.getRootException() != exception) {
            this.reportException(exception, false, false);
        }
        if (this.stopOnFirstError()) {
            throw this.getRootException();
        }
    }

    public final XMLDeferredElementState deferElement(String string) {
        if (null == this.m_DeferredElements) {
            this.m_DeferredElements = new ArrayList();
        }
        XMLDeferredElementState xMLDeferredElementState = new XMLDeferredElementState();
        this.m_DeferredElements.add(xMLDeferredElementState);
        return xMLDeferredElementState;
    }

    public final void resolveDeferredElements() throws SAXException {
        if (null == this.m_DeferredElements) {
            return;
        }
        XMLState xMLState = this.getState();
        for (int i = 0; i < this.m_DeferredElements.size(); ++i) {
            XMLDeferredElementState xMLDeferredElementState = this.m_DeferredElements.get(i);
            this.setState(xMLDeferredElementState.getParentState());
            this.setCanDeferElement(false);
            this.resolveDeferredElement(xMLDeferredElementState);
        }
        this.setState(xMLState);
        this.m_DeferredElements.clear();
    }

    public final boolean canDeferElement() {
        return this.m_CanDeferElement;
    }

    protected final Attributes getCurrentAttributes() {
        return this.m_CurrentAttrs;
    }

    protected abstract XMLState createInitialState();

    protected XMLException createRootException() {
        return new XMLException("InvalidXML", null, true);
    }

    protected XMLException createXMLException(String string, String[] stringArray, boolean bl, int n, int n2) {
        return new XMLException(string, stringArray, bl, n, n2);
    }

    protected XMLException createXMLException(Exception exception, boolean bl, int n, int n2) {
        return new XMLException(exception, bl, n, n2);
    }

    protected boolean stopOnFirstError() {
        return false;
    }

    protected void resetState() {
        this.m_State = null;
        this.m_InitialState = null;
        this.m_RootException = null;
        this.m_Locator = null;
        if (null != this.m_DeferredElements) {
            this.m_DeferredElements.clear();
        }
        this.setCanDeferElement(true);
    }

    @Override
    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (null != this.getErrorElementName()) {
            return;
        }
        XMLState xMLState = this.getState();
        try {
            this.setCurrentAttributes(attributes);
            XMLState xMLState2 = xMLState.transition(string2, attributes, this);
            if (null == xMLState2) {
                String string4 = "<" + string2 + ">";
                if (xMLState == this.getInitialState()) {
                    this.reportError("InvalidXMLTopElement", new String[]{string4});
                } else {
                    this.reportError("InvalidXMLSubElement", string4);
                }
            } else {
                this.setState(xMLState2);
                xMLState2.setLocationInfo(string2, this.getLocator(), xMLState);
                xMLState2.enter(string2, attributes, this);
            }
        }
        catch (Exception exception) {
            this.processException(exception);
            this.setState(xMLState);
            this.setErrorElementName(string2);
        }
        this.setCurrentAttributes(null);
    }

    @Override
    public final void endElement(String string, String string2, String string3) throws SAXException {
        XMLState xMLState = this.getState();
        try {
            if (string2.equals(this.getErrorElementName())) {
                this.setErrorElementName(null);
            } else if (null == this.getErrorElementName()) {
                this.setState(this.getState().exit(this));
            }
        }
        catch (Exception exception) {
            this.processException(exception);
            this.setState(xMLState.getParentState());
        }
    }

    @Override
    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.getErrorElementName()) {
            return;
        }
        XMLState xMLState = this.getState();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(cArray[n + i]);
            }
            if (!xMLState.processCharData(stringBuffer.toString(), this)) {
                String string = "<" + xMLState.getElementName() + ">";
                if (xMLState == this.getInitialState()) {
                    this.reportError("InvalidXMLTopElement", new String[]{string});
                } else {
                    this.reportError("InvalidXMLSubElement", string);
                }
            }
        }
        catch (Exception exception) {
            this.processException(exception);
            this.setErrorElementName(xMLState.getElementName());
        }
    }

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.reportException(sAXParseException, false, true);
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.reportException(sAXParseException, false, false);
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportException(sAXParseException, true, false);
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
        this.m_Locator = locator;
    }

    final void setErrorElementName(String string) {
        this.m_ErrorElemName = string;
    }

    private int getCurrentLocatorNumber(boolean bl) {
        if (null != this.getState()) {
            if (bl) {
                return this.getState().getLineNumber();
            }
            return this.getState().getColumnNumber();
        }
        if (null != this.getLocator()) {
            if (bl) {
                return this.getLocator().getLineNumber();
            }
            return this.getLocator().getColumnNumber();
        }
        return -1;
    }

    private void resolveDeferredElement(XMLDeferredElementState xMLDeferredElementState) throws SAXException {
        Locator locator = this.getLocator();
        this.setDocumentLocator(xMLDeferredElementState.getLocator());
        if (null != xMLDeferredElementState.getCharData()) {
            String string = xMLDeferredElementState.getCharData();
            this.characters(string.toCharArray(), 0, string.length());
        } else {
            String string = "";
            String string2 = xMLDeferredElementState.getElementName();
            String string3 = "";
            Attributes attributes = xMLDeferredElementState.getAttributes();
            this.startElement(string, string2, string3, attributes);
            this.setCanDeferElement(true);
            ArrayList<XMLDeferredElementState> arrayList = xMLDeferredElementState.getSubElements();
            if (null != arrayList) {
                for (XMLDeferredElementState xMLDeferredElementState2 : arrayList) {
                    this.resolveDeferredElement(xMLDeferredElementState2);
                }
            }
            this.endElement(string, string2, string3);
        }
        this.setDocumentLocator(locator);
    }

    private void setCanDeferElement(boolean bl) {
        this.m_CanDeferElement = bl;
    }

    private void setCurrentAttributes(Attributes attributes) {
        this.m_CurrentAttrs = attributes;
    }
}

