/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmAggregationSpecification;
import oracle.olapi.metadata.mtm.MtmAggregationStep;
import oracle.olapi.metadata.mtm.MtmCustomExpression;
import oracle.olapi.metadata.mtm.MtmDataType;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmExpression;
import oracle.olapi.metadata.mtm.MtmFirstLastAggregationStep;
import oracle.olapi.metadata.mtm.MtmInvalidMetadataException;
import oracle.olapi.metadata.mtm.MtmNoAggregationStep;
import oracle.olapi.metadata.mtm.MtmObjectFactory;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmSimpleAggregationStep;
import oracle.olapi.metadata.mtm.MtmSolvedCube;
import oracle.olapi.metadata.mtm.MtmSolvedETCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmSolvedGroupingSetCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmSolvedRollupCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmUnsolvedCube;
import oracle.olapi.metadata.mtm.MtmUnsolvedCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmWeightedAverageAggregationStep;

public class MtmCustomObjectFactory {
    private MdmMetadataProvider _metadataProvider = null;

    public MtmCustomObjectFactory(MdmMetadataProvider mdmMetadataProvider) {
        this._metadataProvider = mdmMetadataProvider;
    }

    public MtmDataType getDefaultMtmDataType(MetadataObject metadataObject) {
        return this._metadataProvider.getMtmDataTypeConverter().getMtmDataType((FundamentalMetadataObject)metadataObject);
    }

    public void setDefaultMtmDataType(MetadataObject metadataObject, MtmDataType mtmDataType) {
        this._metadataProvider.getMtmDataTypeConverter().setMtmDataType((FundamentalMetadataObject)metadataObject, mtmDataType);
    }

    public MtmCustomExpression createCustomExpression(String string, MetadataObject metadataObject) {
        if (null == metadataObject) {
            return this.createCustomExpression(string, (MtmDataType)null);
        }
        if (!(metadataObject instanceof FundamentalMetadataObject)) {
            throw new MtmInvalidMetadataException();
        }
        MtmDataType mtmDataType = this._metadataProvider.getMtmDataTypeConverter().getMtmDataType((FundamentalMetadataObject)metadataObject);
        if (null != mtmDataType) {
            return this.createCustomExpression(string, mtmDataType);
        }
        throw new MtmInvalidMetadataException();
    }

    public MtmCustomExpression createCustomExpression(String string, MtmDataType mtmDataType) {
        MtmCustomExpression mtmCustomExpression = this.getMtmObjectFactory().createCustomExpression();
        mtmCustomExpression.setExpressionString(string);
        if (mtmDataType != null) {
            mtmCustomExpression.setDataType(mtmDataType);
        }
        return mtmCustomExpression;
    }

    public MtmUnsolvedCubeDimensionality createUnsolvedCubeDimensionality(MdmHierarchy mdmHierarchy, MtmExpression mtmExpression, MtmExpression mtmExpression2) {
        MtmUnsolvedCubeDimensionality mtmUnsolvedCubeDimensionality = this.getMtmObjectFactory().createUnsolvedCubeDimensionality();
        mtmUnsolvedCubeDimensionality.setDimensionExpression(mtmExpression2);
        mtmUnsolvedCubeDimensionality.setDimensionExpression(mtmExpression);
        mtmUnsolvedCubeDimensionality.setDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        return mtmUnsolvedCubeDimensionality;
    }

    public MtmSolvedETCubeDimensionality createSolvedETCubeDimensionality(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, MtmValueExpression mtmValueExpression2) {
        MtmSolvedETCubeDimensionality mtmSolvedETCubeDimensionality = this.getMtmObjectFactory().createSolvedETCubeDimensionality();
        mtmSolvedETCubeDimensionality.setLevelExpression(mtmValueExpression);
        mtmSolvedETCubeDimensionality.setValueExpression(mtmValueExpression2);
        mtmSolvedETCubeDimensionality.setDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        return mtmSolvedETCubeDimensionality;
    }

    public MtmSolvedRollupCubeDimensionality createSolvedRollupCubeDimensionality(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, MtmExpression[] mtmExpressionArray) {
        MtmSolvedRollupCubeDimensionality mtmSolvedRollupCubeDimensionality = this.getMtmObjectFactory().createSolvedRollupCubeDimensionality();
        mtmSolvedRollupCubeDimensionality.setGroupingIDExpression(mtmValueExpression);
        for (int i = 0; i < mtmExpressionArray.length; ++i) {
            mtmSolvedRollupCubeDimensionality.addLevelExpression(mtmExpressionArray[i]);
        }
        mtmSolvedRollupCubeDimensionality.setDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        return mtmSolvedRollupCubeDimensionality;
    }

    public MtmSolvedGroupingSetCubeDimensionality createSolvedGroupingSetCubeDimensionality(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, MtmExpression[] mtmExpressionArray) {
        MtmSolvedGroupingSetCubeDimensionality mtmSolvedGroupingSetCubeDimensionality = this.getMtmObjectFactory().createSolvedGroupingSetCubeDimensionality();
        mtmSolvedGroupingSetCubeDimensionality.setGroupingIDExpression(mtmValueExpression);
        for (int i = 0; i < mtmExpressionArray.length; ++i) {
            mtmSolvedGroupingSetCubeDimensionality.addLevelExpression(mtmExpressionArray[i]);
        }
        mtmSolvedGroupingSetCubeDimensionality.setDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        return mtmSolvedGroupingSetCubeDimensionality;
    }

    public MtmAggregationStep createSimpleAggregationStep(MdmHierarchy mdmHierarchy, String string, MtmValueExpression mtmValueExpression) {
        Object object;
        if (mtmValueExpression == null) {
            object = this.getMdmMetadataProvider().getDataProvider().getFundamentalMetadataProvider();
            mtmValueExpression = this.createCustomExpression("1", ((FundamentalMetadataProvider)object).getShortDataType());
        }
        object = this.getMtmObjectFactory().createSimpleAggregationStep();
        ((MtmAggregationStep)object).addDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        ((MtmSimpleAggregationStep)object).setFunction(string);
        ((MtmSimpleAggregationStep)object).setWeight(mtmValueExpression);
        return object;
    }

    MtmAggregationStep createFirstLastAggregationStep(MdmHierarchy mdmHierarchy, int n, boolean bl) {
        MtmFirstLastAggregationStep mtmFirstLastAggregationStep = this.getMtmObjectFactory().createFirstLastAggregationStep();
        mtmFirstLastAggregationStep.addDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        mtmFirstLastAggregationStep.setAggregationType(n);
        mtmFirstLastAggregationStep.setIsHierarchical(bl);
        return mtmFirstLastAggregationStep;
    }

    public MtmAggregationStep createFirstAggregationStep(MdmHierarchy mdmHierarchy, boolean bl) {
        return this.createFirstLastAggregationStep(mdmHierarchy, 0, bl);
    }

    public MtmAggregationStep createLastAggregationStep(MdmHierarchy mdmHierarchy, boolean bl) {
        return this.createFirstLastAggregationStep(mdmHierarchy, 1, bl);
    }

    public MtmAggregationStep createWeightedAverageAggregationStep(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, boolean bl) {
        MtmWeightedAverageAggregationStep mtmWeightedAverageAggregationStep = this.getMtmObjectFactory().createWeightedAverageAggregationStep();
        mtmWeightedAverageAggregationStep.addDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        mtmWeightedAverageAggregationStep.setWeight(mtmValueExpression);
        mtmWeightedAverageAggregationStep.setIsHierarchical(bl);
        return mtmWeightedAverageAggregationStep;
    }

    public MtmAggregationStep createNoAggregationStep(MdmHierarchy mdmHierarchy) {
        MtmNoAggregationStep mtmNoAggregationStep = this.getMtmObjectFactory().createNoAggregationStep();
        mtmNoAggregationStep.addDimensionMap((MtmDimensionMap)mdmHierarchy.getSourceMap());
        return mtmNoAggregationStep;
    }

    public MtmAggregationStep createSumAggregationStep(MdmHierarchy mdmHierarchy) {
        return this.createSimpleAggregationStep(mdmHierarchy, "SUM", null);
    }

    public MtmAggregationStep createDefaultAggregationStep(MdmHierarchy mdmHierarchy) {
        return this.createSumAggregationStep(mdmHierarchy);
    }

    public MtmUnsolvedCube createUnsolvedCube(MtmPartitionedCube mtmPartitionedCube, MtmTabularSource mtmTabularSource, String string) {
        MtmUnsolvedCube mtmUnsolvedCube = this.getMtmObjectFactory().createUnsolvedCube();
        mtmUnsolvedCube.setTable(mtmTabularSource);
        mtmUnsolvedCube.setAggregationForm(string);
        mtmPartitionedCube.addBaseCube(mtmUnsolvedCube);
        MtmAggregationSpecification mtmAggregationSpecification = this.getMtmObjectFactory().createAggregationSpecification();
        mtmUnsolvedCube.setSolveSpecification(mtmAggregationSpecification);
        return mtmUnsolvedCube;
    }

    public MtmSolvedCube createSolvedCube(MtmPartitionedCube mtmPartitionedCube, MtmTabularSource mtmTabularSource) {
        MtmSolvedCube mtmSolvedCube = this.getMtmObjectFactory().createSolvedCube();
        mtmSolvedCube.setTable(mtmTabularSource);
        mtmPartitionedCube.addBaseCube(mtmSolvedCube);
        return mtmSolvedCube;
    }

    public MtmPartitionedCube createPartitionedCube(String string) {
        MtmPartitionedCube mtmPartitionedCube = this.getMtmObjectFactory().createPartitionedCube();
        mtmPartitionedCube.setCubeNAME(string);
        mtmPartitionedCube.setName(string);
        return mtmPartitionedCube;
    }

    private MdmMetadataProvider getMdmMetadataProvider() {
        return this._metadataProvider;
    }

    private MtmObjectFactory getMtmObjectFactory() {
        return this._metadataProvider.getMtmObjectFactory();
    }
}

