/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataAssociationModificationStep;
import oracle.olapi.metadata.MetadataModificationException;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;

final class MetadataAssociationProperty
extends MetadataProperty {
    private Object m_Object = null;
    private List m_Modifications = null;
    private boolean m_IsFixedValue = false;

    MetadataAssociationProperty(XMLTag xMLTag, Object object) {
        super(xMLTag);
        this.setObject(object, true, null);
        this.setIsFixedValue(false);
    }

    private MetadataAssociationProperty(MetadataAssociationProperty metadataAssociationProperty, boolean bl) {
        super(metadataAssociationProperty);
        this.setObjectDirect(metadataAssociationProperty.getObject());
        if (bl && metadataAssociationProperty.hasModifications()) {
            this.getModifications().addAll(metadataAssociationProperty.getModifications());
        }
        this.setIsFixedValue(metadataAssociationProperty.isFixedValue());
    }

    @Override
    boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        if (this.isMetadataObject()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
            return metadataToXMLConverter.addMetadataObject(metadataObjectHolder, list);
        }
        return false;
    }

    @Override
    void gatherMetadataObjects(List<MetadataObjectHolder> list) {
        if (this.isMetadataObject()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
            list.add(metadataObjectHolder);
        }
    }

    @Override
    void gatherReferencedSources(List list) {
        if (this.isSourceObject()) {
            list.add(this.getObject());
        }
    }

    @Override
    void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (this.isMetadataObject()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
            if (null == metadataObjectHolder || this.getPropertyTag().isXMLContainedObject() && !this.isXMLWriteableContainedObject(metadataToXMLConverter, baseMetadataObject, metadataObjectHolder.getMetadataObject())) {
                return;
            }
            if (metadataToXMLConverter.getXMLFormat().is10gMode() || 2 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendAttribute(this.getPropertyTag(), metadataObjectHolder);
            } else if (3 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendIDAttribute(this.getPropertyTag(), metadataObjectHolder, baseMetadataObject);
            } else if (7 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendChoiceElement(this.getPropertyTag(), metadataObjectHolder);
            } else if (6 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendElement(this.getPropertyTag(), metadataObjectHolder);
            } else if (this.getPropertyTag().isXMLObjectReference()) {
                metadataToXMLConverter.appendIDRefElement(this.getPropertyTag(), metadataObjectHolder, baseMetadataObject);
            }
        } else if (this.isSourceObject()) {
            Source source = (Source)this.getObject();
            metadataToXMLConverter.appendAttribute(this.getPropertyTag(), source);
        } else if (this.isSyntaxObject()) {
            SyntaxObject syntaxObject = (SyntaxObject)this.getObject();
            if (null != syntaxObject) {
                metadataToXMLConverter.appendSyntax(this.getPropertyTag(), syntaxObject, baseMetadataObject);
            }
        } else if (this.isSQLDataType()) {
            SQLDataType sQLDataType = (SQLDataType)this.getObject();
            if (null != sQLDataType) {
                metadataToXMLConverter.appendSQLDataType(this.getPropertyTag(), sQLDataType, baseMetadataObject);
            }
        } else {
            String string = (String)this.getObject();
            metadataToXMLConverter.appendAttribute(this.getPropertyTag(), string, baseMetadataObject);
        }
    }

    @Override
    void appendIncrementalXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        MetadataObjectHolder metadataObjectHolder;
        if (3 == this.getXMLFormatType()) {
            this.appendXMLString(metadataToXMLConverter, baseMetadataObject);
        } else if (this.isModification(metadataToXMLConverter, baseMetadataObject)) {
            if (null == this.getObject()) {
                if (2 == this.getXMLFormatType() || metadataToXMLConverter.isInAttributes()) {
                    metadataToXMLConverter.appendAttribute(this.getPropertyTag(), "", baseMetadataObject);
                } else {
                    metadataToXMLConverter.beginElement(this.getPropertyTag());
                    metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.ACTION, "REMOVE", baseMetadataObject);
                    metadataToXMLConverter.endElement();
                }
            } else {
                this.appendXMLString(metadataToXMLConverter, baseMetadataObject);
            }
        } else if (null != this.getObject() && this.isMetadataObject() && this.getPropertyTag().isXMLContainedObject() && this.isXMLWriteableContainedObject(metadataToXMLConverter, baseMetadataObject, (metadataObjectHolder = (MetadataObjectHolder)this.getObject()).getMetadataObject())) {
            this.appendXMLString(metadataToXMLConverter, baseMetadataObject);
        }
    }

    Object getObjectValue(BaseMetadataProvider baseMetadataProvider) {
        if (this.isMetadataObject() && null != this.getObject()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
            return baseMetadataProvider.fetchMetadataObject(metadataObjectHolder);
        }
        return this.getObject();
    }

    MetadataObjectHolder getObjectHolder() {
        if (this.isMetadataObject()) {
            return (MetadataObjectHolder)this.getObject();
        }
        return null;
    }

    Object getObject() {
        return this.m_Object;
    }

    @Override
    boolean isAttribute(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (3 == this.getXMLFormatType() || metadataToXMLConverter.getXMLFormat().is10gMode()) {
            return true;
        }
        if (this.isSyntaxObject() && metadataToXMLConverter.needsCDataFormatting((SyntaxObject)this.getObject())) {
            return false;
        }
        if (this.isMetadataObject() && this.getPropertyTag().isXMLObjectReference()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
            if (metadataToXMLConverter.canWriteObjectRefAsAttribute(this.getPropertyTag(), metadataObjectHolder, baseMetadataObject)) {
                return true;
            }
        }
        return 2 == this.getXMLFormatType();
    }

    void setObject(Object object, BaseMetadataObject baseMetadataObject) {
        this.setObject(object, false, baseMetadataObject);
    }

    void setObject(Object object, boolean bl, BaseMetadataObject baseMetadataObject) {
        if (this.getObject() == object) {
            return;
        }
        if (this.isFixedValue() && !bl) {
            throw new MetadataModificationException("UnmodifiableAttribute", this.getPropertyTag().getDefaultName(), baseMetadataObject.getID());
        }
        MetadataAssociationModificationStep metadataAssociationModificationStep = MetadataAssociationModificationStep.newSetAction(this.getObject(), object);
        metadataAssociationModificationStep.applyModification(this);
        this.getModifications().add(metadataAssociationModificationStep);
    }

    void setObjectDirect(Object object) {
        this.m_Object = object;
    }

    @Override
    MetadataProperty cloneProperty(boolean bl) {
        return new MetadataAssociationProperty(this, bl);
    }

    @Override
    void updateFromChild(MetadataProperty metadataProperty) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)metadataProperty;
        this.setObjectDirect(metadataAssociationProperty.getObject());
        if (metadataAssociationProperty.hasModifications()) {
            this.getModifications().addAll(metadataAssociationProperty.getModifications());
        }
    }

    @Override
    void updateFromParent(MetadataProperty metadataProperty) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)metadataProperty;
        this.setObjectDirect(metadataAssociationProperty.getObject());
        if (!this.hasModifications()) {
            return;
        }
        for (MetadataAssociationModificationStep metadataAssociationModificationStep : this.getModifications()) {
            metadataAssociationModificationStep.applyModification(this);
        }
    }

    boolean isMetadataObject() {
        return this.getDataType() == 0;
    }

    boolean isSourceObject() {
        return this.getDataType() == 1;
    }

    boolean isSyntaxObject() {
        return this.getPropertyTag().isSyntaxDataType();
    }

    boolean isSQLDataType() {
        return this.getDataType() == 7;
    }

    private int getDataType() {
        return this.getPropertyTag().getDataType();
    }

    private boolean isFixedValue() {
        return this.m_IsFixedValue;
    }

    void setIsFixedValue(boolean bl) {
        this.m_IsFixedValue = bl;
    }

    @Override
    boolean isModification(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return this.hasModifications() && super.isModification(metadataToXMLConverter, baseMetadataObject);
    }

    @Override
    final boolean isServerSendable(MetadataProperty metadataProperty) {
        boolean bl = true;
        if (!this.hasModifications()) {
            bl = false;
        }
        return bl;
    }

    private List getModifications() {
        if (null == this.m_Modifications) {
            this.m_Modifications = new ArrayList();
        }
        return this.m_Modifications;
    }

    private boolean hasModifications() {
        return null != this.m_Modifications;
    }

    @Override
    void getRemovedElements(Set set) {
        if (!this.hasModifications() || this.getModifications().size() == 0) {
            return;
        }
        for (MetadataAssociationModificationStep metadataAssociationModificationStep : this.getModifications()) {
            if (metadataAssociationModificationStep.getOldObject() == null || metadataAssociationModificationStep.getOldObject() == this.getObject()) continue;
            Object object = metadataAssociationModificationStep.getOldObject();
            if (object instanceof MetadataObjectHolder) {
                object = ((MetadataObjectHolder)object).getMetadataObject();
                if (this.getObject() instanceof MetadataObjectHolder && ((MetadataObjectHolder)this.getObject()).getMetadataObject() == object) continue;
            }
            if (!(object instanceof BaseMetadataObject)) continue;
            set.add(object);
        }
    }

    @Override
    void getAssociatedObjects(List list) {
        if (this.getObject() != null) {
            list.add(this.getObject());
        }
    }

    @Override
    void updatePersistentState(short s) {
        MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
        if (null != metadataObjectHolder && metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) {
            ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).updatePersistentState(s);
        }
    }

    @Override
    void revertPersistentState() {
        MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)this.getObject();
        if (null != metadataObjectHolder && metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) {
            ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).revertPersistentState();
        }
    }

    @Override
    boolean isLocal() {
        return this.hasModifications();
    }
}

