/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelAssignmentManagerState;
import oracle.olapi.data.source.ModelSolutionDefinition;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;

public final class ModelAssignmentManager {
    private Model m_Model = null;
    private DataProvider m_DataProvider = null;
    private MetadataStateManager m_StateManager = null;
    private static String ASSIGNMENTS = "Assignments";
    private static String ASSIGNMENT = "Assignment";
    private static String PRECEDENCE = "Precedence";
    private static String ASSIGNED_ID = "AssignedId";
    private static String LITERAL_QUALIFICATION = "LiteralQualifiction";
    private static String QUALIFIED_ID = "QualifiedId";
    private static String LITERAL_TYPE = "LiteralType";
    private static String LITERAL_VALUE = "LiteralValue";

    public ModelAssignmentManager(Model model, DataProvider dataProvider) {
        this.m_Model = model;
        this.m_DataProvider = dataProvider;
        this.m_StateManager = null;
    }

    private void ensureMetadataStateManager() {
        if (null == this.m_StateManager) {
            Transaction transaction = this.getCurrentSystemTransaction();
            ModelAssignmentManagerState modelAssignmentManagerState = new ModelAssignmentManagerState();
            this.m_StateManager = new MetadataStateManager(modelAssignmentManagerState, transaction);
        }
    }

    public void copyTo(ModelAssignmentManager modelAssignmentManager) {
        ModelAssignmentManagerState modelAssignmentManagerState = this.getCurrentStateForWrite();
        modelAssignmentManager.setCurrentState(modelAssignmentManagerState);
    }

    public final Source createSolvedSource() {
        Source source = this.getModel().getType().nullSource();
        for (Source source2 : this.getModel().getOutputs()) {
            source = source.join(source2.nullSource());
        }
        return this.createSolvedSource(source);
    }

    public final Source createSolvedSource(Source source) {
        Transaction transaction = source.getDefinition().getIncrementalTransaction();
        ModelSolutionDefinition modelSolutionDefinition = new ModelSolutionDefinition(this.getModel(), source.getDefinition(), transaction);
        return modelSolutionDefinition.findOrCreateSource(transaction);
    }

    public final DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public MetadataStateManager getMetadataStateManager() {
        return this.m_StateManager;
    }

    private Transaction getIncrementalTransaction() {
        return this.getDataProvider().getBaseTransactionProvider().getIncrementalTransaction();
    }

    private Transaction getCurrentSystemTransaction() {
        return this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
    }

    private ModelAssignmentManagerState getCurrentStateForRead() {
        Transaction transaction = this.getCurrentSystemTransaction();
        return (ModelAssignmentManagerState)this.getMetadataStateManager().getCurrentStateForRead(transaction);
    }

    private ModelAssignmentManagerState getCurrentStateForWrite() {
        this.ensureMetadataStateManager();
        Transaction transaction = this.getIncrementalTransaction();
        return (ModelAssignmentManagerState)this.getMetadataStateManager().getCurrentStateForWrite(transaction);
    }

    private void setCurrentState(ModelAssignmentManagerState modelAssignmentManagerState) {
        Transaction transaction = this.getIncrementalTransaction();
        this.getMetadataStateManager().setCurrentState(modelAssignmentManagerState, transaction);
    }

    public final boolean isModified(Transaction transaction) {
        if (null == this.getMetadataStateManager()) {
            return false;
        }
        return this.getMetadataStateManager().isModified(transaction);
    }

    public final Transaction getActiveTransaction() {
        if (null == this.getMetadataStateManager()) {
            return null;
        }
        return this.getMetadataStateManager().getActiveTransaction();
    }

    public List getAssignments() {
        return this.getAssignments(this.getCurrentSystemTransaction());
    }

    public List getAssignments(Transaction transaction) {
        if (null == this.getMetadataStateManager()) {
            return new ArrayList();
        }
        return ((ModelAssignmentManagerState)this.getMetadataStateManager().getCurrentStateForRead(transaction)).getAssignments();
    }

    void addAssignment(Assignment assignment) {
        Object object;
        boolean bl;
        boolean bl2 = bl = assignment.getQualifications().size() <= this.getModel().getInputs().size();
        if (bl) {
            int n;
            object = new boolean[this.getModel().getInputs().size()];
            for (n = 0; n < this.getModel().getInputs().size(); ++n) {
                object[n] = false;
            }
            for (Qualification qualification : assignment.getQualifications()) {
                for (n = 0; n < this.getModel().getInputs().size(); ++n) {
                    Source source = (Source)this.getModel().getInputs().get(n);
                    if (source != qualification.getQualifiedSource()) continue;
                    if (object[n] != false) {
                        bl = false;
                        break;
                    }
                    object[n] = true;
                    break;
                }
                if (object[n] == false) {
                    bl = false;
                }
                if (bl) continue;
                break;
            }
        }
        if (!bl) {
            throw new UnsupportedOperationException("Assignment Qualifications must have a Model input as their QualifiedSource, and a Model input may only be qualified by at most one Qualification.");
        }
        object = this.getCurrentStateForWrite();
        Assignment assignment2 = ((ModelAssignmentManagerState)object).getAssignment(assignment.getQualifications());
        if (null != assignment2 && assignment2.getPrecedence() == assignment.getPrecedence()) {
            ((ModelAssignmentManagerState)object).removeAssignment(assignment2);
        }
        ((ModelAssignmentManagerState)object).addAssignment(assignment);
        this.setCurrentState((ModelAssignmentManagerState)object);
    }

    public void assign(Qualification[] qualificationArray, Source source) {
        this.assign(qualificationArray, source, this.getDefaultPrecedence());
    }

    public void assign(Qualification[] qualificationArray, Source source, int n) {
        Assignment assignment = new Assignment(this.getModel(), qualificationArray, source, n);
        this.addAssignment(assignment);
    }

    public void assign(String string, Source source) {
        this.assign(string, source, this.getDefaultPrecedence());
    }

    public void assign(String string, Source source, int n) {
        this.assign(new String[]{string}, source, n);
    }

    public void assign(String[] stringArray, Source source) {
        this.assign(stringArray, source, this.getDefaultPrecedence());
    }

    public void assign(String[] stringArray, Source source, int n) {
        if (stringArray == null || stringArray.length != this.getModel().getInputs().size()) {
            throw new UnsupportedOperationException();
        }
        Qualification[] qualificationArray = new Qualification[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Source source2 = (Source)this.getModel().getInputs().get(i);
            LiteralQualification literalQualification = new LiteralQualification(source2, stringArray[i]);
            qualificationArray[i] = literalQualification;
        }
        this.assign(qualificationArray, source, n);
    }

    public void unassign(Assignment assignment) {
        ModelAssignmentManagerState modelAssignmentManagerState = this.getCurrentStateForWrite();
        modelAssignmentManagerState.removeAssignment(assignment);
        this.setCurrentState(modelAssignmentManagerState);
    }

    public final Model getModel() {
        return this.m_Model;
    }

    public int getDefaultPrecedence() {
        if (null == this.getMetadataStateManager()) {
            return 10;
        }
        return this.getCurrentStateForRead().getDefaultPrecedence();
    }

    public void setDefaultPrecedence(int n) {
        ModelAssignmentManagerState modelAssignmentManagerState = this.getCurrentStateForWrite();
        modelAssignmentManagerState.setDefaultPrecedence(n);
        this.setCurrentState(modelAssignmentManagerState);
    }

    public void gatherReferencedSources(List list) {
        this.gatherReferencedSources(list, this.getCurrentSystemTransaction());
    }

    public void gatherReferencedSources(List list, Transaction transaction) {
        for (Assignment assignment : this.getAssignments(transaction)) {
            list.add(assignment.getAssignedSource());
            for (Qualification qualification : assignment.getQualifications()) {
                list.add(qualification.getQualifiedSource());
            }
        }
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, this.getCurrentSystemTransaction());
    }

    public void writeXML(XMLWriter xMLWriter, Transaction transaction) {
        xMLWriter.beginElement(ASSIGNMENTS);
        xMLWriter.closeTag();
        for (Assignment assignment : this.getAssignments(transaction)) {
            xMLWriter.beginElement(ASSIGNMENT);
            xMLWriter.appendAttribute(PRECEDENCE, Integer.toString(assignment.getPrecedence()));
            xMLWriter.appendAttribute(ASSIGNED_ID, assignment.getAssignedSource().getID());
            xMLWriter.closeTag();
            for (LiteralQualification literalQualification : assignment.getQualifications()) {
                xMLWriter.beginElement(LITERAL_QUALIFICATION);
                xMLWriter.appendAttribute(QUALIFIED_ID, literalQualification.getQualifiedSource().getID());
                this.writeLiteralXML(literalQualification.getLiteral(), xMLWriter);
                xMLWriter.endElement();
            }
            xMLWriter.endElement(ASSIGNMENT);
            xMLWriter.newLine();
        }
        xMLWriter.endElement(ASSIGNMENTS);
        xMLWriter.newLine();
    }

    private void writeLiteralXML(Object object, XMLWriter xMLWriter) {
        if (object instanceof String) {
            this.writeStringXML((String)object, xMLWriter);
        } else if (object instanceof Date) {
            this.writeDateXML((Date)object, xMLWriter);
        } else if (object instanceof Boolean) {
            this.writeBooleanXML((Boolean)object, xMLWriter);
        } else if (object instanceof Number) {
            this.writeNumberXML((Number)object, xMLWriter);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private final void writeStringXML(String string, XMLWriter xMLWriter) {
        xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getStringXMLTag());
        xMLWriter.appendAttribute(LITERAL_VALUE, string);
    }

    private final void writeDateXML(Date date, XMLWriter xMLWriter) {
        xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getDateXMLTag());
        long l = (int)(date.getTime() / 1000L);
        xMLWriter.appendAttribute(LITERAL_VALUE, Long.toString(l));
    }

    private final void writeBooleanXML(Boolean bl, XMLWriter xMLWriter) {
        xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getBooleanXMLTag());
        if (bl.booleanValue()) {
            xMLWriter.appendAttribute(LITERAL_VALUE, "True");
        } else {
            xMLWriter.appendAttribute(LITERAL_VALUE, "False");
        }
    }

    private final void writeNumberXML(Number number, XMLWriter xMLWriter) {
        if (number instanceof Short) {
            xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getShortXMLTag());
        } else if (number instanceof Integer) {
            xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getIntegerXMLTag());
        } else if (number instanceof Long) {
            xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getLongXMLTag());
        } else if (number instanceof Float) {
            xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getFloatXMLTag());
        } else if (number instanceof Double) {
            xMLWriter.appendAttribute(LITERAL_TYPE, this.getDataProvider().getDoubleXMLTag());
        } else {
            throw new UnsupportedOperationException();
        }
        xMLWriter.appendAttribute(LITERAL_VALUE, number.toString());
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getMetadataStateManager().getCurrentStateForRead(transaction);
    }
}

