/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.SpecificationScope;
import oracle.javatools.exports.specification.TypeExportSpecification;

public class ExportSpecification {
    private final Scope scope;
    private final String owner;
    private final String source;
    private final Set<String> consumers;
    private final ExportDomain domain;
    private final Map<PackageName, PackageExportSpecification> packages;
    private final PackageExportSpecification defaultPackageAccess;
    private final Set<ExportSpecification> specifications;
    private Map<PackageName, PackageExportSpecification> resolvedPackages;

    public ExportSpecification(Scope scope, CompatibilityAccess access, ExportDomain domain) {
        this(scope, null, null, null, domain, Collections.emptyMap(), access, null, null);
    }

    public ExportSpecification(Scope scope, String owner, String source, Set<String> consumers, ExportDomain domain, Map<PackageName, PackageExportSpecification> packages) {
        this(scope, owner, source, consumers, domain, packages, CompatibilityAccess.CONCEALED, null, null);
    }

    private ExportSpecification(Scope scope, String owner, String source, Set<String> consumers, ExportDomain domain, Map<PackageName, PackageExportSpecification> packages, CompatibilityAccess defaultPackageAccess, ExportSpecification left, ExportSpecification right) {
        if (consumers == null) {
            consumers = Collections.emptySet();
        }
        if (packages == null) {
            throw new NullPointerException("packages == null");
        }
        if (packages.isEmpty() && !"EmptyMap".equals(packages.getClass().getSimpleName())) {
            throw new IllegalStateException("live empty map");
        }
        if (left == null != (right == null)) {
            throw new IllegalStateException("left and right must both be null or not null");
        }
        this.scope = scope;
        this.owner = owner;
        this.source = source;
        this.consumers = consumers;
        this.domain = domain != null ? domain : new ExportDomain(new String[0]);
        this.packages = packages;
        if (defaultPackageAccess == CompatibilityAccess.EXPORTED) {
            this.defaultPackageAccess = PackageExportSpecification.EXPORTED_MEMBERS_EXPORTED;
        } else if (defaultPackageAccess == CompatibilityAccess.RESTRICTED) {
            this.defaultPackageAccess = PackageExportSpecification.RESTRICTED_MEMBERS_RESTRICTED;
        } else if (defaultPackageAccess == CompatibilityAccess.CONCEALED) {
            this.defaultPackageAccess = PackageExportSpecification.CONCEALED_MEMBERS_CONCEALED;
        } else if (defaultPackageAccess == null) {
            if (owner != null) {
                throw new IllegalStateException("null default access with unofficial owner");
            }
            if (!packages.isEmpty()) {
                throw new IllegalStateException("null default access with non-empty packages");
            }
            this.defaultPackageAccess = PackageExportSpecification.NULL_MEMBERS_NULL;
        } else {
            throw new IllegalStateException("unexpected defaultPackageAccess value " + defaultPackageAccess);
        }
        if (left != null) {
            this.specifications = new LinkedHashSet<ExportSpecification>(left.getSpecifications());
            this.specifications.addAll(right.getSpecifications());
        } else {
            this.specifications = Collections.emptySet();
        }
        this.resolvedPackages = Collections.emptyMap();
    }

    public static Merge<ExportSpecification> merge(Scope scope, ExportSpecification left, ExportSpecification right) {
        Merge<ExportSpecification> merge = new Merge<ExportSpecification>(left, right, "specification", new Object[0]);
        if (left == null || right == null) {
            if (!merge.completeIfEqual()) {
                if (left == null) {
                    merge.complete(right);
                } else {
                    merge.complete(left);
                }
            }
        } else {
            Map<PackageName, PackageExportSpecification> thatPackages;
            Map<PackageName, PackageExportSpecification> thisPackages;
            Merge<Map<PackageName, PackageExportSpecification>> mergedPackages;
            String thatOwner;
            ExportDomain thatDomain;
            ExportDomain thisDomain;
            Merge<ExportDomain> mergedDomain;
            Set<String> thatConsumers;
            Set<String> thisConsumers;
            Merge<Set<String>> mergedConsumers;
            String thatSource;
            if (merge.completeIfIdentical()) {
                return merge;
            }
            String thisSource = left.getSource();
            Merge<String> mergedSource = new Merge<String>(thisSource, thatSource = right.getSource(), "source", new Object[0]);
            if (!mergedSource.completeIfEqual()) {
                LinkedHashSet<String> sources = new LinkedHashSet<String>();
                if (thisSource != null) {
                    sources.addAll(Arrays.asList(thisSource.split(";")));
                }
                if (thatSource != null) {
                    sources.addAll(Arrays.asList(thatSource.split(";")));
                }
                mergedSource.complete(sources.stream().collect(Collectors.joining(";")));
            }
            if (!(mergedConsumers = new Merge<Set<String>>(thisConsumers = left.getConsumers(), thatConsumers = right.getConsumers(), "consumers", new Object[0])).completeIfEqual()) {
                LinkedHashSet<String> set = new LinkedHashSet<String>(thisConsumers);
                set.addAll(thatConsumers);
                mergedConsumers.completeWarning(set);
            }
            if (!(mergedDomain = new Merge<ExportDomain>(thisDomain = left.getDomain(), thatDomain = right.getDomain(), "domain", new Object[0])).completeIfEqual()) {
                mergedDomain.completeWarning(ExportDomain.union(thisDomain, thatDomain));
            }
            PackageExportSpecification thisDefaultPackageAccess = left.defaultPackageAccess;
            PackageExportSpecification thatDefaultPackageAccess = right.defaultPackageAccess;
            CompatibilityAccess thisAccess = thisDefaultPackageAccess.getDefaultMemberAccess();
            CompatibilityAccess thatAccess = thatDefaultPackageAccess.getDefaultMemberAccess();
            String thisOwner = left.getOwner();
            Merge<String> mergedOwner = new Merge<String>(thisOwner, thatOwner = right.getOwner(), "owner", new Object[0]);
            if (!mergedOwner.completeIfEqual()) {
                if (thisOwner == null) {
                    if (CompatibilityAccess.isExported(thisAccess)) {
                        mergedOwner.complete(null);
                    } else if (CompatibilityAccess.isConcealedOrNull(thisAccess)) {
                        mergedOwner.complete(thatOwner);
                    } else {
                        mergedOwner.completeWarning(thatOwner);
                    }
                } else if (thatOwner == null) {
                    if (CompatibilityAccess.isExported(thatAccess)) {
                        mergedOwner.complete(null);
                    } else if (CompatibilityAccess.isConcealedOrNull(thatAccess)) {
                        mergedOwner.complete(thisOwner);
                    } else {
                        mergedOwner.completeWarning(thisOwner);
                    }
                } else {
                    mergedOwner.completeError(thisOwner);
                }
            }
            Merge<PackageExportSpecification> mergedDefaultPackageAccess = new Merge<PackageExportSpecification>(thisDefaultPackageAccess, thatDefaultPackageAccess, "defaultPackageAccess", new Object[0]);
            PackageExportSpecification adjustedAccess = null;
            if (!mergedDefaultPackageAccess.completeIfEqual()) {
                mergedDefaultPackageAccess.completeWarning(CompatibilityAccess.isMoreExported(thisAccess, thatAccess) ? thisDefaultPackageAccess : thatDefaultPackageAccess);
                adjustedAccess = mergedDefaultPackageAccess.getValue();
            }
            if (!(mergedPackages = new Merge<Map<PackageName, PackageExportSpecification>>(thisPackages = left.packages, thatPackages = right.packages, "packages", new Object[0])).completeIfEqual()) {
                if (thisPackages.isEmpty() && CompatibilityAccess.isExported(thisAccess)) {
                    mergedPackages.complete(thisPackages);
                } else if (thatPackages.isEmpty() && CompatibilityAccess.isExported(thatAccess)) {
                    mergedPackages.complete(thatPackages);
                } else if (thisPackages.isEmpty() && CompatibilityAccess.isConcealedOrNull(thisAccess)) {
                    mergedPackages.complete(thatPackages);
                } else if (thatPackages.isEmpty() && CompatibilityAccess.isConcealedOrNull(thatAccess)) {
                    mergedPackages.complete(thisPackages);
                } else {
                    if (adjustedAccess != null) {
                        Map<PackageName, PackageExportSpecification> moreExportedPackages;
                        LinkedHashMap<PackageName, PackageExportSpecification> lessExportedPackages;
                        if (adjustedAccess == thisDefaultPackageAccess) {
                            lessExportedPackages = new LinkedHashMap<PackageName, PackageExportSpecification>(thatPackages);
                            thatPackages = lessExportedPackages;
                            moreExportedPackages = thisPackages;
                        } else {
                            lessExportedPackages = new LinkedHashMap<PackageName, PackageExportSpecification>(thisPackages);
                            thisPackages = lessExportedPackages;
                            moreExportedPackages = thatPackages;
                        }
                        Iterator i = lessExportedPackages.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            if (moreExportedPackages.containsKey(entry.getKey())) continue;
                            Merge<PackageExportSpecification> mergedPackage = ((PackageExportSpecification)entry.getValue()).merge(adjustedAccess);
                            if (adjustedAccess == mergedPackage.getValue()) {
                                i.remove();
                                continue;
                            }
                            entry.setValue(mergedPackage.getValue());
                            mergedPackages.addMerge(mergedPackage);
                        }
                    }
                    Map<PackageName, PackageExportSpecification> union = new LinkedHashMap<PackageName, PackageExportSpecification>(thisPackages);
                    for (Map.Entry<PackageName, PackageExportSpecification> entry : thatPackages.entrySet()) {
                        PackageExportSpecification thatPackage;
                        PackageName packageName = entry.getKey();
                        PackageExportSpecification thisPackage = union.putIfAbsent(packageName, thatPackage = entry.getValue());
                        if (thisPackage == null) continue;
                        Merge<PackageExportSpecification> mergedPackage = thisPackage.merge(thatPackage);
                        union.put(packageName, mergedPackage.getValue());
                        mergedPackages.addMerge(mergedPackage);
                    }
                    if (union.isEmpty()) {
                        union = Collections.emptyMap();
                    }
                    mergedPackages.complete(union);
                }
            }
            merge.addMerge(mergedPackages);
            merge.complete(new ExportSpecification(new SpecificationScope(scope, "merge"), mergedOwner.getValue(), mergedSource.getValue(), mergedConsumers.getValue(), mergedDomain.getValue(), mergedPackages.getValue(), mergedDefaultPackageAccess.getValue().getDefaultMemberAccess(), left, right));
        }
        return merge;
    }

    public boolean isControlling() {
        return this.defaultPackageAccess.getDefaultMemberAccess() != null;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getConsumers() {
        return this.consumers;
    }

    public ExportDomain getDomain() {
        return this.domain;
    }

    public PackageExportSpecification getPackage(PackageName name) {
        PackageExportSpecification specification = this.packages.get(name);
        if (specification != null) {
            return specification;
        }
        switch (this.resolvedPackages.size()) {
            case 0: {
                specification = this.domain.dominates(name) ? this.defaultPackageAccess : PackageExportSpecification.NULL_MEMBERS_NULL;
                this.resolvedPackages = Collections.singletonMap(name, specification);
                break;
            }
            case 1: {
                specification = this.resolvedPackages.get(name);
                if (specification != null) {
                    return specification;
                }
                this.resolvedPackages = new HashMap<PackageName, PackageExportSpecification>(this.resolvedPackages);
                specification = this.domain.dominates(name) ? this.defaultPackageAccess : PackageExportSpecification.NULL_MEMBERS_NULL;
                this.resolvedPackages.put(name, specification);
                break;
            }
            default: {
                specification = this.resolvedPackages.computeIfAbsent(name, v -> this.domain.dominates(name) ? this.defaultPackageAccess : PackageExportSpecification.NULL_MEMBERS_NULL);
            }
        }
        return specification;
    }

    public Set<ExportSpecification> getSpecifications() {
        return this.specifications.isEmpty() ? Collections.singleton(this) : this.specifications;
    }

    public CompatibilityAccess getMemberAccess(PackageName name) {
        TypeName typeName;
        TypeExportSpecification type;
        PackageExportSpecification packag = this.getPackage(name);
        if (packag.getTypeNames().isEmpty()) {
            return packag.getDefaultMemberAccess();
        }
        CompatibilityAccess access = null;
        Iterator<TypeName> iterator = packag.getTypeNames().iterator();
        while (!(!iterator.hasNext() || (type = packag.getType(typeName = iterator.next())) != null && CompatibilityAccess.isMoreExported(type.getAccess(), access) && (access = type.getAccess()).isExported())) {
        }
        return access;
    }

    public Set<PackageName> getPackageNames() {
        return this.packages.keySet();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExportSpecification)) {
            return false;
        }
        ExportSpecification that = (ExportSpecification)object;
        if (!Objects.equals(this.owner, that.owner)) {
            return false;
        }
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        if (this.defaultPackageAccess != that.defaultPackageAccess) {
            return false;
        }
        return this.packages.equals(that.packages);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scope);
        builder.append('#').append(this.packages.size());
        return builder.toString();
    }
}

