/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class ObjectCache<K, V> {
    public abstract V cache(K var1, V var2);

    public abstract V cache(K var1, Function<? super K, ? extends V> var2);

    public static <K, V> ObjectCache<K, V> synchronizedCache() {
        return new SynchronizedObjectCache();
    }

    public static ObjectCache nullCache() {
        return new NullObjectCache();
    }

    private static final class SynchronizedObjectCache<K, V>
    extends ObjectCache<K, V> {
        private Map<K, V> map = new HashMap();

        private SynchronizedObjectCache() {
        }

        @Override
        public final synchronized V cache(K key, V value) {
            V predecessor = this.map.putIfAbsent(key, value);
            return predecessor != null ? predecessor : value;
        }

        @Override
        public synchronized V cache(K key, Function<? super K, ? extends V> computeFunction) {
            return this.map.computeIfAbsent((K)key, computeFunction);
        }
    }

    private static final class NullObjectCache<K, V>
    extends ObjectCache<K, V> {
        private NullObjectCache() {
        }

        @Override
        public final V cache(K key, V value) {
            return value;
        }

        @Override
        public V cache(K key, Function<? super K, ? extends V> computeFunction) {
            return computeFunction.apply(key);
        }
    }
}

