/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;

public class AnnotationAccessPolicy
implements AccessPolicy {
    private final String owner;
    private final ExportDomain domain;

    AnnotationAccessPolicy(String owner, ExportDomain domain) {
        this.owner = owner;
        this.domain = domain;
    }

    public Object getId() {
        return "<annotation>";
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public ExportSpecification getExportSpecification() {
        return null;
    }

    @Override
    public AccessPolicy.PackageAccessPolicy getPolicyForPackage(Package packag, PackageName name, AccessPolicy.Annotations annotations) {
        AnnotationPackageAccessPolicy policy;
        String comment;
        block9: {
            block8: {
                CompatibilityAccess access = null;
                comment = null;
                if (annotations != null) {
                    access = annotations.getAccess();
                    comment = annotations.getComment();
                } else if (packag != null) {
                    access = packag.getDefaultMemberAccess();
                    comment = packag.getAccessComment();
                }
                if (!this.domain.dominates(name)) break block8;
                switch (CompatibilityAccess.mostExported(access, CompatibilityAccess.CONCEALED)) {
                    case EXPORTED: {
                        policy = AnnotationPackageAccessPolicy.EXPORTED_DEFAULT;
                        break block9;
                    }
                    case RESTRICTED: {
                        policy = AnnotationPackageAccessPolicy.RESTRICTED_DEFAULT;
                        break block9;
                    }
                    case CONCEALED: {
                        policy = AnnotationPackageAccessPolicy.CONCEALED_DEFAULT;
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("unexpected access: " + CompatibilityAccess.mostExported(access, CompatibilityAccess.CONCEALED));
                    }
                }
            }
            policy = AnnotationPackageAccessPolicy.NULL_DEFAULT;
        }
        return comment == null ? policy : new AnnotationPackageAccessPolicy(comment, policy.defaultMemberAccess);
    }

    public boolean equals(Object that) {
        return that.getClass() == this.getClass();
    }

    public String toString() {
        return "ANNOTATION";
    }

    static class AnnotationPackageAccessPolicy
    implements AccessPolicy.PackageAccessPolicy {
        private static final AnnotationPackageAccessPolicy EXPORTED_DEFAULT = new AnnotationPackageAccessPolicy(null, AnnotationTypeAccessPolicy.EXPORTED_DEFAULT);
        private static final AnnotationPackageAccessPolicy RESTRICTED_DEFAULT = new AnnotationPackageAccessPolicy(null, AnnotationTypeAccessPolicy.RESTRICTED_DEFAULT);
        private static final AnnotationPackageAccessPolicy CONCEALED_DEFAULT = new AnnotationPackageAccessPolicy(null, AnnotationTypeAccessPolicy.CONCEALED_DEFAULT);
        private static final AnnotationPackageAccessPolicy NULL_DEFAULT = new AnnotationPackageAccessPolicy(null, AnnotationTypeAccessPolicy.NULL_DEFAULT);
        private final String comment;
        private final AccessPolicy.TypeAccessPolicy defaultMemberAccess;

        AnnotationPackageAccessPolicy(String comment, AccessPolicy.TypeAccessPolicy defaultMemberAccess) {
            this.comment = comment;
            this.defaultMemberAccess = defaultMemberAccess;
        }

        @Override
        public CompatibilityAccess getDefaultMemberAccess() {
            return this.defaultMemberAccess.getAccess();
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public AnnotationTypeAccessPolicy getPolicyForType(Package packag, Type outerType, TypeName name, AccessPolicy.Annotations annotations, Log log) {
            assert (outerType == null || outerType.getReferenceAccess() != null) : "Type " + outerType + " not controlled";
            CompatibilityAccess access = annotations.getAccess();
            CompatibilityAccess extension = annotations.getExtension();
            String comment = annotations.getComment();
            if (annotations.isExportedExtensionExpandsRestricted()) {
                log.error("type-restricted-expands-extension", "annotation @Restricted on type %s prohibits extension=Access.EXPORTED: using Access.RESTRICTED", name).element(name);
            }
            if (access == null) {
                CompatibilityAccess compatibilityAccess = access = outerType == null ? this.defaultMemberAccess.getAccess() : outerType.getReferenceAccess();
            }
            if (extension != null || comment != null) {
                return new AnnotationTypeAccessPolicy(access, comment, extension);
            }
            if (access != null) {
                switch (access) {
                    case EXPORTED: {
                        return AnnotationTypeAccessPolicy.EXPORTED_DEFAULT;
                    }
                    case RESTRICTED: {
                        return AnnotationTypeAccessPolicy.RESTRICTED_DEFAULT;
                    }
                    case CONCEALED: {
                        return AnnotationTypeAccessPolicy.CONCEALED_DEFAULT;
                    }
                }
            }
            return AnnotationTypeAccessPolicy.NULL_DEFAULT;
        }
    }

    private static class AnnotationMemberAccessPolicy
    implements AccessPolicy.MemberAccessPolicy {
        private static final AnnotationMemberAccessPolicy EXPORTED_DEFAULT = new AnnotationMemberAccessPolicy(CompatibilityAccess.EXPORTED, null);
        private static final AnnotationMemberAccessPolicy RESTRICTED_DEFAULT = new AnnotationMemberAccessPolicy(CompatibilityAccess.RESTRICTED, null);
        private static final AnnotationMemberAccessPolicy CONCEALED_DEFAULT = new AnnotationMemberAccessPolicy(CompatibilityAccess.CONCEALED, null);
        private static final AnnotationMemberAccessPolicy NULL_DEFAULT = new AnnotationMemberAccessPolicy(null, null);
        private final CompatibilityAccess access;
        private final String comment;

        AnnotationMemberAccessPolicy(CompatibilityAccess access, String comment) {
            this.access = access;
            this.comment = comment;
        }

        @Override
        public CompatibilityAccess getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.comment;
        }
    }

    static class AnnotationTypeAccessPolicy
    implements AccessPolicy.TypeAccessPolicy {
        private static final AnnotationTypeAccessPolicy EXPORTED_DEFAULT = new AnnotationTypeAccessPolicy(CompatibilityAccess.EXPORTED, null, null);
        private static final AnnotationTypeAccessPolicy RESTRICTED_DEFAULT = new AnnotationTypeAccessPolicy(CompatibilityAccess.RESTRICTED, null, null);
        private static final AnnotationTypeAccessPolicy CONCEALED_DEFAULT = new AnnotationTypeAccessPolicy(CompatibilityAccess.CONCEALED, null, null);
        private static final AnnotationTypeAccessPolicy NULL_DEFAULT = new AnnotationTypeAccessPolicy(null, null, null);
        private final CompatibilityAccess access;
        private final String comment;
        private final CompatibilityAccess extension;

        AnnotationTypeAccessPolicy(CompatibilityAccess access, String comment, CompatibilityAccess extension) {
            this.access = access;
            this.comment = comment;
            this.extension = extension;
        }

        @Override
        public CompatibilityAccess getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public CompatibilityAccess getExtension() {
            return this.extension;
        }

        @Override
        public AnnotationMemberAccessPolicy getPolicyForMember(Type type, MemberName name, AccessPolicy.Annotations annotations) {
            CompatibilityAccess access = annotations.getAccess();
            String comment = annotations.getComment();
            if (access == null) {
                access = this.access;
            }
            if (comment != null) {
                return new AnnotationMemberAccessPolicy(access, comment);
            }
            if (access != null) {
                switch (access) {
                    case EXPORTED: {
                        return AnnotationMemberAccessPolicy.EXPORTED_DEFAULT;
                    }
                    case RESTRICTED: {
                        return AnnotationMemberAccessPolicy.RESTRICTED_DEFAULT;
                    }
                    case CONCEALED: {
                        return AnnotationMemberAccessPolicy.CONCEALED_DEFAULT;
                    }
                }
                throw new IllegalStateException("unexpected access: " + access);
            }
            return AnnotationMemberAccessPolicy.NULL_DEFAULT;
        }

        @Override
        public boolean isPolicyForMemberExplicit(Type type, MemberName name, AccessPolicy.Annotations annotations) {
            return annotations.getAccess() != null;
        }
    }
}

