/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.RepositoryDialog;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateRepositoryDialog
extends RepositoryDialog {
    public CreateRepositoryDialog() {
        super(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_CREATE_REPOSITORY_TEXT")), MigrationAddinArb.getString("MIGRATION_CREATE_REPOSITORY_BUTTON"), "Oracle");
        this.init();
        this.getGui().setVisible(true);
    }

    private void init() {
        this.setComboLabel(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_CREATE_REPOSITORY_TEXT")));
        this.setHelpId("f1_createrepository_html");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateRepositoryDialog.this.createRepository();
                CreateRepositoryDialog.this.getGui().setVisible(false);
            }
        };
        this.addokActionListener(actionListener);
        this.setupData();
    }

    protected void createRepository() {
        if (this.getRepositoryCombo().getSelectedItem() != null) {
            String string = (String)this.getRepositoryCombo().getSelectedItem();
            DBObject dBObject = null;
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)properties.getProperty("USERNAME"), null);
            dBObject = new DBObject(uRL);
            if (RepositoryManager.gotUserPermission(dBObject)) {
                if (!RepositoryManager.findOrCreateRepositoryTables(dBObject.getConnectionName())) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPO_INSTALL_FAILED"), null, null);
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPO_PERM_INFO"), null, null);
            }
        }
    }

    public void setupData() {
        Connections connections = Connections.getInstance();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = connections.getConnNames();
        Arrays.sort(objectArray);
        this.getRepositoryCombo().removeAllItems();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!connections.isOracle((String)object)) continue;
            arrayList.add(object);
            this.getRepositoryCombo().addItem(object);
        }
    }
}

