/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;

public class MaskUtil {
    private static Map<String, String[]> m_lastLoaded = null;

    public static synchronized Map<String, String[]> getLastLoaded() {
        return m_lastLoaded;
    }

    public static synchronized void setLastLoaded(Map<String, String[]> map) {
        m_lastLoaded = map;
    }

    public static synchronized String[] getMatchingRow(String string) {
        Map<String, String[]> map = MaskUtil.getLastLoaded();
        if (map == null) {
            map = MaskUtil.loadValues((PropertyStorage)Preferences.getPreferences());
            MaskUtil.setLastLoaded(map);
        }
        return map.get(string.toLowerCase());
    }

    public static Map<String, String[]> loadValues(TraversableContext traversableContext) {
        return MaskUtil.loadValues(traversableContext.getPropertyStorage());
    }

    public static Map<String, String[]> loadValues(PropertyStorage propertyStorage) {
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string != null) {
                    return string.compareToIgnoreCase(string2);
                }
                if (string2 != null) {
                    return string2.compareToIgnoreCase(string);
                }
                return 0;
            }
        });
        Object object = MigrationConfig.getInstance(propertyStorage).getGenericDateOfflineDateMask();
        if (object == null) {
            object = "";
        }
        int n = 0;
        try {
            object = (String)object + ":";
            while (n != ((String)object).length() - 1) {
                String[] stringArray = new String[]{"", "", ""};
                for (int i = 0; i < 3; ++i) {
                    int n2 = ((String)object).indexOf(58, n);
                    int n3 = Integer.parseInt(((String)object).substring(n, n2));
                    if (n3 == -1) {
                        stringArray[i] = null;
                        n = n2;
                        continue;
                    }
                    stringArray[i] = ((String)object).substring(n2 + 1, n2 + 1 + n3);
                    n = n2 + 1 + n3;
                }
                treeMap.put(stringArray[0], new String[]{stringArray[1], stringArray[2]});
                MaskUtil.setLastLoaded(null);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(MaskUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return treeMap;
    }

    public static void save(TableModel tableModel, TraversableContext traversableContext) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                String[] stringArray = new String[]{(String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1), (String)tableModel.getValueAt(i, 2)};
                if (stringArray[0] == null || stringArray[0].trim().length() == 0) continue;
                stringArray[0] = stringArray[0].toLowerCase();
                for (String string : stringArray) {
                    if (string != null) {
                        stringBuffer.append(string.length());
                        stringBuffer.append(":");
                        stringBuffer.append(string);
                        continue;
                    }
                    stringBuffer.append(-1);
                    stringBuffer.append(":");
                }
            }
            MigrationConfig.getInstance(traversableContext.getPropertyStorage()).setGenericDateOfflineDateMask(stringBuffer.toString());
            MaskUtil.setLastLoaded(null);
        }
        catch (Exception exception) {
            Logger.getLogger(MaskUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

