/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.SchemaFolderNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public class CatalogFolderNode
extends DefaultContainerCustomNode {
    protected static final Logger LOGGER = Logger.getLogger(CatalogFolderNode.class.getName());
    private MdConnection _mdConnection;
    private DBObjectId _parentId;
    private String _connType;
    private DBCatalogInstance _dbCatalogInstance;
    private String m_catalog;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public CatalogFolderNode(URL uRL, DBCatalogInstance dBCatalogInstance, MdConnection mdConnection, String string) {
        super(uRL);
        assert (dBCatalogInstance != null);
        assert (mdConnection != null);
        assert (string != null && !string.isEmpty());
        this._dbCatalogInstance = dBCatalogInstance;
        this._mdConnection = mdConnection;
        this._parentId = this._mdConnection.getKey();
        this._connType = string;
    }

    public String getShortLabel() {
        return this.m_catalog;
    }

    public Icon getIcon() {
        MigrationPlugin migrationPlugin;
        String string;
        Icon icon = OracleIcons.getIcon((String)"database.png");
        if (this._mdConnection != null && this._mdConnection.getType() == null && (string = this._mdConnection.getProperty("PLUGIN_ID")) != null && (migrationPlugin = MigrationAddin.findPlugin(string)) != null && migrationPlugin.getIcon() != null) {
            icon = migrationPlugin.getIcon();
        }
        return icon;
    }

    public MdConnection getMdConnection() {
        return this._mdConnection;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_catalog = DBURLFormatHelper.getCatalog((URL)uRL);
    }

    public DBCatalogInstance getCatalogInstance() {
        return this._dbCatalogInstance;
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                CatalogFolderNode catalogFolderNode = CatalogFolderNode.this;
                DBCatalogInstance dBCatalogInstance = catalogFolderNode.getCatalogInstance();
                DBObjectId dBObjectId = (DBObjectId)dBCatalogInstance.getProperty("CAPT_CONNECTION_OBJID");
                String string = DBURLFormatHelper.getConnectionName((URL)catalogFolderNode.getURL());
                String string2 = DBURLFormatHelper.getCatalog((URL)catalogFolderNode.getURL());
                DBSchemasInstance dBSchemasInstance = dBCatalogInstance.getSchemasInstance();
                try {
                    this.checkCanProceed();
                    String string3 = "sqldev.migration";
                    String string4 = (String)dBSchemasInstance.getProperty("ConnectionType");
                    for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                        DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                        dBSchemaInstance.setProperty("CAPT_CONNECTION_OBJID", (Object)dBObjectId);
                        dBSchemaInstance.setProperty("CONNECTION_OBJID", (Object)CatalogFolderNode.this._parentId);
                        if (dBObjectId != null) {
                            this.setCaptureId(dBSchemaInstance);
                            dBSchemaInstance.setProperty("IDCONSCHEMA", dBSchemaInstance.getProperty("IDSCHEMA"));
                        } else {
                            dBSchemaInstance.setProperty("IDCAPSCHEMA", dBSchemaInstance.getProperty("IDSCHEMA"));
                            this.setConvertId(dBSchemaInstance);
                        }
                        SchemaFolderNode schemaFolderNode = new SchemaFolderNode(DBURLFormatHelper.getURL((String)string3, (String)string, (String)string2, (String)((String)dBSchemaInstance.getProperty("SCHEMA")), null), dBSchemaInstance, string4);
                        arrayList.add((Element)schemaFolderNode);
                    }
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                catch (AbortException abortException) {
                    arrayList.clear();
                }
                catch (ExecutionException executionException) {
                    arrayList.clear();
                }
                return arrayList;
            }

            private void setConvertId(DBSchemaInstance dBSchemaInstance) {
                Object object = dBSchemaInstance.getProperty("IDSCHEMA");
                String string = " Derivative_Reason Is Null AND SRC_TYPE='MD_SCHEMAS' AND src_id = " + object;
                DerivativesIterator derivativesIterator = new DerivativesIterator(MigrationAddin.getPersistenceManager(), null, string);
                if (derivativesIterator.hasNext()) {
                    MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
                    DBObjectId dBObjectId = mdDerivative.getDerivedId();
                    dBSchemaInstance.setProperty("IDCONSCHEMA", (Object)dBObjectId.getId());
                }
            }

            private void setCaptureId(DBSchemaInstance dBSchemaInstance) {
                Object object = dBSchemaInstance.getProperty("IDSCHEMA");
                String string = " Derivative_Reason Is Null AND SRC_TYPE='MD_SCHEMAS' AND derived_id = " + object;
                Object object2 = dBSchemaInstance.getProperty("CONNECTION_OBJID");
                DBObjectId dBObjectId = (DBObjectId)object2;
                DerivativesIterator derivativesIterator = new DerivativesIterator(MigrationAddin.getPersistenceManager(), dBObjectId, string);
                if (derivativesIterator.hasNext()) {
                    MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
                    DBObjectId dBObjectId2 = mdDerivative.getSrcId();
                    dBSchemaInstance.setProperty("IDCAPSCHEMA", (Object)dBObjectId2.getId());
                }
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    @Override
    public String getObjectName() {
        return "MD_CATALOGS";
    }

    @Override
    public String getObjectType() {
        return "CATALOG";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDCONNECTION", this._parentId.toString());
            this._dict.put("CONNECTION_OBJID", this._parentId);
            if (this._connType.equals("MIGREPO")) {
                this._dict.put("IDCAPCONNECTION", this._parentId.toString());
            }
            for (String string : this.getCatalogInstance().getPropertyKeys()) {
                Object object;
                this._dict.put(string, this.getCatalogInstance().getProperty(string));
                if (!string.equals("CAPT_CONNECTION_OBJID") || !((object = this.getCatalogInstance().getProperty(string)) instanceof DBObjectId)) continue;
                DBObjectId dBObjectId = (DBObjectId)object;
                String string2 = new Long(dBObjectId.getId()).toString();
                this._dict.put("IDCAPCONNECTION", string2);
            }
        }
        return this._dict;
    }

    @Override
    public String getConnType() {
        return this._connType;
    }
}

