/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class UntranslatedViewsIterator
extends PersistableObjectIterator {
    private static final String QUERY_UNTRANSLATED_VIEWS = "SELECT ID FROM MD_VIEWS V WHERE V.SCHEMA_ID_FK = ? AND ID NOT IN (SELECT OBJECT_ID FROM MIGR_GENERATION_ORDER WHERE OBJECT_TYPE = 'MD_VIEWS' AND CONNECTION_ID_FK IN (SELECT CONNECTION_ID FROM MGV_ALL_SCHEMA WHERE SCHEMA_ID = ?))";
    private PreparedStatement m_myStatement;

    public UntranslatedViewsIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        super(MdView.class, persistenceManager);
        MigrationObjectFilter migrationObjectFilter;
        Object object = QUERY_UNTRANSLATED_VIEWS;
        String string = null;
        if (migrationObjectFilterList != null && (migrationObjectFilter = migrationObjectFilterList.getFilterForType("MD_VIEWS")) != null) {
            string = migrationObjectFilter.toConditionClause("VIEW_NAME", "ID");
        }
        if (string != null) {
            object = (String)object + " AND " + string;
        }
        try {
            this.m_myStatement = persistenceManager.getPreparedStatement((String)object);
            this.m_myStatement.setLong(1, dBObjectId.getId());
            this.m_myStatement.setLong(2, dBObjectId.getId());
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() {
        return this.m_myStatement;
    }
}

