/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.PeekableTable;
import oracle.ide.status.StatusBundle;
import oracle.ide.status.window.BasicTableCellRenderer;
import oracle.ide.status.window.StatusTableModel;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import oracle.javatools.ui.ExpansionTip;
import oracle.javatools.util.AccessibleUtils;
import oracle.javatools.util.Log;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.audit.swing.RowTableTransferHandler;

public class StatusTable
extends PeekableTable
implements TableColumnModelListener,
PopupMenuListener,
ActionListener {
    private ButtonRenderer buttonRenderer;
    private ButtonRenderer buttonHeaderRenderer;
    private Dimension buttonSize;
    private BasicTableCellRenderer messageRenderer;
    private BasicTableCellRenderer messageHeaderRenderer;
    private JPopupMenu popup;
    private boolean popupShowing;
    private int rolloverRow = -1;
    private Rectangle rolloverBounds;
    private long cancellationTime;
    private int cancellationRow = -1;
    private static final TransferHandler TRANSFER_HANDLER = new StatusTransferHandler();
    private static final Log LOG = new Log("status-table");

    public StatusTable(StatusTableModel model) {
        super((TableModel)model);
        this.setRowMargin(1);
        this.initializeRenderers();
        int height = Math.max(this.buttonSize.height, this.messageRenderer.getPreferredSize().height);
        this.setRowHeight(Math.max(this.getRowHeight(), height));
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setTransferHandler(TRANSFER_HANDLER);
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        ExpansionTip.attach((JTable)((Object)this), (int[])new int[]{1});
        ExpansionTip.attach((JTableHeader)header, (int[])new int[]{1});
    }

    private void initializeRenderers() {
        if (this.buttonRenderer == null) {
            OverlayIcon icon = new OverlayIcon(new Icon[]{Severity.ERROR.getIcon(), Severity.WARNING.getIcon(), Severity.INCOMPLETE.getIcon(), Severity.ADVISORY.getIcon(), Severity.UNKNOWN.getIcon()});
            this.buttonRenderer = new ButtonRenderer((Icon)icon);
            this.buttonSize = this.buttonRenderer.getPreferredSize();
            this.buttonHeaderRenderer = new ButtonRenderer((Icon)icon);
            this.messageRenderer = new MessageRenderer();
            this.messageHeaderRenderer = new MessageRenderer();
        }
    }

    public StatusTableModel getStatusModel() {
        return (StatusTableModel)this.getModel();
    }

    public void createDefaultColumnsFromModel() {
        this.initializeRenderers();
        StatusTableModel dm = this.getStatusModel();
        if (dm != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < dm.getColumnCount(); ++i) {
                TableColumn column = new TableColumn(i);
                switch (i) {
                    case 0: {
                        column.setCellRenderer(this.buttonRenderer);
                        column.setHeaderRenderer(this.buttonHeaderRenderer);
                        int buttonWidth = this.buttonSize.width;
                        column.setMinWidth(buttonWidth);
                        column.setPreferredWidth(buttonWidth);
                        column.setMaxWidth(buttonWidth);
                        break;
                    }
                    case 1: {
                        column.setCellRenderer(this.messageRenderer);
                        column.setHeaderRenderer(this.messageHeaderRenderer);
                    }
                }
                cm.addColumn(column);
            }
        }
    }

    public String getToolTipText(MouseEvent event) {
        return null;
    }

    public Peek createPeek(int row, int col) {
        URL url = this.getStatusModel().getFile();
        Issue issue = this.getStatusModel().getIssueAt(row);
        int pad = 4;
        int offset = issue.getOffset();
        Rectangle rect = this.getCellRect(row, col, true);
        Pair ret = PeekHelper.getPeekTextByOffset((URL)url, (int)offset, (int)pad);
        if (ret != null) {
            CodePeek peek = PeekHelper.createCodePeek((JComponent)((Object)this), (String)url.getFile(), (String)((String)ret.first), (String)URLFileSystem.getFileName((URL)url), (Rectangle)rect);
            PeekHelper.addHighlight((CodePeek)peek, (int)((Integer)ret.second < pad ? (Integer)ret.second : pad), (String)"caret-line-highlight");
            return peek;
        }
        return null;
    }

    public void processMouseEvent(MouseEvent e) {
        int row;
        Point point = e.getPoint();
        int id = e.getID();
        if (id == 501 && this.isButton1(e)) {
            LOG.trace("mouse pressed table {0}, showing {1}", (Object)point, (Object)this.popupShowing);
            if (this.popupShowing) {
                this.hidePopup();
            }
            this.mouseMoved(point);
            if (this.rolloverRow >= 0) {
                this.showPopup(this.rolloverRow, this.rolloverBounds, e);
                e.consume();
                return;
            }
        } else if (id == 502 || id == 500 && this.isButton1(e)) {
            LOG.trace("mouse released/clicked table {0}", (Object)point);
            this.mouseMoved(point);
            if (this.rolloverRow >= 0) {
                e.consume();
                return;
            }
        } else if (id == 504) {
            LOG.trace("mouse entered table {0}", (Object)point);
            this.enableEvents(32L);
            this.mouseMoved(point);
        } else if (id == 505) {
            LOG.trace("mouse exited table {0}", (Object)point);
            if (this.popupShowing) {
                this.hidePopup();
            }
            this.mouseMoved(point);
            this.disableEvents(32L);
        }
        if (e.isPopupTrigger() && (row = this.rowAtPoint(e.getPoint())) >= 0 && !this.isRowSelected(row)) {
            this.setRowSelectionInterval(row, row);
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        Point point = e.getPoint();
        LOG.trace("mouse moved table {0}", (Object)point);
        if (e.getID() == 503) {
            this.mouseMoved(point);
        }
        super.processMouseMotionEvent(e);
    }

    public void mouseMoved(Point location) {
        if (this.popupShowing) {
            return;
        }
        Rectangle bounds = new Rectangle();
        int row = this.rowAtPoint(location);
        if (row >= 0) {
            bounds = this.getCellRect(row, this.convertColumnIndexToView(0), false);
            if (location.x < bounds.x || location.x >= bounds.x + this.buttonSize.width) {
                row = -1;
            } else {
                bounds.setBounds(bounds);
            }
        }
        if (row >= 0) {
            LOG.trace("setting rollover row {0}, was {1}", row, this.rolloverRow);
            if (row != this.rolloverRow) {
                if (this.rolloverRow >= 0) {
                    this.rolloverRow = -1;
                    this.paintImmediately(this.rolloverBounds);
                }
                this.rolloverRow = row;
                this.rolloverBounds = bounds;
                this.paintImmediately(this.rolloverBounds);
            }
        } else if (this.rolloverRow >= 0) {
            LOG.trace("clearing rollover row {0}", this.rolloverRow);
            this.rolloverRow = -1;
            this.paintImmediately(this.rolloverBounds);
            this.rolloverBounds = null;
        }
    }

    public int rowAtPoint(Point location) {
        return location.y >= 0 ? super.rowAtPoint(location) : -1;
    }

    private boolean isButton1(MouseEvent event) {
        return event.getButton() == 1;
    }

    private void showPopup(int row, Rectangle bounds, EventObject event) {
        LOG.trace("popping up at {0}, visible {1}", row, (Object)this.popupShowing);
        Issue issue = ((StatusTableModel)this.getModel()).getIssueAt(row);
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.setLightWeightPopupEnabled(false);
            this.popup.addPopupMenuListener(this);
        } else {
            long eventTime = ((InputEvent)event).getWhen();
            LOG.trace("popup up, cancellation row {0}, cancellation time {1}, event time {2}", this.cancellationRow, (Object)this.cancellationTime, (Object)eventTime);
            if (event instanceof InputEvent && this.cancellationRow == row && this.cancellationTime >= eventTime - 20L) {
                LOG.trace("cancelling popup on row {0}", row);
                this.hidePopup();
                return;
            }
            this.popup.removeAll();
        }
        List actions = issue.getTransforms();
        if (actions.isEmpty()) {
            this.hidePopup();
            return;
        }
        for (Action action : actions) {
            this.popup.add(action).addActionListener(this);
        }
        assert (row == this.rolloverRow);
        this.popupShowing = true;
        this.popup.show((Component)((Object)this), bounds.x, bounds.y + bounds.height);
    }

    public void hidePopup() {
        this.popup.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.hidePopup();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        LOG.trace("popup will become visible");
        this.cancellationTime = 0L;
        this.cancellationRow = -1;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.cancellationTime = System.currentTimeMillis();
        this.cancellationRow = this.rolloverRow;
        LOG.trace("popup cancelled, rollover row {0}, time {1}", this.cancellationRow, (Object)this.cancellationTime);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        LOG.trace("popup will become invisible, rollover row {0}", this.rolloverRow);
        this.popupShowing = false;
        Point location = this.getMousePosition(true);
        if (location != null) {
            this.mouseMoved(location);
        } else if (this.rolloverRow >= 0) {
            this.rolloverRow = -1;
            this.paintImmediately(this.rolloverBounds);
            this.rolloverBounds = null;
        }
    }

    private class ButtonRenderer
    extends BasicTableCellRenderer {
        private static final int TW = 2;
        private Polygon triangle = new Polygon(new int[]{0, 2, 4}, new int[]{0, 2, 0}, 3);
        private boolean rollover;
        private Color rolloverColor;

        public ButtonRenderer(Icon icon) {
            this.setIcon(icon);
            this.setMargin(1);
            this.rolloverColor = UIManager.getColor("Separator.foreground");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            LOG.trace("preparing row {0} renderer, rollover row {1}", row, StatusTable.this.rolloverRow);
            String accessibleText = null;
            if (value != null) {
                this.setMargin(2, 1, 1, 1);
                Issue issue = (Issue)value;
                Icon icon = issue.getSeverity().getIcon();
                accessibleText = issue.getSeverity().getLabel();
                component = super.getTableCellRendererComponent(table, icon, false, hasFocus, row, column);
                boolean bl = this.rollover = row == StatusTable.this.rolloverRow && issue.hasTransforms();
                if (this.rollover) {
                    if (this.rolloverColor == null) {
                        this.rolloverColor = this.getForeground();
                    }
                    this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.rolloverColor));
                }
            } else {
                this.setMargin(2, 2, 1, 1);
                Icon icon = StatusTable.this.getStatusModel().getSummaryIcon();
                component = super.getTableCellRendererComponent(table, icon, false, hasFocus, row, column);
                JTableHeader header = table.getTableHeader();
                component.setForeground(header.getForeground());
                component.setBackground(header.getBackground());
                accessibleText = StatusBundle.get("status.window.accessible.status.header");
            }
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(accessibleText);
            }
            return component;
        }

        @Override
        protected void setValue(Object value) {
            this.setIcon((Icon)value);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.rollover) {
                LOG.trace("painting triangle {0}", (Object)g);
                Insets insets = this.getInsets();
                Insets margin = this.getMargin();
                int triangleX = this.getWidth() - insets.right - margin.right - 4 - 2;
                int triangleY = insets.top + margin.top + 2;
                Color oldColor = g.getColor();
                g.translate(triangleX, triangleY);
                g.setColor(this.rolloverColor);
                g.fillPolygon(this.triangle);
                g.drawPolygon(this.triangle);
                g.translate(-triangleX, -triangleY);
                g.setColor(oldColor);
            }
        }
    }

    private class MessageRenderer
    extends BasicTableCellRenderer {
        private MessageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            if (value != null) {
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            } else {
                value = AccessibleUtils.isAssistiveTechnologySet() ? StatusBundle.get("status.window.accessible.issue.text.header") : StatusTable.this.getStatusModel().getSummaryMessage();
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JTableHeader header = table.getTableHeader();
                component.setForeground(header.getForeground());
                component.setBackground(header.getBackground());
            }
            return component;
        }
    }

    private static class StatusTransferHandler
    extends RowTableTransferHandler {
        private StatusTransferHandler() {
        }

        protected Object getRowValue(JTable table, int row) {
            return table.getModel().getValueAt(row, 1);
        }
    }
}

