/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetCommonAncestorCommand
extends GitCommand {
    private final String[] revisions;
    private GitRevisionInfo revision;

    public GetCommonAncestorCommand(Repository repository, GitClassFactory gitFactory, String[] revisions, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try (RevWalk walk = null;){
            if (this.revisions.length == 0) {
                this.revision = null;
            } else {
                walk = new RevWalk(repository);
                ArrayList<RevCommit> commits = new ArrayList<RevCommit>(this.revisions.length);
                for (String rev : this.revisions) {
                    commits.add(Utils.findCommit(repository, rev, walk));
                }
                this.revision = this.getSingleBaseCommit(walk, commits);
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git merge-base ");
        for (String s : this.revisions) {
            sb.append(s).append(' ');
        }
        return sb.toString();
    }

    public GitRevisionInfo getRevision() {
        return this.revision;
    }

    private GitRevisionInfo getSingleBaseCommit(RevWalk walk, List<RevCommit> commits) throws IOException {
        while (commits.size() > 1) {
            walk.reset();
            for (RevCommit c : commits) {
                walk.markStart(walk.parseCommit((AnyObjectId)c));
            }
            walk.setRevFilter(RevFilter.MERGE_BASE);
            commits.clear();
            RevCommit commit = walk.next();
            while (commit != null) {
                commits.add(commit);
                commit = walk.next();
            }
        }
        if (commits.isEmpty()) {
            return null;
        }
        return this.getClassFactory().createRevisionInfo(commits.get(0), this.getRepository());
    }
}

