/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITNavPropertiesCommand
extends VCSCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.nav-properties";

    public GITNavPropertiesCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    protected boolean isAvailableImpl() {
        return this.hasProperties(this.getContext());
    }

    protected int doitImpl() throws Exception {
        GITTagNode node = this.getPropertiesNode(this.getContext());
        GitRevisionInfo info = this.getCommitRevisionInfo(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()), node.getTagInfo().getTaggedObjectId());
        GITPropertiesPanel panel = new GITPropertiesPanel(node.getTagInfo(), info);
        JEWTDialog dialog = this.createDialog(panel);
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    protected JEWTDialog createDialog(JPanel panel) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)this.createPropertiesTitle());
        int buttonMask = 1;
        dialog.setButtonMask(buttonMask);
        dialog.setResizable(true);
        dialog.setMinimumSize(350, 300);
        return dialog;
    }

    private boolean hasProperties(Context context) {
        Node node = context.getNode();
        return node instanceof GITTagNode;
    }

    private GITTagNode getPropertiesNode(Context context) {
        Node node = context.getNode();
        if (node instanceof GITTagNode) {
            return (GITTagNode)node;
        }
        return null;
    }

    private String createPropertiesTitle() {
        return Resource.get("PROPERTIES_TITLE");
    }

    private GitRevisionInfo getCommitRevisionInfo(URL rootUrl, String revisionId) throws GITProcessException {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            client = GITClientAdaptor.getClient(rootUrl);
            GitRevisionInfo info = client.log(revisionId, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITNavPropertiesCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.get("ERROR_COMMIT_TAG_DETAILS"), monitor.getError());
            }
            GitRevisionInfo gitRevisionInfo = info;
            return gitRevisionInfo;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITNavPropertiesCommand.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.get("ERROR_COMMIT_TAG_DETAILS"), e);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private static class GITPropertiesPanel
    extends JPanel {
        private JLabel _lblName = new JLabel();
        private JTextField _fldName = new JTextField();
        private JLabel _lblId = new JLabel();
        private JTextField _fldId = new JTextField();
        private JLabel _lblUser = new JLabel();
        private JTextField _fldUser = new JTextField();
        private JLabel _lblMessage = new JLabel();
        private JTextArea _fldMessage = new JTextArea();
        private JLabel _lblTagObject = new JLabel();
        private JLabel _lblCommit = new JLabel();
        private JTextField _fldCommit = new JTextField();
        private JLabel _lblAuthor = new JLabel();
        private JTextField _fldAuthor = new JTextField();
        private JLabel _lblCommitMessage = new JLabel();
        private JTextArea _fldCommitMessage = new JTextArea();
        private GitTag _tag;
        private GitRevisionInfo _revision;

        GITPropertiesPanel(GitTag tag, GitRevisionInfo revision) {
            this._tag = tag;
            this._revision = revision;
            this.init();
            this.layoutComponents();
        }

        private void init() {
            ResourceUtils.resLabel((JLabel)this._lblName, (Component)this._fldName, (String)Resource.get("TAG_NAME"));
            this._fldName.setText(this._tag.getTagName());
            this.initField(this._fldName);
            if (!this._tag.isLightWeight()) {
                ResourceUtils.resLabel((JLabel)this._lblId, (Component)this._fldId, (String)Resource.get("TAG_ID"));
                ResourceUtils.resLabel((JLabel)this._lblUser, (Component)this._fldUser, (String)Resource.get("TAG_USER"));
                ResourceUtils.resLabel((JLabel)this._lblMessage, (Component)this._fldMessage, (String)Resource.get("TAG_MESSAGE"));
                this._fldId.setText(this._tag.getTagId());
                this._fldUser.setText(this._tag.getTagger().getName());
                this._fldMessage.setText(this._tag.getMessage());
                this._fldMessage.setRows(3);
                this.initField(this._fldId);
                this.initField(this._fldUser);
                this.initField(this._fldMessage);
            }
            this._lblTagObject.setText(Resource.get("TAG_COMMIT"));
            ResourceUtils.resLabel((JLabel)this._lblCommit, (Component)this._fldCommit, (String)Resource.get("TAG_COMMIT_ID"));
            ResourceUtils.resLabel((JLabel)this._lblAuthor, (Component)this._fldAuthor, (String)Resource.get("TAG_COMMIT_USER"));
            ResourceUtils.resLabel((JLabel)this._lblCommitMessage, (Component)this._fldCommitMessage, (String)Resource.get("TAG_COMMIT_MESSAGE"));
            this._fldCommit.setText(this._revision.getRevision());
            this._fldAuthor.setText(this._revision.getCommitter().getName());
            this._fldCommitMessage.setText(this._revision.getFullMessage());
            this._fldCommitMessage.setRows(3);
            this.initField(this._fldCommit);
            this.initField(this._fldAuthor);
            this.initField(this._fldCommitMessage);
        }

        private void initField(JTextComponent field) {
            field.setBorder(BorderFactory.createEmptyBorder());
            field.setBackground(UIManager.getColor("control"));
            field.setEditable(false);
        }

        private void layoutComponents() {
            JScrollPane pane;
            this.setLayout(new GridBagLayout());
            Insets fieldInsets = new Insets(5, 5, 5, 5);
            Insets largeInsets = new Insets(10, 5, 5, 5);
            int row = 0;
            this.add((Component)this._lblName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
            this.add((Component)this._fldName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            if (!this._tag.isLightWeight()) {
                this.add((Component)this._lblId, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
                this.add((Component)this._fldId, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
                this.add((Component)this._lblUser, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
                this.add((Component)this._fldUser, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
                this.add((Component)this._lblMessage, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
                pane = new JScrollPane(this._fldMessage);
                pane.setBorder(BorderFactory.createEmptyBorder());
                this.add((Component)pane, new GridBagConstraints(1, row, 1, 3, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
                row += 2;
            }
            this.add((Component)this._lblTagObject, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 17, 2, largeInsets, 0, 0));
            this.add((Component)this._lblCommit, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
            this.add((Component)this._fldCommit, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._lblAuthor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
            this.add((Component)this._fldAuthor, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._lblCommitMessage, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0));
            pane = new JScrollPane(this._fldCommitMessage);
            pane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)pane, new GridBagConstraints(1, row, 1, 3, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            row += 2;
            this.add((Component)new JPanel(), new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 17, 3, fieldInsets, 0, 0));
        }
    }
}

