/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.cmd.GITCommonRemoteCommand;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITRemotePanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;

public class GITAddRemoteCommand
extends GITCommonRemoteCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.git.add-remote";

    public GITAddRemoteCommand() {
        super(COMMAND_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl(VCSProfile profile) throws Exception {
        final URL root = this.getGitClientRoot(profile);
        final GITRemotePanel panel = new GITRemotePanel();
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
        dialog.setMinimumSize(400, 175);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("REMOTE_NAME_URL_DIALOG_HINT"));
        dialog.setDialogHeader((Component)header);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    return;
                }
                GITAddRemoteCommand.this.validateDialog(evt, panel, root);
                try {
                    GITAddRemoteCommand.this.addRemote(root, panel);
                }
                catch (GITProcessException e) {
                    GITAddRemoteCommand.this.getExceptionHandler().handleException((Exception)((Object)e));
                    throw new PropertyVetoException(e.getMessage(), evt);
                }
            }
        });
        try {
            if (dialog.runDialog()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GITRepositoryNavigator.getInstance().updateNavigator(root, false);
                    }
                });
                int n = 0;
                return n;
            }
        }
        finally {
            dialog.dispose();
        }
        return 1;
    }

    private void addRemote(URL root, GITRemotePanel panel) throws GITProcessException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remote");
            monitor.setLog(false);
            String name = panel.getRemoteName();
            ArrayList<String> furls = new ArrayList<String>();
            furls.add(panel.getFetchUrl());
            ArrayList<String> purls = new ArrayList<String>();
            purls.add(panel.getPushUrl().isEmpty() ? panel.getFetchUrl() : panel.getPushUrl());
            List<String> spec = Collections.emptyList();
            GitRemoteConfig config = new GitRemoteConfig(name, furls, purls, spec, spec);
            client.setRemote(config, monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITAddRemoteCommand.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.format("ERROR_FAILED_REMOTE", panel.getRemoteName(), e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private void validateDialog(PropertyChangeEvent evt, GITRemotePanel panel, URL root) throws PropertyVetoException {
        this.validateName(evt, panel);
        String url = panel.getPushUrl();
        if (!url.isEmpty()) {
            this.validateURL(evt, panel, url);
        }
        this.validateURL(evt, panel, panel.getFetchUrl());
        this.validateRemoteName(evt, panel, root);
    }
}

