/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITBranchComparator;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITBranchRemoteNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;

    GITBranchRemoteNode(GITConnectionInfo connectionInfo) {
        this._info = connectionInfo;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(connectionInfo.getRootURL()));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return Resource.get("NAV_NODE_REMOTE_BRANCH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            GitClient client = null;
            try {
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Branches");
                client = GITClientAdaptor.getClient(this._info.getRootURL());
                Map<String, GitBranch> branches = client.getBranches(true, monitor);
                if (monitor.getError() == null) {
                    GITProfile.getQualifiedLogger(GITBranchRemoteNode.class.getName()).log(Level.WARNING, monitor.getError());
                }
                if (monitor.hasFinished()) {
                    ArrayList<GitBranch> sortBranchs = new ArrayList<GitBranch>();
                    for (String key : branches.keySet()) {
                        GitBranch branch = branches.get(key);
                        if (!branch.isRemote()) continue;
                        sortBranchs.add(branch);
                    }
                    Collections.sort(sortBranchs, new GITBranchComparator());
                    Iterator sit = sortBranchs.iterator();
                    while (sit.hasNext()) {
                        this._children.add(new GITBranchNode((GitBranch)sit.next(), this._info.getRootURL()));
                    }
                }
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITBranchRemoteNode.class.getName()).log(Level.WARNING, e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("BRANCH_REMOTE_ICON")));
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITBranchRemoteNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

