/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITRevision {
    private GitRevisionInfo _info;
    private URL _url;
    private Collection<File> _files;

    public GITRevision(URL url, GitRevisionInfo info) {
        this._info = info;
        this._url = url;
    }

    String getMessage() {
        return this._info.getFullMessage();
    }

    public String getRevision() {
        return this._info.getRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<File> getFiles() {
        if (this._info.getParents().length != 2) {
            return null;
        }
        if (this._files != null) {
            return this._files;
        }
        this._files = new ArrayList<File>();
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(this._url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("revision");
            GitRevisionInfo gInfo = client.log(this._info.getRevision(), (ProgressMonitor)monitor);
            Map<File, GitRevisionInfo.GitFileInfo> files = gInfo.getModifiedFiles();
            files.keySet().stream().forEach(item -> this._files.add(new File(item.getPath())));
            Collection<File> collection = this._files;
            return collection;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITRevision.class.getName()).log(Level.WARNING, e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return Collections.emptyList();
    }
}

