/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.git.GITConnection;
import oracle.jdevimpl.vcs.git.auth.GITAuthHelper;
import oracle.jdevimpl.vcs.git.prefs.GITVersionToolsPrefs;

public class GITConnectionManager {
    private static final String AUTH_STORE_NUM = "git-auth-number";
    private static final int STORE = 10;
    private static GITConnectionManager _instance = null;
    private Map<String, GITConnection> _connections = Collections.synchronizedMap(new HashMap());
    private GITAuthHelper _authHelper = null;
    private Comparator _comparator = new ConnectionComparator();
    private Integer _store;
    private static boolean _save;

    public static final synchronized GITConnectionManager getInstance() {
        if (_instance == null) {
            _instance = new GITConnectionManager();
            _save = GITVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getSavePassPhrase();
        }
        return _instance;
    }

    public void putConnection(GITConnection connection) {
        if (this._connections.isEmpty()) {
            this.setupConnections();
        }
        connection.setTime(System.currentTimeMillis());
        this._connections.put(connection.getUrl(), connection);
        this.persistConnection();
    }

    public boolean remove(String url) {
        GITConnection conn = this.getConnection(url);
        if (conn != null) {
            this._connections.remove(url);
            this.persistConnection();
            return true;
        }
        return false;
    }

    public GITConnection getConnection(String url) {
        if (url == null) {
            return null;
        }
        this.setupConnections();
        GITConnection connect = this._connections.get(url);
        if (connect != null) {
            this.getAuthHelper().authentication(connect);
        }
        return connect;
    }

    public Collection<Pair<String, String>> getConnectionInfoList() {
        this.setupConnections();
        if (!this._connections.isEmpty()) {
            ArrayList<Pair<String, String>> infoLst = new ArrayList<Pair<String, String>>();
            for (String url : this._connections.keySet()) {
                GITConnection connect = this._connections.get(url);
                infoLst.add((Pair<String, String>)new Pair((Object)url, (Object)connect.getRemote()));
            }
            return infoLst;
        }
        return Collections.emptyList();
    }

    private void setupConnections() {
        if (this._authHelper == null) {
            Collection<GITConnection> connections = this.getAuthHelper().getConnections();
            for (GITConnection connect : connections) {
                this._connections.put(connect.getUrl(), connect);
            }
        }
    }

    private void persistConnection() {
        if (this._connections.values().size() < 10) {
            this.getAuthHelper().setPersistedConnections(this._connections.values());
            return;
        }
        ArrayList<GITConnection> sorted = new ArrayList<GITConnection>();
        sorted.addAll(this._connections.values());
        Collections.sort(sorted, this._comparator);
        for (int c = sorted.size(); c > this.getStoreNumber(); --c) {
            sorted.remove(c - 1);
        }
        this._authHelper.setPersistedConnections(sorted);
    }

    private synchronized GITAuthHelper getAuthHelper() {
        if (this._authHelper == null) {
            this._authHelper = new GITAuthHelper(_save);
        }
        return this._authHelper;
    }

    private int getStoreNumber() {
        if (this._store == null) {
            String st = System.getProperty(AUTH_STORE_NUM);
            this._store = st == null ? Integer.valueOf(10) : Integer.getInteger(st);
        }
        return this._store;
    }

    private static class ConnectionComparator
    implements Comparator {
        private ConnectionComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof GITConnection)) {
                return -1;
            }
            if (!(o2 instanceof GITConnection)) {
                return -1;
            }
            GITConnection c1 = (GITConnection)o1;
            GITConnection c2 = (GITConnection)o2;
            if (c1.getTime() < c2.getTime()) {
                return 1;
            }
            if (c1.getTime() > c2.getTime()) {
                return -1;
            }
            return 0;
        }
    }
}

