/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.Adapters;
import oracle.sql.NUMBER;

public class LRSGeometryG3D {
    private static final double JAVA_NULL_MEASURE = 1.0E100;
    private J3D_Geometry geom;
    private double[] measures;
    private double smax = 0.0;
    private double flat = 0.0;
    private double geog_crs_uom_factor = 1.0;

    public static Struct defineG3D(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6) throws SQLException, Exception {
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.structToLRSGeometryG3D(struct, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        lRSGeometryG3D.populateMeasure(nUMBER4.doubleValue(), nUMBER5.doubleValue(), nUMBER6.doubleValue());
        return LRSGeometryG3D.lrsGeometryG3DToSTRUCT(lRSGeometryG3D);
    }

    public static Struct locateG3D(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws SQLException, Exception {
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.structToLRSGeometryG3D(struct, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        LRSGeometryG3D lRSGeometryG3D2 = LRSGeometryG3D.locatePoint(lRSGeometryG3D, nUMBER4.doubleValue(), nUMBER5.doubleValue());
        return LRSGeometryG3D.lrsGeometryG3DToSTRUCT(lRSGeometryG3D2);
    }

    public static Struct clipG3D(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6) throws SQLException, Exception {
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.structToLRSGeometryG3D(struct, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        LRSGeometryG3D lRSGeometryG3D2 = LRSGeometryG3D.clip(lRSGeometryG3D, nUMBER4.doubleValue(), nUMBER5.doubleValue(), nUMBER6.doubleValue());
        return LRSGeometryG3D.lrsGeometryG3DToSTRUCT(lRSGeometryG3D2);
    }

    public static Struct projectG3D(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, Struct struct2, NUMBER nUMBER4) throws SQLException, Exception {
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.structToLRSGeometryG3D(struct, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        LRSGeometryG3D lRSGeometryG3D2 = LRSGeometryG3D.structToLRSGeometryG3D(struct2, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        LRSGeometryG3D lRSGeometryG3D3 = LRSGeometryG3D.projectPoint(lRSGeometryG3D, lRSGeometryG3D2, nUMBER4.doubleValue());
        return LRSGeometryG3D.lrsGeometryG3DToSTRUCT(lRSGeometryG3D3);
    }

    public static NUMBER lengthG3D(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4) throws SQLException, Exception {
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.structToLRSGeometryG3D(struct, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue());
        return new NUMBER(lRSGeometryG3D.getLength(nUMBER4.doubleValue()));
    }

    private static LRSGeometryG3D structToLRSGeometryG3D(Struct struct, double d, double d2, double d3) throws SQLException, Exception {
        if (struct == null) {
            return null;
        }
        Object[] objectArray = Adapters.toGeo3DLRSInfo((Struct)struct);
        if (objectArray == null) {
            return null;
        }
        J3D_Geometry j3D_Geometry = (J3D_Geometry)objectArray[0];
        double[] dArray = (double[])objectArray[1];
        LRSGeometryG3D lRSGeometryG3D = new LRSGeometryG3D(j3D_Geometry, dArray, d, d2, d3);
        if (dArray != null && dArray.length >= 2 && !lRSGeometryG3D.isDefined()) {
            double d4 = dArray[0];
            double d5 = dArray[dArray.length - 1];
            double d6 = 0.05;
            if (LRSGeometryG3D.isNullMeasure(d4) && LRSGeometryG3D.isNullMeasure(d5)) {
                lRSGeometryG3D.populateMeasure(0.0, lRSGeometryG3D.getLength(d6), d6);
            } else {
                lRSGeometryG3D.populateMeasure(d4, d5, d6);
            }
        }
        return lRSGeometryG3D;
    }

    private static Struct lrsGeometryG3DToSTRUCT(LRSGeometryG3D lRSGeometryG3D) throws SQLException, Exception {
        if (lRSGeometryG3D == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = lRSGeometryG3D.getGeometry();
        Object var2_2 = null;
        objectArray[1] = lRSGeometryG3D.getMeasures();
        return Adapters.toGeo3DLRSStruct((Object[])objectArray);
    }

    public LRSGeometryG3D(J3D_Geometry j3D_Geometry, double[] dArray, double d, double d2, double d3) {
        this.geom = (J3D_Geometry)j3D_Geometry.clone();
        if (dArray != null) {
            int n = dArray.length;
            this.measures = new double[n];
            System.arraycopy(dArray, 0, this.measures, 0, n);
        }
        this.smax = d;
        this.flat = d2;
        this.geog_crs_uom_factor = d3;
    }

    public boolean isDefined() {
        for (int i = 0; i < this.measures.length; ++i) {
            if (!LRSGeometryG3D.isNullMeasure(this.measures[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isLRSGeom() {
        return this.measures != null;
    }

    public double getLength(double d) throws Exception {
        return this.geom.length(d, "TRUE", this.smax, this.flat, this.geog_crs_uom_factor);
    }

    public double getSmax() {
        return this.smax;
    }

    public double getFlat() {
        return this.flat;
    }

    public double getGeogCrsUomFactor() {
        return this.geog_crs_uom_factor;
    }

    private double getLength(int n, double d) throws Exception {
        double d2 = 0.0;
        if (this.getNoOfElements() == 1 && n == 0) {
            return this.getLength(d);
        }
        int[] nArray = this.getElementPtIndexBounds(n);
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            d2 += this.segmentLength(i, d);
        }
        return d2;
    }

    public double getStartMeasure() {
        return this.measures[0];
    }

    public double getStartMeasure(int n) {
        int n2 = this.getElementPtIndexBounds(n)[0];
        return this.measures[n2];
    }

    public boolean validMeasure(double d) {
        for (int i = 0; i < this.getNoOfElements(); ++i) {
            int n;
            double d2;
            int[] nArray = this.getElementPtIndexBounds(i);
            int n2 = nArray[0];
            double d3 = this.measures[n2];
            if (!((d - d3) * ((d2 = this.measures[n = nArray[1]]) - d) >= 0.0)) continue;
            return true;
        }
        return false;
    }

    public double getEndMeasure() {
        return this.measures[this.measures.length - 1];
    }

    public double getEndMeasure(int n) {
        int n2 = this.getElementPtIndexBounds(n)[1];
        return this.measures[n2];
    }

    private static double[] locatePoint(int n, double[] dArray, double[] dArray2, double d, double d2) throws Exception {
        if (d == 0.0) {
            return dArray;
        }
        if (d == 1.0) {
            return dArray2;
        }
        if (LRSGeometryG3D.isSamePoint(dArray, dArray2)) {
            return dArray;
        }
        J3D_Geometry j3D_Geometry = LRSGeometryG3D.createLineGeom3D(n, dArray, dArray2);
        J3D_Geometry j3D_Geometry2 = J3D_Geometry.findPointOnGeodetic3DLineSegment(j3D_Geometry, d);
        return j3D_Geometry2.getOrdinatesArray();
    }

    public static LRSGeometryG3D locatePoint(LRSGeometryG3D lRSGeometryG3D, double d, double d2) throws Exception {
        Object var5_3 = null;
        if (lRSGeometryG3D == null || lRSGeometryG3D.getGeometry() == null || lRSGeometryG3D.getMeasures() == null) {
            return null;
        }
        int n = lRSGeometryG3D.getMeasureIndex(d);
        if (n == -1) {
            return null;
        }
        J3D_Geometry j3D_Geometry = lRSGeometryG3D.getGeometry();
        int n2 = j3D_Geometry.getDimensions();
        double d3 = lRSGeometryG3D.getMeasure(n);
        double d4 = lRSGeometryG3D.getMeasure(n + 1);
        double d5 = (d - d3) / (d4 - d3);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        if (d == d3) {
            d5 = 0.0;
        }
        if (d == d4) {
            d5 = 1.0;
        }
        System.arraycopy(j3D_Geometry.getOrdinatesArray(), n * n2, dArray, 0, n2);
        System.arraycopy(j3D_Geometry.getOrdinatesArray(), (n + 1) * n2, dArray2, 0, n2);
        double[] dArray3 = LRSGeometryG3D.locatePoint(j3D_Geometry.getSRID(), dArray, dArray2, d5, d2);
        return LRSGeometryG3D.craeteLRSPtGeom3D(j3D_Geometry.getSRID(), dArray3[0], dArray3[1], dArray3[2], d, lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
    }

    public static LRSGeometryG3D clip(LRSGeometryG3D lRSGeometryG3D, double d, double d2, double d3) throws Exception {
        double d4;
        if (lRSGeometryG3D == null || lRSGeometryG3D.getGeometry() == null || lRSGeometryG3D.getMeasures() == null) {
            return null;
        }
        if (d == d2) {
            return LRSGeometryG3D.locatePoint(lRSGeometryG3D, d, d3);
        }
        int n = lRSGeometryG3D.getElementIndexWithMeasure(d);
        int n2 = lRSGeometryG3D.getElementIndexWithMeasure(d2);
        if (n == -1 || n2 == -1) {
            return null;
        }
        if (lRSGeometryG3D.getStartMeasure() > lRSGeometryG3D.getEndMeasure()) {
            if (d < d2) {
                d4 = d;
                d = d2;
                d2 = d4;
            }
        } else if (d > d2) {
            d4 = d;
            d = d2;
            d2 = d4;
        }
        ArrayList<LRSGeometryG3D> arrayList = new ArrayList<LRSGeometryG3D>();
        if (n == n2) {
            arrayList.add(lRSGeometryG3D.clipElement(n, d, d2, d3));
        } else {
            double d5 = lRSGeometryG3D.getEndMeasure(n);
            double d6 = 0.0;
            LRSGeometryG3D lRSGeometryG3D2 = lRSGeometryG3D.clipElement(n, d, d5, d3);
            if (lRSGeometryG3D2 != null) {
                arrayList.add(lRSGeometryG3D2);
            }
            for (int i = n + 1; i <= n2 - 1; ++i) {
                d6 = lRSGeometryG3D.getStartMeasure(i);
                LRSGeometryG3D lRSGeometryG3D3 = lRSGeometryG3D.clipElement(i, d6, d5 = lRSGeometryG3D.getEndMeasure(i), d3);
                if (lRSGeometryG3D3 == null) continue;
                arrayList.add(lRSGeometryG3D3);
            }
            d6 = lRSGeometryG3D.getStartMeasure(n2);
            LRSGeometryG3D lRSGeometryG3D4 = lRSGeometryG3D.clipElement(n2, d6, d2, d3);
            if (lRSGeometryG3D4 != null) {
                arrayList.add(lRSGeometryG3D4);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        LRSGeometryG3D lRSGeometryG3D5 = (LRSGeometryG3D)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            lRSGeometryG3D5 = LRSGeometryG3D.concatenate(lRSGeometryG3D5, (LRSGeometryG3D)arrayList.get(i), true);
        }
        return lRSGeometryG3D5;
    }

    public static LRSGeometryG3D concatenate(LRSGeometryG3D lRSGeometryG3D, LRSGeometryG3D lRSGeometryG3D2, boolean bl) {
        int n;
        Object[] objectArray;
        int n2;
        if (lRSGeometryG3D == null) {
            if (lRSGeometryG3D2 == null) {
                return null;
            }
            return (LRSGeometryG3D)lRSGeometryG3D2.clone();
        }
        if (lRSGeometryG3D2 == null) {
            if (lRSGeometryG3D == null) {
                return null;
            }
            return (LRSGeometryG3D)lRSGeometryG3D.clone();
        }
        int n3 = lRSGeometryG3D.getGeometry().getSRID();
        double[] dArray = null;
        double[] dArray2 = null;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (n2 = 0; n2 < lRSGeometryG3D.getNoOfElements(); ++n2) {
            objectArray = lRSGeometryG3D.getElementPoints(n2);
            arrayList.add((double[])objectArray);
        }
        for (n2 = 0; n2 < lRSGeometryG3D2.getNoOfElements(); ++n2) {
            objectArray = lRSGeometryG3D2.getElementPoints(n2);
            arrayList.add((double[])objectArray);
        }
        n2 = 3002;
        if (arrayList.size() >= 2) {
            n2 = 3006;
        }
        objectArray = new int[]{1, 2, 1};
        int n4 = 1;
        for (n = 1; n < arrayList.size(); ++n) {
            objectArray = LRSGeometryG3D.appendIntArray((int[])objectArray, new int[]{n4 += ((double[])arrayList.get(n - 1)).length, 2, 1});
        }
        dArray = LRSGeometryG3D.appendDoubleArray(dArray, (double[])arrayList.get(0));
        for (n = 1; n < arrayList.size(); ++n) {
            dArray = LRSGeometryG3D.appendDoubleArray(dArray, (double[])arrayList.get(n));
        }
        Object var10_11 = null;
        if (bl) {
            double d = lRSGeometryG3D.getEndMeasure() - lRSGeometryG3D2.getStartMeasure();
            dArray2 = LRSGeometryG3D.appendDoubleArray(lRSGeometryG3D.getMeasures(), LRSGeometryG3D.shiftDoubleArray(lRSGeometryG3D2.getMeasures(), d));
        } else {
            dArray2 = LRSGeometryG3D.appendDoubleArray(lRSGeometryG3D.getMeasures(), lRSGeometryG3D2.getMeasures());
        }
        return new LRSGeometryG3D(new J3D_Geometry(n2, n3, (int[])objectArray, dArray), dArray2, lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
    }

    private void shiftMeasures(double d) {
        if (this.measures != null) {
            int n = 0;
            while (n < this.measures.length) {
                int n2 = n++;
                this.measures[n2] = this.measures[n2] + d;
            }
        }
    }

    private LRSGeometryG3D clipElement(int n, double d, double d2, double d3) throws Exception {
        if (d == d2) {
            return null;
        }
        double[] dArray = this.getElementPoints(n);
        int[] nArray = this.getElementPtIndexBounds(n);
        double[] dArray2 = null;
        int n2 = this.getMeasureIndex(n, d);
        int n3 = this.getMeasureIndex(n, d2);
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        int n4 = this.geom.getSRID();
        dArray2 = this.getMeasures(n2, n2 + 1);
        double d4 = (d - dArray2[0]) / (dArray2[1] - dArray2[0]);
        dArray2 = this.getMeasures(n3, n3 + 1);
        double d5 = (d2 - dArray2[0]) / (dArray2[1] - dArray2[0]);
        double[] dArray3 = LRSGeometryG3D.locatePoint(n4, this.getPoint(n2), this.getPoint(n2 + 1), d4, d3);
        double[] dArray4 = LRSGeometryG3D.locatePoint(n4, this.getPoint(n3), this.getPoint(n3 + 1), d5, d3);
        double[] dArray5 = null;
        int[] nArray2 = new int[]{1, 2, 1};
        if (n2 == n3) {
            dArray5 = LRSGeometryG3D.appendDoubleArray(dArray3, dArray4);
            dArray2 = new double[]{d, d2};
        } else {
            double d6 = this.getMeasure(n2 + 1);
            double d7 = this.getMeasure(n3);
            boolean bl = true;
            boolean bl2 = true;
            if (d == d6) {
                bl = false;
            }
            if (d2 == d7) {
                bl2 = false;
            }
            dArray5 = this.getPoints(n2 + 1, n3);
            dArray2 = this.getMeasures(n2 + 1, n3);
            if (bl) {
                dArray5 = LRSGeometryG3D.appendDoubleArray(dArray3, dArray5);
                dArray2 = LRSGeometryG3D.appendDoubleArray(new double[]{d}, dArray2);
            }
            if (bl2) {
                dArray5 = LRSGeometryG3D.appendDoubleArray(dArray5, dArray4);
                dArray2 = LRSGeometryG3D.appendDoubleArray(dArray2, new double[]{d2});
            }
        }
        return LRSGeometryG3D.createLRSGeom3D(n4, dArray5, nArray2, dArray2, this.smax, this.flat, this.geog_crs_uom_factor);
    }

    private static boolean isSamePoint(int n, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) throws Exception {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        double[] dArray4 = null;
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i];
            dArray3[i + dArray.length] = dArray2[i];
        }
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.craeteLRSLineGeom3D(n, dArray3, dArray4, d2, d3, d4);
        return lRSGeometryG3D.getLength(d) <= d;
    }

    private static boolean isSamePoint(double[] dArray, double[] dArray2) {
        return Math.abs(dArray[0] - dArray2[0]) <= 1.0E-8 && Math.abs(dArray[1] - dArray2[1]) <= 1.0E-8 && Math.abs(dArray[2] - dArray2[2]) <= 1.0E-5;
    }

    private static double[] appendDoubleArray(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = 0;
        if (dArray != null) {
            n = dArray.length;
        }
        if (dArray2 != null) {
            n2 = dArray2.length;
        }
        double[] dArray3 = new double[n + n2];
        if (dArray != null) {
            System.arraycopy(dArray, 0, dArray3, 0, n);
        }
        if (dArray2 != null) {
            System.arraycopy(dArray2, 0, dArray3, n, n2);
        }
        return dArray3;
    }

    private static double[] shiftDoubleArray(double[] dArray, double d) {
        double[] dArray2 = null;
        if (dArray != null) {
            dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray2[n2] = dArray2[n2] + d;
            }
        }
        return dArray2;
    }

    private static int[] appendIntArray(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        if (nArray != null) {
            n = nArray.length;
        }
        if (nArray2 != null) {
            n2 = nArray2.length;
        }
        int[] nArray3 = new int[n + n2];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray3, 0, n);
        }
        if (nArray2 != null) {
            System.arraycopy(nArray2, 0, nArray3, n, n2);
        }
        return nArray3;
    }

    private static int getDistanceSign(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = dArray2[0];
        double d2 = dArray[0];
        double d3 = dArray3[1];
        double d4 = dArray[1];
        double d5 = dArray2[1];
        double d6 = dArray3[0];
        double d7 = (d - d2) * (d3 - d4) - (d5 - d4) * (d6 - d2);
        if (d7 == 0.0) {
            return 0;
        }
        if (d7 > 0.0) {
            return 1;
        }
        return -1;
    }

    public static LRSGeometryG3D projectPoint(LRSGeometryG3D lRSGeometryG3D, LRSGeometryG3D lRSGeometryG3D2, double d) throws Exception {
        double[] dArray;
        double[] dArray2;
        int n = lRSGeometryG3D.getGeometry().getDimensions();
        int n2 = lRSGeometryG3D.getGeometry().getSRID();
        double[] dArray3 = new double[n];
        LRSGeometryG3D lRSGeometryG3D3 = null;
        JGeometry jGeometry = null;
        double d2 = Double.MAX_VALUE;
        int n3 = 0;
        int n4 = lRSGeometryG3D.getNoOfElements();
        int n5 = 0;
        J3D_Geometry j3D_Geometry = null;
        if (lRSGeometryG3D == null || lRSGeometryG3D.getGeometry() == null || lRSGeometryG3D.getMeasures() == null || lRSGeometryG3D2 == null || lRSGeometryG3D2.getGeometry() == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < n4 && !bl; ++i) {
            int n6 = lRSGeometryG3D.getNoOfPoints(i);
            for (int j = 0; j < n6 - 1 && !bl; ++j) {
                int n7 = n3 + j;
                dArray2 = lRSGeometryG3D.getPoint(n7);
                dArray = lRSGeometryG3D.getPoint(n7 + 1);
                double[] dArray4 = new double[3];
                if (LRSGeometryG3D.isSamePoint(dArray2, dArray)) {
                    dArray4[0] = dArray2[0];
                    dArray4[1] = dArray2[1];
                    dArray4[2] = dArray2[2];
                } else {
                    J3D_Geometry j3D_Geometry2 = LRSGeometryG3D.createLineGeom3D(n2, dArray2, dArray);
                    dArray4 = J3D_Geometry.CpaPtL3D(lRSGeometryG3D2.getGeometry(), j3D_Geometry2, d, "TRUE");
                }
                j3D_Geometry = new J3D_Geometry(1, n2, dArray4[3], dArray4[4], dArray4[5]);
                double d3 = lRSGeometryG3D2.getGeometry().distance(j3D_Geometry, d, "TRUE", lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
                if (!(d2 > d3)) continue;
                d2 = d3;
                n5 = n7;
                jGeometry = j3D_Geometry;
                if (d2 != 0.0) continue;
                bl = true;
            }
            n3 += n6;
        }
        double d4 = lRSGeometryG3D.getMeasure(n5);
        double d5 = lRSGeometryG3D.getMeasure(n5 + 1);
        dArray2 = lRSGeometryG3D.getPoint(n5);
        dArray = lRSGeometryG3D.getPoint(n5 + 1);
        System.arraycopy(jGeometry.getOrdinatesArray(), 0, dArray3, 0, n);
        double d6 = LRSGeometryG3D.lineSegmentLength(n2, dArray2, dArray, d, lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
        double d7 = LRSGeometryG3D.lineSegmentLength(n2, dArray2, dArray3, d, lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
        double d8 = d4 + (d5 - d4) * (d7 / d6);
        lRSGeometryG3D3 = new LRSGeometryG3D((J3D_Geometry)jGeometry, new double[]{d8}, lRSGeometryG3D.getSmax(), lRSGeometryG3D.getFlat(), lRSGeometryG3D.getGeogCrsUomFactor());
        int n8 = LRSGeometryG3D.getDistanceSign(dArray2, dArray, lRSGeometryG3D2.getGeometry().getOrdinatesArray());
        if (d2 == 0.0) {
            lRSGeometryG3D3.setSDOPoint(0.0, 0.0, 0.0);
        } else if (n8 == 1) {
            lRSGeometryG3D3.setSDOPoint(d2, 0.0, 0.0);
        } else {
            lRSGeometryG3D3.setSDOPoint(-d2, 0.0, 0.0);
        }
        return lRSGeometryG3D3;
    }

    private double[] getMeasures() {
        return this.measures;
    }

    private double[] getMeasures(int n, int n2) {
        double[] dArray = new double[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            dArray[i - n] = this.getMeasure(i);
        }
        return dArray;
    }

    private J3D_Geometry getGeometry() {
        return this.geom;
    }

    private int getMeasureIndex(double d) {
        int n = this.getElementIndexWithMeasure(d);
        if (n < 0) {
            return -1;
        }
        double d2 = this.getStartMeasure(n);
        double d3 = this.getEndMeasure(n);
        int n2 = this.getElementPtIndexBounds(n)[0];
        int n3 = this.getElementPtIndexBounds(n)[1];
        while (n3 - n2 > 1) {
            int n4 = (n2 + n3) / 2;
            double d4 = this.measures[n4];
            if ((d - d2) * (d4 - d) >= 0.0) {
                n3 = n4;
                d3 = d4;
                continue;
            }
            n2 = n4;
            d2 = d4;
        }
        return n2;
    }

    private int getMeasureIndex(int n, double d) {
        double d2 = this.getStartMeasure(n);
        double d3 = this.getEndMeasure(n);
        int n2 = this.getElementPtIndexBounds(n)[0];
        int n3 = this.getElementPtIndexBounds(n)[1];
        while (n3 - n2 > 1) {
            int n4 = (n2 + n3) / 2;
            double d4 = this.measures[n4];
            if ((d - d2) * (d4 - d) >= 0.0) {
                n3 = n4;
                d3 = d4;
                continue;
            }
            n2 = n4;
            d2 = d4;
        }
        return n2;
    }

    private int getElementIndexWithMeasure(double d) {
        for (int i = 0; i < this.getNoOfElements(); ++i) {
            int n;
            double d2;
            int[] nArray = this.getElementPtIndexBounds(i);
            int n2 = nArray[0];
            double d3 = this.measures[n2];
            if (!((d - d3) * ((d2 = this.measures[n = nArray[1]]) - d) >= 0.0)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNullMeasure(double d) {
        return d == 1.0E100 || Double.isNaN(d);
    }

    private boolean monotonicMeasure() {
        int n;
        int n2 = this.measures.length;
        double d = this.getStartMeasure();
        double d2 = this.getEndMeasure();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return false;
        }
        double[] dArray = new double[n2];
        System.arraycopy(this.measures, 0, dArray, 0, n2);
        for (n = 1; n < n2 - 1; ++n) {
            if (!Double.isNaN(dArray[n])) continue;
            dArray[n] = dArray[n - 1];
        }
        n = d < d2 ? 1 : 0;
        for (int i = 0; i < n2 - 1; ++i) {
            if (n != 0 && dArray[i] > dArray[i + 1]) {
                return false;
            }
            if (n != 0 || !(dArray[i] < dArray[i + 1])) continue;
            return false;
        }
        return true;
    }

    private static J3D_Geometry createLineGeom3D(int n, double[] dArray) {
        return new J3D_Geometry(3002, n, new int[]{1, 2, 1}, dArray);
    }

    private static J3D_Geometry createLineGeom3D(int n, double[] dArray, double[] dArray2) {
        int n2;
        double[] dArray3 = new double[dArray.length + dArray2.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray3[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray3[n2 + dArray.length] = dArray2[n2];
        }
        return new J3D_Geometry(3002, n, new int[]{1, 2, 1}, dArray3);
    }

    private static LRSGeometryG3D craeteLRSLineGeom3D(int n, double[] dArray, double[] dArray2, double d, double d2, double d3) {
        return new LRSGeometryG3D(LRSGeometryG3D.createLineGeom3D(n, dArray), dArray2, d, d2, d3);
    }

    private static LRSGeometryG3D craeteLRSPtGeom3D(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return new LRSGeometryG3D(new J3D_Geometry(3001, n, d, d2, d3), new double[]{d4}, d5, d6, d7);
    }

    private static LRSGeometryG3D createLRSGeom3D(int n, double[] dArray, int[] nArray, double[] dArray2, double d, double d2, double d3) {
        int n2 = 0;
        n2 = dArray2.length == 1 ? 3001 : (nArray.length == 3 ? 3002 : 3006);
        return new LRSGeometryG3D(new J3D_Geometry(n2, n, nArray, dArray), dArray2, d, d2, d3);
    }

    private void resetMeasures() {
        this.measures = new double[this.getNoOfPoints()];
        for (int i = 0; i < this.measures.length; ++i) {
            this.measures[i] = Double.NaN;
        }
    }

    private void populateMeasure(double d) throws Exception {
        double d2 = this.measures[0];
        double d3 = this.measures[this.measures.length - 1];
        double d4 = this.getLength(d);
        if (this.measures == null) {
            d2 = 0.0;
            d3 = d4;
        } else if (Double.isNaN(d2)) {
            if (Double.isNaN(d3)) {
                d2 = 0.0;
                d3 = d4;
            } else {
                d2 = d3 - d4;
                d3 = this.measures[this.measures.length - 1];
            }
        } else {
            d2 = this.measures[0];
            d3 = Double.isNaN(d3) ? d2 + d4 : this.measures[this.measures.length - 1];
        }
        this.populateMeasure(d2, d3, d);
    }

    private void populateMeasure(double d, double d2, double d3) throws Exception {
        if (this.geom == null || this.measures == null) {
            return;
        }
        this.measures[0] = d;
        this.measures[this.measures.length - 1] = d2;
        if (!this.monotonicMeasure()) {
            throw new Exception("13333");
        }
        double[] dArray = new double[this.measures.length];
        System.arraycopy(this.measures, 0, dArray, 0, this.measures.length);
        dArray[0] = d;
        dArray[dArray.length - 1] = d2;
        this.measures = null;
        double d4 = this.getLength(d3);
        int n = 0;
        double d5 = d2 - d;
        double d6 = d;
        double d7 = 0.0;
        for (int i = 0; i < this.getNoOfElements(); ++i) {
            int n2;
            double d8 = this.getLength(i, d3);
            int n3 = this.getNoOfPoints(i);
            d6 = !Double.isNaN(dArray[n]) ? dArray[n] : dArray[n - 1];
            d7 = !Double.isNaN(dArray[n + n3 - 1]) ? dArray[n + n3 - 1] : d6 + (d2 - d) * (d8 / d4);
            d5 = d7 - d6;
            double[] dArray2 = new double[n3];
            double d9 = 0.0;
            double[] dArray3 = new double[n3];
            dArray3[0] = 0.0;
            for (n2 = 1; n2 < n3; ++n2) {
                dArray3[n2] = this.segmentLength(n + (n2 - 1), d3);
            }
            dArray2[0] = d6;
            dArray2[n3 - 1] = d7;
            for (n2 = 1; n2 < n3 - 1; ++n2) {
                dArray2[n2] = d9 = d6 + d5 * (dArray3[n2] / d8);
                d6 = d9;
            }
            n += n3;
            d6 = d7;
            this.measures = LRSGeometryG3D.appendDoubleArray(this.measures, dArray2);
        }
    }

    private double[] getPoint(int n) {
        int n2 = this.geom.getDimensions();
        double[] dArray = new double[n2];
        System.arraycopy(this.geom.getOrdinatesArray(), n * 3, dArray, 0, n2);
        return dArray;
    }

    private double[] getElementPoints(int n) {
        int n2 = this.geom.getDimensions();
        int n3 = this.getNoOfPoints(n);
        double[] dArray = new double[n2 * n3];
        int n4 = this.getElementPtIndexBounds(n)[0];
        System.arraycopy(this.geom.getOrdinatesArray(), n4 * n2, dArray, 0, n2 * n3);
        return dArray;
    }

    private double[] getPoints(int n, int n2) {
        int n3 = this.geom.getDimensions();
        int n4 = n2 - n + 1;
        double[] dArray = new double[n3 * n4];
        System.arraycopy(this.geom.getOrdinatesArray(), n * n3, dArray, 0, n3 * n4);
        return dArray;
    }

    private double getMeasure(int n) {
        return this.measures[n];
    }

    private int getNoOfPoints() {
        return this.geom.getNumPoints();
    }

    private int getNoOfPoints(int n) {
        int[] nArray = this.getElementPtIndexBounds(n);
        return nArray[1] - nArray[0] + 1;
    }

    private boolean isValid() {
        return true;
    }

    private static double lineSegmentLength(int n, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) throws Exception {
        int n2;
        double[] dArray3 = new double[dArray.length + dArray2.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray3[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray3[n2 + dArray.length] = dArray2[n2];
        }
        J3D_Geometry j3D_Geometry = new J3D_Geometry(3002, n, new int[]{1, 2, 1}, dArray3);
        return j3D_Geometry.length(d, "TRUE", d2, d3, d4);
    }

    private double segmentLength(int n, double d) throws Exception {
        int n2 = n;
        double[] dArray = this.getPoint(n2);
        double[] dArray2 = this.getPoint(n2 + 1);
        return LRSGeometryG3D.lineSegmentLength(this.geom.getSRID(), dArray, dArray2, d, this.smax, this.flat, this.geog_crs_uom_factor);
    }

    private int getNoOfElements() {
        return this.geom.getElemInfo().length / 3;
    }

    private int[] getElementPtIndexBounds(int n) {
        int[] nArray = this.geom.getElemInfo();
        int n2 = this.geom.getOrdinatesArray().length;
        int n3 = this.getNoOfElements();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.geom.getDimensions();
        if (n > n3 - 1 || n < 0) {
            return null;
        }
        n4 = (nArray[n * 3] - 1) / n6;
        n5 = n == n3 - 1 ? n2 / n6 - 1 : (nArray[(n + 1) * 3] - 1) / n6 - 1;
        return new int[]{n4, n5};
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.geom == null) {
            stringBuffer.append("Null Geometry");
        } else {
            stringBuffer.append("LRSGeometry: \nGTYPE:" + this.geom.getType() + "\nSRID:" + this.geom.getSRID());
            stringBuffer.append("\nsmax:" + this.smax + " flat:" + this.flat + " geog_crs_uom_factor:" + this.geog_crs_uom_factor);
            if (this.geom.getLabelPointXYZ() != null) {
                stringBuffer.append("\nsdo_point(" + this.geom.getLabelPointXYZ()[0] + "," + this.geom.getLabelPointXYZ()[1] + "," + this.geom.getLabelPointXYZ()[2] + ")");
            }
            stringBuffer.append("\nElem Info Array:(");
            int[] nArray = this.geom.getElemInfo();
            int n = this.geom.getDimensions();
            for (int i = 0; i < this.geom.getElemInfo().length; ++i) {
                stringBuffer.append(nArray[i] + " ");
            }
            stringBuffer.append(")\n");
            double[] dArray = this.geom.getOrdinatesArray();
            stringBuffer.append("Ordinate Array:(");
            for (int i = 0; i < dArray.length / n; ++i) {
                stringBuffer.append("\n(" + dArray[i * n] + ", " + dArray[i * n + 1] + ", " + dArray[i * n + 2]);
                if (this.measures == null) {
                    stringBuffer.append(") ");
                    continue;
                }
                if (LRSGeometryG3D.isNullMeasure(this.measures[i])) {
                    stringBuffer.append(", [NULL]) ");
                    continue;
                }
                stringBuffer.append(", [" + this.measures[i] + "]) ");
            }
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }

    private void print() {
        System.out.print(this.geom);
    }

    public Object clone() {
        J3D_Geometry j3D_Geometry = null;
        if (this.geom == null) {
            return null;
        }
        j3D_Geometry = (J3D_Geometry)this.geom.clone();
        double[] dArray = null;
        if (this.measures != null) {
            dArray = new double[this.measures.length];
            System.arraycopy(this.measures, 0, dArray, 0, this.measures.length);
        }
        return new LRSGeometryG3D(j3D_Geometry, dArray, this.smax, this.flat, this.geog_crs_uom_factor);
    }

    private double[] segmentLengths(double d) throws Exception {
        int n;
        int n2 = this.getNoOfElements();
        int n3 = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getNoOfPoints(i);
            for (n = 0; n < n4 - 1; ++n) {
                double d2 = this.segmentLength(n + n3, d);
                arrayList.add(d2);
            }
            n3 += n4;
        }
        double[] dArray = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n] = (Double)arrayList.get(n);
        }
        return dArray;
    }

    private static LRSGeometryG3D createLargeGeometry(int n) throws Exception {
        int n2 = 4987;
        double d = 6378135.0;
        double d2 = 0.003352779454167505;
        double d3 = 1.0;
        double d4 = 0.05;
        double[] dArray = new double[n * 3];
        double[] dArray2 = new double[]{1.0, 2.0, 1.0};
        double[] dArray3 = new double[n];
        for (int i = 0; i <= n - 1; ++i) {
            dArray[i * 3] = 1.0 / (double)n * 90.0 * (double)i;
            dArray[i * 3 + 1] = 0.0;
            dArray[i * 3 + 2] = 0.0;
            dArray3[i] = i;
        }
        return LRSGeometryG3D.craeteLRSLineGeom3D(n2, dArray, dArray3, d, d2, d3);
    }

    private void setSDOPoint(double d, double d2, double d3) {
        this.geom.x = d;
        this.geom.y = d2;
        this.geom.z = d3;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 4987;
        double d = 6378135.0;
        double d2 = 0.003352779454167505;
        double d3 = 1.0;
        double d4 = 0.05;
        double d5 = 200.0;
        LRSGeometryG3D lRSGeometryG3D = LRSGeometryG3D.craeteLRSLineGeom3D(n, new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 1.0, 1.0, 0.0}, new double[]{0.0, d5 * 0.5, d5}, d, d2, d3);
        LRSGeometryG3D lRSGeometryG3D2 = LRSGeometryG3D.craeteLRSLineGeom3D(n, new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 1.0, 1.0, 0.0}, new double[]{0.0, Double.NaN, d5}, d, d2, d3);
        LRSGeometryG3D lRSGeometryG3D3 = LRSGeometryG3D.craeteLRSLineGeom3D(n, new double[]{2.0, 2.0, 0.0, 2.5, 2.5, 0.0, 3.0, 3.0, 0.0}, new double[]{d5 * 2.0, Double.NaN, d5 * 3.0}, d, d2, d3);
        System.out.println(lRSGeometryG3D2);
        System.out.println(lRSGeometryG3D3);
        System.out.println(lRSGeometryG3D);
        lRSGeometryG3D.populateMeasure(d4);
        System.out.println(lRSGeometryG3D);
        LRSGeometryG3D lRSGeometryG3D4 = LRSGeometryG3D.locatePoint(lRSGeometryG3D, d5 * 0.5, d4);
        System.out.println("Locaet Pt at m =  " + d5 * 0.5 + "\n" + lRSGeometryG3D4);
        System.out.println("Locaet Pt at m =  " + d5 * 0.0 + "\n" + LRSGeometryG3D.locatePoint(lRSGeometryG3D, d5 * 0.0, d4));
        System.out.println("Locaet Pt at m =  " + d5 + " \n" + LRSGeometryG3D.locatePoint(lRSGeometryG3D, d5, d4));
        System.out.println("Clip Pt at (" + d5 * 0.25 + "," + d5 * 0.75 + ") \n" + LRSGeometryG3D.clip(lRSGeometryG3D, d5 * 0.25, d5 * 0.75, d4));
        System.out.println("Clip Pt at (" + d5 * 0.0 + "," + d5 + ") \n" + LRSGeometryG3D.clip(lRSGeometryG3D, d5 * 0.0, d5, d4));
        System.out.println("Project pt :\n" + LRSGeometryG3D.projectPoint(lRSGeometryG3D, lRSGeometryG3D4, d4));
        LRSGeometryG3D lRSGeometryG3D5 = LRSGeometryG3D.craeteLRSLineGeom3D(n, new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 0.75, 0.75, 0.0, 1.0, 1.0, 0.0}, new double[]{0.0, Double.NaN, Double.NaN, d5}, d, d2, d3);
        System.out.println("monotonic LRS before populating :" + lRSGeometryG3D5.monotonicMeasure());
        lRSGeometryG3D5.populateMeasure(0.0, d5, d4);
        System.out.println(lRSGeometryG3D5);
        System.out.println("monotonic LRS after populating :" + lRSGeometryG3D5.monotonicMeasure());
        int n2 = 250000;
        long l = System.currentTimeMillis();
        LRSGeometryG3D lRSGeometryG3D6 = LRSGeometryG3D.createLargeGeometry(n2);
        System.out.println("create large geometry took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...");
        l = System.currentTimeMillis();
        lRSGeometryG3D4 = LRSGeometryG3D.locatePoint(lRSGeometryG3D6, (double)n2 * 0.05, d4);
        System.out.println("locate point  took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D4);
        LRSGeometryG3D lRSGeometryG3D7 = LRSGeometryG3D.projectPoint(lRSGeometryG3D6, lRSGeometryG3D4, d4);
        System.out.println("project pt(on the geometry) took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D7);
        l = System.currentTimeMillis();
        lRSGeometryG3D4 = LRSGeometryG3D.locatePoint(lRSGeometryG3D6, (double)n2 * 0.995, d4);
        System.out.println("locate point  took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D4);
        System.out.println("project pt(on the geometry) took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D7);
        l = System.currentTimeMillis();
        lRSGeometryG3D4 = LRSGeometryG3D.craeteLRSPtGeom3D(n, 0.0, 0.5, 0.0, 0.0, d, d2, d3);
        lRSGeometryG3D7 = LRSGeometryG3D.projectPoint(lRSGeometryG3D6, lRSGeometryG3D4, d4);
        System.out.println("project pt(off geometry) took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D7);
        l = System.currentTimeMillis();
        lRSGeometryG3D4 = LRSGeometryG3D.craeteLRSPtGeom3D(n, 45.0, -0.5, 0.0, 0.0, d, d2, d3);
        lRSGeometryG3D7 = LRSGeometryG3D.projectPoint(lRSGeometryG3D6, lRSGeometryG3D4, d4);
        System.out.println("project pt(off geometry) took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D7);
        l = System.currentTimeMillis();
        lRSGeometryG3D4 = LRSGeometryG3D.craeteLRSPtGeom3D(n, 89.0, 0.5, 0.0, 0.0, d, d2, d3);
        lRSGeometryG3D7 = LRSGeometryG3D.projectPoint(lRSGeometryG3D6, lRSGeometryG3D4, d4);
        System.out.println("project pt(off geometry) took:" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec...\n" + lRSGeometryG3D7);
    }
}

